/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.Build;
import com.liferay.jenkins.results.parser.JenkinsMaster;
import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.JenkinsSlave;
import com.liferay.jenkins.results.parser.NotificationUtil;
import com.liferay.jenkins.results.parser.TopLevelBuild;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SlaveOfflineRule {
    protected Pattern consolePattern;
    protected String name;
    protected String notificationRecipients;
    protected String offlineSibling;
    protected boolean shutdown;
    private static final Pattern _configurationsPattern = Pattern.compile("([^=]+)=(.*)");
    private static List<SlaveOfflineRule> _slaveOfflineRules;

    public static List<SlaveOfflineRule> getSlaveOfflineRules() {
        if (_slaveOfflineRules != null) {
            return _slaveOfflineRules;
        }
        Properties buildProperties = null;
        try {
            buildProperties = JenkinsResultsParserUtil.getBuildProperties();
        }
        catch (IOException ioException) {
            throw new RuntimeException("Unable to load slave offline rules", ioException);
        }
        _slaveOfflineRules = new ArrayList<SlaveOfflineRule>();
        for (Object propertyNameObject : buildProperties.keySet()) {
            String propertyName = propertyNameObject.toString();
            if (!propertyName.startsWith("slave.offline.rule[")) continue;
            String ruleName = propertyName.substring("slave.offline.rule[".length(), propertyName.lastIndexOf("]"));
            _slaveOfflineRules.add(new SlaveOfflineRule(buildProperties.getProperty(propertyName), ruleName));
        }
        return _slaveOfflineRules;
    }

    public String getName() {
        return this.name;
    }

    public String getNotificationRecipients() {
        return this.notificationRecipients;
    }

    public boolean getOfflineSibling() {
        return Boolean.parseBoolean(this.offlineSibling);
    }

    public boolean matches(Build build) {
        if (this.consolePattern != null) {
            String consoleText = build.getConsoleText();
            if (JenkinsResultsParserUtil.isNullOrEmpty(consoleText)) {
                return false;
            }
            for (String line : consoleText.split("\n")) {
                Matcher matcher = this.consolePattern.matcher(line);
                if (!matcher.find()) continue;
                System.out.println(JenkinsResultsParserUtil.combine("Build ", build.getBuildURL(), " matched with ", "slave offline rule ", this.getName(), ".\nMatching console log line:\n", line));
                return true;
            }
            return false;
        }
        System.out.println(JenkinsResultsParserUtil.combine("Slave offline rule ", this.getName(), " has a null console pattern"));
        return false;
    }

    public boolean shutdown() {
        return this.shutdown;
    }

    public void takeSlaveOffline(Build build) {
        String pinnedMessage = "";
        if (!this.shutdown) {
            pinnedMessage = "PINNED\n";
        }
        JenkinsSlave jenkinsSlave = build.getJenkinsSlave();
        JenkinsMaster jenkinsMaster = jenkinsSlave.getJenkinsMaster();
        String slaveOfflineRuleString = this.toString();
        slaveOfflineRuleString = slaveOfflineRuleString.replace("\\", "\\\\");
        String message = JenkinsResultsParserUtil.combine(pinnedMessage, this.getName(), " failure detected at ", build.getBuildURL(), ". \n\n", slaveOfflineRuleString, "\n\n\nOffline Slave URL: ", jenkinsSlave.getComputerURL(), "\n");
        if (this.getOfflineSibling() && jenkinsMaster.getSlavesPerHost() == 2) {
            Set<JenkinsSlave> siblingJenkinsSlaves = jenkinsSlave.getSiblings();
            for (JenkinsSlave siblingJenkinsSlave : siblingJenkinsSlaves) {
                message = JenkinsResultsParserUtil.combine(message, "Offline Slave URL: ", siblingJenkinsSlave.getComputerURL(), "\n");
                String siblingMessage = JenkinsResultsParserUtil.combine(pinnedMessage, "Offline Sibling: ", jenkinsSlave.getName(), " Reason: ", this.getName());
                siblingJenkinsSlave.takeSlavesOffline(siblingMessage);
            }
        }
        System.out.println(message);
        TopLevelBuild topLevelBuild = build.getTopLevelBuild();
        if (topLevelBuild != null) {
            message = JenkinsResultsParserUtil.combine(message, "Top Level Build URL: ", topLevelBuild.getBuildURL());
        }
        jenkinsSlave.takeSlavesOffline(message);
        if (this.notificationRecipients != null && !this.notificationRecipients.isEmpty()) {
            NotificationUtil.sendEmail(message, "jenkins", "Slave offline", this.notificationRecipients);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.consolePattern != null) {
            sb.append("console=");
            sb.append(this.consolePattern.pattern());
            sb.append("\n");
        }
        sb.append("name=");
        sb.append(this.name);
        sb.append("\n");
        if (this.notificationRecipients != null) {
            sb.append("notificationRecipients=");
            sb.append(this.notificationRecipients);
            sb.append("\n");
        }
        if (this.offlineSibling != null) {
            sb.append("offlineSibling=");
            sb.append(this.offlineSibling);
            sb.append("\n");
        }
        return sb.toString();
    }

    protected Map<String, String> parseConfigurations(String configurations) {
        String[] configurationsArray = configurations.split("\\s*\n\\s*");
        HashMap<String, String> configurationsMap = new HashMap<String, String>(configurationsArray.length);
        for (String configuration : configurationsArray) {
            Matcher matcher = _configurationsPattern.matcher(configuration);
            if (!matcher.matches()) {
                throw new RuntimeException(JenkinsResultsParserUtil.combine("Unable to parse configuration in slave offline ", "rule \"", this.getName(), "\"\n", configuration));
            }
            String value = matcher.group(2);
            if (value == null || value.isEmpty()) continue;
            configurationsMap.put(matcher.group(1), value);
        }
        return configurationsMap;
    }

    protected void validateRequiredConfigurationParameter(Map<String, String> configurationsMap, String parameterName) {
        if (!configurationsMap.containsKey(parameterName)) {
            throw new IllegalStateException(JenkinsResultsParserUtil.combine("Unable to detect required configuration \"", parameterName, " in slave offline rule \"", this.getName(), "\""));
        }
    }

    private SlaveOfflineRule(String configurations, String ruleName) {
        this.name = ruleName;
        Map<String, String> configurationsMap = this.parseConfigurations(configurations);
        this.validateRequiredConfigurationParameter(configurationsMap, "console");
        this.consolePattern = Pattern.compile(configurationsMap.get("console"));
        this.validateRequiredConfigurationParameter(configurationsMap, "notificationRecipients");
        this.notificationRecipients = configurationsMap.get("notificationRecipients");
        this.offlineSibling = configurationsMap.get("offlineSiblings");
        this.shutdown = configurationsMap.containsKey("shutdown") ? Boolean.parseBoolean(configurationsMap.get("shutdown")) : false;
    }
}

