/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import java.util.Map;

public class StatsDMetricsUtil {
    public static String generateCountMetric(String metricName, int metricValue, Map<String, String> labels) {
        if (metricValue < 0) {
            System.out.println("Count metric values must not be negative");
            return null;
        }
        return JenkinsResultsParserUtil.combine(metricName, ":", String.valueOf(metricValue), "|c", StatsDMetricsUtil.generateMetricLabels(labels));
    }

    public static String generateGaugeDeltaMetric(String metricName, int metricValue, Map<String, String> labels) {
        if (metricValue == 0) {
            System.out.println("Gauge metric values must not be zero");
            return null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(metricName);
        sb.append(":");
        if (metricValue < 0) {
            sb.append("-");
        } else {
            sb.append("+");
        }
        sb.append(Math.abs(metricValue));
        sb.append("|g");
        sb.append(StatsDMetricsUtil.generateMetricLabels(labels));
        return sb.toString();
    }

    public static String generateMetricLabels(Map<String, String> labels) {
        if (labels == null || labels.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("|#");
        for (Map.Entry<String, String> label : labels.entrySet()) {
            sb.append(label.getKey());
            sb.append(":");
            sb.append(label.getValue());
            sb.append(",");
        }
        sb.setLength(sb.length() - 1);
        return sb.toString();
    }

    public static String generateTimerMetric(String metricName, long metricValue, Map<String, String> labels) {
        if (metricValue <= 0L) {
            System.out.println("Timer metric values must greater than zero");
            return null;
        }
        return JenkinsResultsParserUtil.combine(metricName, ":", String.valueOf(metricValue), "|c", StatsDMetricsUtil.generateMetricLabels(labels));
    }
}

