/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.StopWatchRecord;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONObject;

public class StopWatchRecordsGroup
implements Iterable<StopWatchRecord> {
    private long _startTimestamp;
    private final Map<String, StopWatchRecord> _stopWatchRecordsMap = new HashMap<String, StopWatchRecord>();

    public StopWatchRecordsGroup() {
    }

    public StopWatchRecordsGroup(JSONObject buildResultJSONObject) {
        if (buildResultJSONObject == null || !buildResultJSONObject.has("duration")) {
            return;
        }
        StopWatchRecord stopWatchRecord = new StopWatchRecord("total.duration", this._startTimestamp, buildResultJSONObject.getLong("duration"));
        this._startTimestamp += 1000L;
        this.add(stopWatchRecord);
        if (!buildResultJSONObject.has("stopWatchRecords")) {
            return;
        }
        JSONArray stopWatchRecordsJSONArray = buildResultJSONObject.getJSONArray("stopWatchRecords");
        for (int i = 0; i < stopWatchRecordsJSONArray.length(); ++i) {
            JSONObject childStopWatchRecordJSONObject = stopWatchRecordsJSONArray.getJSONObject(i);
            this._startTimestamp += 1000L;
            long startTimestamp = childStopWatchRecordJSONObject.optLong("startTimestamp", this._startTimestamp);
            if (!childStopWatchRecordJSONObject.has("duration") || !childStopWatchRecordJSONObject.has("name")) continue;
            childStopWatchRecordJSONObject.put("startTimestamp", startTimestamp);
            StopWatchRecord childStopWatchRecord = new StopWatchRecord(childStopWatchRecordJSONObject);
            stopWatchRecord.addChildStopWatchRecord(childStopWatchRecord);
            this.add(childStopWatchRecord);
            this._addChildStopWatchRecords(childStopWatchRecord, childStopWatchRecordJSONObject);
        }
    }

    public void add(StopWatchRecord newStopWatchRecord) {
        this._stopWatchRecordsMap.put(newStopWatchRecord.getName(), newStopWatchRecord);
    }

    public StopWatchRecord get(String name) {
        return this._stopWatchRecordsMap.get(name);
    }

    public List<StopWatchRecord> getAllStopWatchRecords() {
        return new ArrayList<StopWatchRecord>(this._stopWatchRecordsMap.values());
    }

    public JSONArray getJSONArray() {
        JSONArray jsonArray = new JSONArray();
        for (StopWatchRecord stopWatchRecord : this.getStopWatchRecords()) {
            jsonArray.put((Object)stopWatchRecord.getJSONObject());
        }
        return jsonArray;
    }

    public List<StopWatchRecord> getStopWatchRecords() {
        ArrayList<StopWatchRecord> allStopWatchRecords = new ArrayList<StopWatchRecord>(this._stopWatchRecordsMap.values());
        Collections.sort(allStopWatchRecords);
        ArrayList<StopWatchRecord> parentStopWatchRecords = new ArrayList<StopWatchRecord>();
        for (StopWatchRecord stopWatchRecord : allStopWatchRecords) {
            for (StopWatchRecord parentStopWatchRecord : parentStopWatchRecords) {
                if (!parentStopWatchRecord.isParentOf(stopWatchRecord)) continue;
                parentStopWatchRecord.addChildStopWatchRecord(stopWatchRecord);
                break;
            }
            if (stopWatchRecord.getParentStopWatchRecord() != null) continue;
            parentStopWatchRecords.add(stopWatchRecord);
        }
        return parentStopWatchRecords;
    }

    public boolean isEmpty() {
        return this._stopWatchRecordsMap.isEmpty();
    }

    @Override
    public Iterator<StopWatchRecord> iterator() {
        List<StopWatchRecord> list = this.getStopWatchRecords();
        return list.iterator();
    }

    public int size() {
        List<StopWatchRecord> stopWatchRecords = this.getStopWatchRecords();
        return stopWatchRecords.size();
    }

    private void _addChildStopWatchRecords(StopWatchRecord stopWatchRecord, JSONObject stopWatchRecordJSONObject) {
        if (!stopWatchRecordJSONObject.has("childStopWatchRecords")) {
            return;
        }
        JSONArray childStopWatchRecordsJSONArray = stopWatchRecordJSONObject.getJSONArray("childStopWatchRecords");
        for (int i = 0; i < childStopWatchRecordsJSONArray.length(); ++i) {
            JSONObject childStopWatchRecordJSONObject = childStopWatchRecordsJSONArray.getJSONObject(i);
            childStopWatchRecordJSONObject.put("startTimestamp", this._startTimestamp);
            this._startTimestamp += 1000L;
            StopWatchRecord childStopWatchRecord = new StopWatchRecord(childStopWatchRecordJSONObject);
            this.add(childStopWatchRecord);
            stopWatchRecord.addChildStopWatchRecord(childStopWatchRecord);
            this._addChildStopWatchRecords(childStopWatchRecord, childStopWatchRecordJSONObject);
        }
    }
}

