/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.GitRepositoryJob;
import com.liferay.jenkins.results.parser.GitWorkingDirectory;
import com.liferay.jenkins.results.parser.GitWorkingDirectoryFactory;
import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.Job;
import com.liferay.jenkins.results.parser.PortalGitWorkingDirectory;
import com.liferay.jenkins.results.parser.SubrepositoryGitWorkingDirectory;
import com.liferay.jenkins.results.parser.SubrepositoryTestClassJob;
import java.io.File;
import java.io.IOException;
import org.json.JSONObject;

public class SubrepositoryGitRepositoryJob
extends GitRepositoryJob
implements SubrepositoryTestClassJob {
    protected PortalGitWorkingDirectory portalGitWorkingDirectory;
    protected boolean validationRequired;
    private final String _portalUpstreamBranchName;
    private final String _repositoryName;
    private final String _upstreamBranchName;

    @Override
    public GitWorkingDirectory getGitWorkingDirectory() {
        if (this.gitWorkingDirectory != null) {
            return this.gitWorkingDirectory;
        }
        this.checkGitRepositoryDir();
        this.gitWorkingDirectory = GitWorkingDirectoryFactory.newGitWorkingDirectory(this._upstreamBranchName, this.gitRepositoryDir.getPath());
        return this.gitWorkingDirectory;
    }

    @Override
    public JSONObject getJSONObject() {
        if (this.jsonObject != null) {
            return this.jsonObject;
        }
        this.jsonObject = super.getJSONObject();
        this.jsonObject.put("portal_upstream_branch_name", (Object)this._portalUpstreamBranchName);
        this.jsonObject.put("repository_name", (Object)this._repositoryName);
        this.jsonObject.put("upstream_branch_name", (Object)this._upstreamBranchName);
        return this.jsonObject;
    }

    @Override
    public PortalGitWorkingDirectory getPortalGitWorkingDirectory() {
        if (this.portalGitWorkingDirectory == null) {
            this.portalGitWorkingDirectory = GitWorkingDirectoryFactory.newPortalGitWorkingDirectory(this._portalUpstreamBranchName);
        }
        return this.portalGitWorkingDirectory;
    }

    @Override
    public SubrepositoryGitWorkingDirectory getSubrepositoryGitWorkingDirectory() {
        GitWorkingDirectory gitWorkingDirectory = this.getGitWorkingDirectory();
        if (!(gitWorkingDirectory instanceof SubrepositoryGitWorkingDirectory)) {
            throw new RuntimeException("Invalid subrepository Git working directory");
        }
        return (SubrepositoryGitWorkingDirectory)gitWorkingDirectory;
    }

    @Override
    public boolean isValidationRequired() {
        return this.validationRequired;
    }

    @Override
    public void setGitRepositoryDir(File repositoryDir) {
        String dirName = repositoryDir.getName();
        if (!dirName.endsWith("-private")) {
            dirName = dirName + "-private";
            repositoryDir = new File(repositoryDir.getParentFile(), dirName);
        }
        super.setGitRepositoryDir(repositoryDir);
    }

    protected SubrepositoryGitRepositoryJob(Job.BuildProfile buildProfile, String jobName, String portalUpstreamBranchName, String repositoryName, String upstreamBranchName) {
        super(buildProfile, jobName, upstreamBranchName);
        this._portalUpstreamBranchName = portalUpstreamBranchName;
        this._repositoryName = repositoryName;
        this._upstreamBranchName = upstreamBranchName;
        this._initialize();
    }

    protected SubrepositoryGitRepositoryJob(JSONObject jsonObject) {
        super(jsonObject);
        this._repositoryName = jsonObject.getString("repository_name");
        this._portalUpstreamBranchName = jsonObject.getString("portal_upstream_branch_name");
        this._upstreamBranchName = jsonObject.getString("upstream_branch_name");
        this._initialize();
    }

    private void _initialize() {
        this.gitWorkingDirectory = GitWorkingDirectoryFactory.newSubrepositoryGitWorkingDirectory(this._upstreamBranchName, this._repositoryName);
        this.setGitRepositoryDir(this.gitWorkingDirectory.getWorkingDirectory());
        this.checkGitRepositoryDir();
        PortalGitWorkingDirectory portalGitWorkingDirectory = this.getPortalGitWorkingDirectory();
        this.jobPropertiesFiles.add(new File(portalGitWorkingDirectory.getWorkingDirectory(), "test.properties"));
        this.jobPropertiesFiles.add(new File(this.gitWorkingDirectory.getWorkingDirectory(), "test.properties"));
        try {
            this.jobPropertiesFiles.add(new File(JenkinsResultsParserUtil.combine(JenkinsResultsParserUtil.getProperty(JenkinsResultsParserUtil.getBuildProperties(), "base.repository.dir"), "/liferay-jenkins-ee/commands/dependencies", "/test-subrepository-batch.properties")));
        }
        catch (IOException ioException) {
            throw new RuntimeException("Unable to get build properties", ioException);
        }
    }
}

