/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.BasePortalTestBatch;
import com.liferay.jenkins.results.parser.BatchBuildData;
import com.liferay.jenkins.results.parser.DefaultPortalTestBatch;
import com.liferay.jenkins.results.parser.FunctionalPortalTestBatch;
import com.liferay.jenkins.results.parser.JunitPortalTestBatch;
import com.liferay.jenkins.results.parser.MethodLogger;
import com.liferay.jenkins.results.parser.ModulesPortalTestBatch;
import com.liferay.jenkins.results.parser.PlaywrightPortalTestBatch;
import com.liferay.jenkins.results.parser.PortalBatchBuildData;
import com.liferay.jenkins.results.parser.TestBatch;
import com.liferay.jenkins.results.parser.Workspace;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;

public class TestBatchFactory {
    public static TestBatch newTestBatch(BatchBuildData batchBuildData, Workspace workspace) {
        BasePortalTestBatch testBatch = null;
        if (batchBuildData instanceof PortalBatchBuildData) {
            PortalBatchBuildData portalBatchBuildData = (PortalBatchBuildData)batchBuildData;
            String batchName = batchBuildData.getBatchName();
            if (batchName.contains("functional")) {
                testBatch = new FunctionalPortalTestBatch(portalBatchBuildData, workspace);
            } else if (batchName.startsWith("integration") || batchName.startsWith("modules-integration") || batchName.startsWith("modules-unit") || batchName.startsWith("unit")) {
                testBatch = new JunitPortalTestBatch(portalBatchBuildData, workspace);
            } else if (batchName.startsWith("js-unit") || batchName.startsWith("modules-compile") || batchName.startsWith("modules-semantic-versioning") || batchName.startsWith("rest-builder") || batchName.startsWith("service-builder")) {
                testBatch = new ModulesPortalTestBatch(portalBatchBuildData, workspace);
            } else {
                if (batchName.startsWith("playwright-js")) {
                    return new PlaywrightPortalTestBatch(portalBatchBuildData, workspace);
                }
                testBatch = new DefaultPortalTestBatch(portalBatchBuildData, workspace);
            }
        }
        if (testBatch == null) {
            throw new RuntimeException("Unsuppported batch");
        }
        return (TestBatch)Proxy.newProxyInstance(TestBatch.class.getClassLoader(), new Class[]{TestBatch.class}, (InvocationHandler)new MethodLogger(testBatch));
    }
}

