/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.BatchHistory;
import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.JobHistory;
import com.liferay.jenkins.results.parser.TestTaskHistory;
import org.json.JSONObject;

public class TestHistory {
    private final long _averageDuration;
    private final long _averageOverheadDuration;
    private final BatchHistory _batchHistory;
    private final int _failureCount;
    private final int _statusChanges;
    private final int _testCount;
    private final String _testName;
    private final long _testrayCaseResultID;
    private final String _testTaskName;

    public long getAverageDuration() {
        return this._averageDuration;
    }

    public long getAverageOverheadDuration() {
        return this._averageOverheadDuration;
    }

    public BatchHistory getBatchHistory() {
        return this._batchHistory;
    }

    public int getFailureCount() {
        return this._failureCount;
    }

    public int getStatusChanges() {
        return this._statusChanges;
    }

    public long getTestCount() {
        return this._testCount;
    }

    public String getTestName() {
        return this._testName;
    }

    public long getTestrayCaseResultID() {
        return this._testrayCaseResultID;
    }

    public String getTestrayCaseResultURL() {
        long testrayCaseResultID = this.getTestrayCaseResultID();
        if (testrayCaseResultID <= 0L) {
            return null;
        }
        BatchHistory batchHistory = this.getBatchHistory();
        if (batchHistory == null) {
            return null;
        }
        JobHistory jobHistory = batchHistory.getJobHistory();
        if (jobHistory == null) {
            return null;
        }
        return JenkinsResultsParserUtil.combine(String.valueOf(jobHistory.getTestrayURL()), "/home/-/testray/case_results/", String.valueOf(testrayCaseResultID), "/history");
    }

    public TestTaskHistory getTestTaskHistory() {
        return this._batchHistory.getTestTaskHistory(this.getTestTaskName());
    }

    public String getTestTaskName() {
        return this._testTaskName;
    }

    protected TestHistory(BatchHistory batchHistory, JSONObject jsonObject) {
        this._batchHistory = batchHistory;
        this._averageDuration = jsonObject.optLong("averageDuration");
        this._averageOverheadDuration = jsonObject.optLong("averageOverheadDuration");
        this._failureCount = jsonObject.optInt("failureCount");
        this._statusChanges = jsonObject.optInt("statusChanges");
        this._testName = jsonObject.getString("testName");
        this._testCount = jsonObject.optInt("testCount");
        this._testrayCaseResultID = jsonObject.optLong("testrayCaseResultID");
        this._testTaskName = jsonObject.optString("testTaskName");
    }
}

