/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.DownstreamBuildReport;
import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.StopWatchRecord;
import com.liferay.jenkins.results.parser.StopWatchRecordsGroup;
import com.liferay.jenkins.results.parser.TestClassReport;
import com.liferay.jenkins.results.parser.TestReport;
import com.liferay.jenkins.results.parser.TopLevelBuildReport;
import com.liferay.jenkins.results.parser.testray.TestrayBuild;
import com.liferay.jenkins.results.parser.testray.TestrayCaseResult;
import com.liferay.jenkins.results.parser.testray.TestrayCaseType;
import com.liferay.jenkins.results.parser.testray.TestrayFactory;
import com.liferay.jenkins.results.parser.testray.TestrayRoutine;
import com.liferay.jenkins.results.parser.testray.TestrayRun;
import com.liferay.jenkins.results.parser.testray.TestrayServer;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.json.JSONArray;
import org.json.JSONObject;

public class TestHistoryMap {
    private static final long _MAXIMUM_TEST_DURATION = 0x6DDD00L;
    private static List<String> _excludedTestNameRegexes;
    private static final Pattern _stopWatchGroupTestTaskNamePattern;
    private final Map<String, BatchHistory> _batchHistoryMap = new HashMap<String, BatchHistory>();
    private final TestrayBuild _latestTestrayBuild;
    private int _minimumStatusChanges = 3;
    private long _minimumTestDuration = 60000L;
    private final TestrayRoutine _testrayRoutine;

    public TestHistoryMap(TestrayRoutine testrayRoutine, int maxBuildCount) {
        this._testrayRoutine = testrayRoutine;
        long start = JenkinsResultsParserUtil.getCurrentTimeMillis();
        List<TestrayBuild> testrayBuilds = testrayRoutine.getTestrayBuilds(maxBuildCount, new String[0]);
        if (testrayBuilds.size() > maxBuildCount) {
            testrayBuilds = testrayBuilds.subList(0, maxBuildCount);
        }
        this._latestTestrayBuild = testrayBuilds.get(0);
        for (TestrayBuild testrayBuild : testrayBuilds) {
            TopLevelBuildReport topLevelBuildReport = testrayBuild.getTopLevelBuildReport();
            if (topLevelBuildReport == null || JenkinsResultsParserUtil.isNullOrEmpty(topLevelBuildReport.getResult())) continue;
            for (DownstreamBuildReport downstreamBuildReport : topLevelBuildReport.getDownstreamBuildReports()) {
                String batchName = downstreamBuildReport.getBatchName();
                BatchHistory batchHistory = this._batchHistoryMap.get(batchName);
                if (batchHistory == null) {
                    batchHistory = new BatchHistory(batchName);
                    this._batchHistoryMap.put(batchName, batchHistory);
                }
                batchHistory.addBuildReport(downstreamBuildReport);
            }
        }
        for (BatchHistory batchHistory : this._batchHistoryMap.values()) {
            TestrayCaseType testrayCaseType = batchHistory.getTestrayCaseType();
            TestrayRun testrayRun = batchHistory.getTestrayRun();
            if (testrayCaseType == null || testrayRun == null) continue;
            List<TestrayCaseResult> testrayCaseResults = this._latestTestrayBuild.getTestrayCaseResults(testrayCaseType, testrayRun);
            for (TestrayCaseResult testrayCaseResult : testrayCaseResults) {
                String testClassName = testrayCaseResult.getName();
                TestClassHistory testClassHistory = batchHistory.getTestClassHistory(testClassName);
                if (testClassHistory == null) continue;
                testClassHistory.setTestrayCaseResult(testrayCaseResult);
            }
        }
        System.out.println(JenkinsResultsParserUtil.combine("Test history map populated in ", JenkinsResultsParserUtil.toDurationString(JenkinsResultsParserUtil.getCurrentTimeMillis() - start)));
    }

    public TestrayBuild getLatestTestrayBuild() {
        return this._latestTestrayBuild;
    }

    public void setMinimumStatusChanges(int minimumStatusChanges) {
        this._minimumStatusChanges = minimumStatusChanges;
    }

    public void setMinimumTestDuration(long minimumTestDuration) {
        this._minimumTestDuration = minimumTestDuration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeCIHistoryJSONObjectFile(String filePath) throws IOException {
        JSONArray batchesJSONArray = new JSONArray();
        for (BatchHistory batchHistory : this._batchHistoryMap.values()) {
            JSONArray testsJSONArray = new JSONArray();
            for (TestClassHistory testClassHistory : batchHistory.getTestClassHistories()) {
                JSONObject testJSONObject = new JSONObject();
                testJSONObject.put("averageDuration", testClassHistory.getAverageDuration()).put("averageOverheadDuration", testClassHistory.getAverageOverheadDuration()).put("failureCount", testClassHistory.getFailureCount()).put("statusChanges", testClassHistory.getStatusChanges()).put("testCount", testClassHistory.getTestCount()).put("testName", (Object)testClassHistory.getTestClassName()).put("testTaskName", (Object)testClassHistory.getTestTaskName());
                TestrayCaseResult testrayCaseResult = testClassHistory.getTestrayCaseResult();
                if (testrayCaseResult != null) {
                    testJSONObject.put("testrayCaseResultID", testrayCaseResult.getID());
                }
                testsJSONArray.put((Object)testJSONObject);
            }
            JSONArray testTasksJSONArray = new JSONArray();
            for (TestTaskHistory testTaskHistory : batchHistory.getTestTaskHistories()) {
                JSONObject testJSONObject = new JSONObject();
                testJSONObject.put("averageDuration", testTaskHistory.getAverageDuration()).put("testTaskCount", testTaskHistory.getTestTaskCount()).put("testTaskName", (Object)testTaskHistory.getTestTaskName());
                testTasksJSONArray.put((Object)testJSONObject);
            }
            JSONObject jSONObject = new JSONObject();
            jSONObject.put("averageDuration", batchHistory.getAverageDuration()).put("batchName", (Object)batchHistory.getBatchName()).put("tests", (Object)testsJSONArray).put("testTasks", (Object)testTasksJSONArray);
            batchesJSONArray.put((Object)jSONObject);
        }
        JSONObject ciHistoryJSONObject = new JSONObject();
        ciHistoryJSONObject.put("batches", (Object)batchesJSONArray);
        TestrayServer testrayServer = this._latestTestrayBuild.getTestrayServer();
        ciHistoryJSONObject.put("testray_url", (Object)String.valueOf(testrayServer.getURL())).put("upstream_branch_name", (Object)this._latestTestrayBuild.getPortalBranch());
        File file = new File(filePath);
        File tempFile = new File(file.getParentFile(), JenkinsResultsParserUtil.getDistinctTimeStamp());
        try {
            JenkinsResultsParserUtil.write(tempFile, ciHistoryJSONObject.toString());
            JenkinsResultsParserUtil.gzip(tempFile, file);
        }
        finally {
            if (tempFile.exists()) {
                JenkinsResultsParserUtil.delete(tempFile);
            }
        }
    }

    public void writeDurationDataJavaScriptFile(String filePath, String batchNameRegex) throws IOException {
        JSONArray durationDataJSONArray = new JSONArray();
        durationDataJSONArray.put((Object)new String[]{"Name", "Batch Type", "Results", "Duration", "Average Duration"});
        for (BatchHistory batchHistory : this._batchHistoryMap.values()) {
            String batchName = batchHistory.getBatchName();
            if (!batchName.matches(batchNameRegex)) continue;
            for (TestHistory testHistory : batchHistory.getTestHistories()) {
                if (testHistory.getAverageDuration() <= this._minimumTestDuration) continue;
                JSONArray jsonArray = new JSONArray();
                jsonArray.put((Object)testHistory.getTestName());
                jsonArray.put((Object)testHistory.getBatchName());
                JSONArray durationJSONArray = new JSONArray();
                JSONArray statusesJSONArray = new JSONArray();
                long totalDuration = 0L;
                for (TestReport testReport : testHistory.getTestReports()) {
                    long duration = testReport.getDuration();
                    if (duration > 0x6DDD00L) continue;
                    totalDuration += duration;
                    durationJSONArray.put(duration);
                    JSONArray statusJSONArray = new JSONArray();
                    statusJSONArray.put((Object)this._fixStatus(testReport.getStatus()));
                    DownstreamBuildReport downstreamBuildReport = testReport.getDownstreamBuildReport();
                    statusJSONArray.put((Object)downstreamBuildReport.getBuildURL());
                    statusesJSONArray.put((Object)statusJSONArray);
                }
                jsonArray.put((Object)statusesJSONArray);
                jsonArray.put((Object)durationJSONArray);
                jsonArray.put(testHistory.getAverageDuration());
                durationDataJSONArray.put((Object)jsonArray);
            }
        }
        StringBuilder sb = new StringBuilder();
        sb.append("var durationData = ");
        sb.append(durationDataJSONArray);
        sb.append(";\nvar durationDataGeneratedDate = new Date(");
        sb.append(JenkinsResultsParserUtil.getCurrentTimeMillis());
        sb.append(");\nvar testrayRoutineURL = \"");
        sb.append(this._testrayRoutine.getURL());
        sb.append("\";\nvar testrayRoutineName = \"");
        sb.append(this._testrayRoutine.getName());
        sb.append("\";");
        JenkinsResultsParserUtil.write(filePath, sb.toString());
    }

    public void writeFlakyTestDataJavaScriptFile(String filePath) throws IOException {
        JSONArray flakyTestDataJSONArray = new JSONArray();
        flakyTestDataJSONArray.put((Object)new String[]{"Name", "Batch Type", "Results", "Status Changes"});
        for (BatchHistory batchHistory : this._batchHistoryMap.values()) {
            for (TestHistory testHistory : batchHistory.getTestHistories()) {
                if (!testHistory.isFlaky()) continue;
                JSONArray jsonArray = new JSONArray();
                jsonArray.put((Object)testHistory.getTestName());
                jsonArray.put((Object)testHistory.getBatchName());
                JSONArray statusesJSONArray = new JSONArray();
                for (TestReport testReport : testHistory.getTestReports()) {
                    JSONArray statusJSONArray = new JSONArray();
                    statusJSONArray.put((Object)this._fixStatus(testReport.getStatus()));
                    DownstreamBuildReport downstreamBuildReport = testReport.getDownstreamBuildReport();
                    statusJSONArray.put((Object)downstreamBuildReport.getBuildURL());
                    statusesJSONArray.put((Object)statusJSONArray);
                }
                jsonArray.put((Object)statusesJSONArray);
                jsonArray.put(testHistory.getStatusChanges());
                flakyTestDataJSONArray.put((Object)jsonArray);
            }
        }
        StringBuilder sb = new StringBuilder();
        sb.append("var flakyTestData = ");
        sb.append(flakyTestDataJSONArray);
        sb.append(";\nvar flakyTestDataGeneratedDate = new Date(");
        sb.append(JenkinsResultsParserUtil.getCurrentTimeMillis());
        sb.append(");\nvar testrayRoutineURL = \"");
        sb.append(this._testrayRoutine.getURL());
        sb.append("\";\nvar testrayRoutineName = \"");
        sb.append(this._testrayRoutine.getName());
        sb.append("\";");
        JenkinsResultsParserUtil.write(filePath, sb.toString());
    }

    private String _fixStatus(String status) {
        status = status.replace("REGRESSION", "FAILED");
        status = status.replace("FIXED", "PASSED");
        return status;
    }

    private List<String> _getExcludedTestNameRegexes() {
        if (_excludedTestNameRegexes != null) {
            return _excludedTestNameRegexes;
        }
        try {
            String excludedTestNames = JenkinsResultsParserUtil.getProperty(JenkinsResultsParserUtil.getBuildProperties(), "flaky.test.report.test.name.excludes");
            _excludedTestNameRegexes = Arrays.asList(excludedTestNames.split("\\s*,\\s*"));
        }
        catch (IOException ioException) {
            ioException.printStackTrace();
        }
        return _excludedTestNameRegexes;
    }

    static {
        _stopWatchGroupTestTaskNamePattern = Pattern.compile("test\\.execution\\.duration(?<testTaskName>\\..+)");
    }

    private class TestTaskHistory {
        private final List<Long> _testTaskDurations = new ArrayList<Long>();
        private final String _testTaskName;

        public TestTaskHistory(String testTaskName) {
            this._testTaskName = testTaskName;
        }

        public void addTestTaskDuration(long testTaskDuration) {
            if (testTaskDuration <= 0L || testTaskDuration >= 0x6DDD00L) {
                return;
            }
            this._testTaskDurations.add(testTaskDuration);
        }

        public long getAverageDuration() {
            if (this._testTaskDurations.isEmpty()) {
                return 0L;
            }
            long totalDuration = 0L;
            for (long testTaskDuration : this._testTaskDurations) {
                totalDuration += testTaskDuration;
            }
            return totalDuration / (long)this._testTaskDurations.size();
        }

        public int getTestTaskCount() {
            return this._testTaskDurations.size();
        }

        public String getTestTaskName() {
            return this._testTaskName;
        }
    }

    private class TestHistory {
        private final BatchHistory _batchHistory;
        private final String _testName;
        private final List<TestReport> _testReports = new ArrayList<TestReport>();

        public TestHistory(BatchHistory batchHistory, String testName) {
            this._batchHistory = batchHistory;
            this._testName = testName;
        }

        public void addTestReport(TestReport testReport) {
            this._testReports.add(testReport);
        }

        public long getAverageDuration() {
            long count = 0L;
            long totalDuration = 0L;
            for (TestReport testReport : this._testReports) {
                DownstreamBuildReport downstreamBuildReport = testReport.getDownstreamBuildReport();
                long duration = testReport.getDuration();
                if (duration <= 0L || duration >= 0x6DDD00L || duration >= downstreamBuildReport.getDuration()) continue;
                ++count;
                totalDuration += duration;
            }
            if (count == 0L) {
                return 0L;
            }
            return totalDuration / count;
        }

        public String getBatchName() {
            return this._batchHistory.getBatchName();
        }

        public int getStatusChanges() {
            int statusChanges = 0;
            String lastStatus = null;
            for (TestReport testReport : this._testReports) {
                String status = TestHistoryMap.this._fixStatus(testReport.getStatus());
                if (lastStatus == null) {
                    lastStatus = status;
                    continue;
                }
                if (lastStatus.equals(status)) continue;
                lastStatus = status;
                ++statusChanges;
            }
            return statusChanges;
        }

        public String getTestName() {
            return this._testName;
        }

        public List<TestReport> getTestReports() {
            return this._testReports;
        }

        public boolean isFlaky() {
            return this.getStatusChanges() >= TestHistoryMap.this._minimumStatusChanges;
        }
    }

    private class TestClassHistory {
        private final BatchHistory _batchHistory;
        private final String _testClassName;
        private final List<TestClassReport> _testClassReports = new ArrayList<TestClassReport>();
        private final Map<String, TestHistory> _testHistoryMap = new HashMap<String, TestHistory>();
        private TestrayCaseResult _testrayCaseResult;

        public TestClassHistory(BatchHistory batchHistory, String testClassName) {
            this._batchHistory = batchHistory;
            this._testClassName = testClassName;
        }

        public void addTestClassReport(TestClassReport testClassReport) {
            this._testClassReports.add(testClassReport);
            for (TestReport testReport : testClassReport.getTestReports()) {
                if (this._excludeTestReport(testReport)) continue;
                String testName = testReport.getTestName();
                TestHistory testHistory = this._testHistoryMap.get(testName);
                if (testHistory == null) {
                    testHistory = new TestHistory(this._batchHistory, testName);
                    this._testHistoryMap.put(testName, testHistory);
                }
                testHistory.addTestReport(testReport);
            }
        }

        public long getAverageDuration() {
            long count = 0L;
            long totalDuration = 0L;
            for (TestClassReport testClassReport : this._testClassReports) {
                DownstreamBuildReport downstreamBuildReport = testClassReport.getDownstreamBuildReport();
                long duration = testClassReport.getDuration();
                if (duration <= 0L || duration >= 0x6DDD00L || duration >= downstreamBuildReport.getDuration()) continue;
                ++count;
                totalDuration += duration;
            }
            if (count == 0L) {
                return 0L;
            }
            return totalDuration / count;
        }

        public long getAverageOverheadDuration() {
            long count = 0L;
            long totalOverheadDuration = 0L;
            for (TestClassReport testClassReport : this._testClassReports) {
                long overheadDuration = testClassReport.getOverheadDuration();
                if (overheadDuration > 0x6DDD00L) continue;
                ++count;
                totalOverheadDuration += overheadDuration;
            }
            if (count == 0L) {
                return 0L;
            }
            return totalOverheadDuration / count;
        }

        public int getFailureCount() {
            int failureCount = 0;
            for (TestClassReport testClassReport : this._testClassReports) {
                String status = TestHistoryMap.this._fixStatus(testClassReport.getStatus());
                if (Objects.equals(status, "PASSED")) continue;
                ++failureCount;
            }
            return failureCount;
        }

        public int getStatusChanges() {
            int statusChanges = 0;
            String lastStatus = null;
            for (TestClassReport testClassReport : this._testClassReports) {
                String status = TestHistoryMap.this._fixStatus(testClassReport.getStatus());
                if (lastStatus == null) {
                    lastStatus = status;
                    continue;
                }
                if (lastStatus.equals(status)) continue;
                lastStatus = status;
                ++statusChanges;
            }
            return statusChanges;
        }

        public String getTestClassName() {
            return this._testClassName;
        }

        public int getTestCount() {
            return this._testClassReports.size();
        }

        public List<TestHistory> getTestHistories() {
            return new ArrayList<TestHistory>(this._testHistoryMap.values());
        }

        public TestrayCaseResult getTestrayCaseResult() {
            return this._testrayCaseResult;
        }

        public String getTestTaskName() {
            if (this._testClassReports.isEmpty()) {
                return null;
            }
            TestClassReport testClassReport = this._testClassReports.get(0);
            if (testClassReport == null) {
                return null;
            }
            return testClassReport.getTestTaskName();
        }

        public void setTestrayCaseResult(TestrayCaseResult testrayCaseResult) {
            this._testrayCaseResult = testrayCaseResult;
        }

        private boolean _excludeTestReport(TestReport testReport) {
            String status = TestHistoryMap.this._fixStatus(testReport.getStatus());
            if (status.equals("SKIPPED")) {
                return true;
            }
            String testName = testReport.getTestName();
            if (testName.contains("PortalLogAssertorTest") || testName.contains("JenkinsLogAsserterTest")) {
                return true;
            }
            for (String excludedTestNameRegex : TestHistoryMap.this._getExcludedTestNameRegexes()) {
                if (!testName.matches(".*" + excludedTestNameRegex + ".*")) continue;
                return true;
            }
            return false;
        }
    }

    private class BatchHistory {
        private static final long _MAXIMUM_BATCH_DURATION = 86400000L;
        private final String _batchName;
        private final List<DownstreamBuildReport> _downstreamBuildReports = new ArrayList<DownstreamBuildReport>();
        private final Map<String, TestClassHistory> _testClassHistoryMap = new HashMap<String, TestClassHistory>();
        private TestrayCaseType _testrayCaseType;
        private TestrayRun _testrayRun;
        private final Map<String, TestTaskHistory> _testTaskHistoryMap = new HashMap<String, TestTaskHistory>();

        public BatchHistory(String batchName) {
            this._batchName = batchName;
        }

        public void addBuildReport(DownstreamBuildReport downstreamBuildReport) {
            this._downstreamBuildReports.add(downstreamBuildReport);
            for (TestClassReport testClassReport : downstreamBuildReport.getTestClassReports()) {
                if (this._excludeTestClassReport(testClassReport)) continue;
                String testClassName = testClassReport.getTestClassName();
                TestClassHistory testClassHistory = this._testClassHistoryMap.get(testClassName);
                if (testClassHistory == null) {
                    testClassHistory = new TestClassHistory(this, testClassName);
                    this._testClassHistoryMap.put(testClassName, testClassHistory);
                }
                testClassHistory.addTestClassReport(testClassReport);
            }
            StopWatchRecordsGroup stopWatchRecordsGroup = downstreamBuildReport.getStopWatchRecordsGroup();
            for (StopWatchRecord stopWatchRecord : stopWatchRecordsGroup.getAllStopWatchRecords()) {
                Matcher matcher = _stopWatchGroupTestTaskNamePattern.matcher(stopWatchRecord.getName());
                if (!matcher.find()) continue;
                String testTaskName = matcher.group("testTaskName");
                TestTaskHistory testTaskHistory = this._testTaskHistoryMap.get(testTaskName = testTaskName.replaceAll("\\.", ":"));
                if (testTaskHistory == null) {
                    testTaskHistory = new TestTaskHistory(testTaskName);
                }
                long testTaskDuration = stopWatchRecord.getDuration();
                for (TestClassReport testClassReport : downstreamBuildReport.getTestClassReports()) {
                    if (!Objects.equals(testTaskName, testClassReport.getTestTaskName())) continue;
                    testTaskDuration -= testClassReport.getDuration();
                }
                if (testTaskDuration <= 0L || testTaskDuration >= 0x6DDD00L) continue;
                testTaskHistory.addTestTaskDuration(testTaskDuration);
                this._testTaskHistoryMap.put(testTaskName, testTaskHistory);
            }
        }

        public long getAverageDuration() {
            long count = 0L;
            long totalDuration = 0L;
            for (DownstreamBuildReport downstreamBuildReport : this._downstreamBuildReports) {
                long duration = downstreamBuildReport.getDuration();
                if (duration > 86400000L) continue;
                ++count;
                totalDuration += duration;
            }
            if (count == 0L) {
                return 0L;
            }
            return totalDuration / count;
        }

        public String getBatchName() {
            return this._batchName;
        }

        public List<TestClassHistory> getTestClassHistories() {
            return new ArrayList<TestClassHistory>(this._testClassHistoryMap.values());
        }

        public TestClassHistory getTestClassHistory(String testClassName) {
            return this._testClassHistoryMap.get(testClassName);
        }

        public List<TestHistory> getTestHistories() {
            ArrayList<TestHistory> testHistories = new ArrayList<TestHistory>();
            for (TestClassHistory testClassHistory : this._testClassHistoryMap.values()) {
                testHistories.addAll(testClassHistory.getTestHistories());
            }
            return testHistories;
        }

        public TestrayCaseType getTestrayCaseType() {
            if (this._testrayCaseType != null) {
                return this._testrayCaseType;
            }
            try {
                String testrayCaseTypeName = JenkinsResultsParserUtil.getProperty(JenkinsResultsParserUtil.getBuildProperties(), "testray.case.type", this.getBatchName());
                if (JenkinsResultsParserUtil.isNullOrEmpty(testrayCaseTypeName)) {
                    return null;
                }
                TestrayServer testrayServer = TestHistoryMap.this._latestTestrayBuild.getTestrayServer();
                this._testrayCaseType = testrayServer.getTestrayCaseTypeByName(testrayCaseTypeName);
                return this._testrayCaseType;
            }
            catch (IOException ioException) {
                return null;
            }
        }

        public TestrayRun getTestrayRun() {
            if (this._testrayRun != null) {
                return this._testrayRun;
            }
            this._testrayRun = TestrayFactory.newTestrayRun(TestHistoryMap.this.getLatestTestrayBuild(), this.getBatchName(), new ArrayList<File>());
            return this._testrayRun;
        }

        public List<TestTaskHistory> getTestTaskHistories() {
            return new ArrayList<TestTaskHistory>(this._testTaskHistoryMap.values());
        }

        private boolean _excludeTestClassReport(TestClassReport testClassReport) {
            String status = TestHistoryMap.this._fixStatus(testClassReport.getStatus());
            if (status.equals("SKIPPED")) {
                return true;
            }
            String testClassName = testClassReport.getTestClassName();
            if (testClassName.contains("PortalLogAssertorTest") || testClassName.contains("JenkinsLogAsserterTest")) {
                return true;
            }
            for (String excludedTestNameRegex : TestHistoryMap.this._getExcludedTestNameRegexes()) {
                if (!testClassName.matches(".*" + excludedTestNameRegex + ".*")) continue;
                return true;
            }
            return false;
        }
    }
}

