/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.google.common.collect.Lists;
import com.liferay.jenkins.results.parser.Dom4JUtil;
import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;

public class TestrayResultsParserUtil {
    private static final long _BYTES_MAX_SIZE_TESTRAY_RESULT_FILE = 204800L;
    private static final int _COUNT_MAX_TESTCASE = 100;
    private static final String _EXTENSION_TESTRAY_RESULT_FILE = ".xml";
    private static final int _LENGTH_MAX_TESTCASE_FIELD = 2500;
    private static final String _NAME_TESTRAY_TESTCASE_STATUS_PROPERTY = "testray.testcase.status";

    public static void processTestrayResultFile(File file) throws DocumentException, IOException {
        Document document = Dom4JUtil.parse(JenkinsResultsParserUtil.read(file));
        Element rootElement = document.getRootElement();
        List summaryElements = rootElement.elements("summary");
        Dom4JUtil.detach(summaryElements.toArray());
        List testcaseElements = rootElement.elements("testcase");
        Dom4JUtil.detach(testcaseElements.toArray());
        rootElement.setText(rootElement.getTextTrim());
        List testcaseElementsPartitions = Lists.partition((List)testcaseElements, (int)100);
        ArrayList<File> partitionFiles = new ArrayList<File>(testcaseElementsPartitions.size());
        try {
            for (List testcaseElementsPartition : testcaseElementsPartitions) {
                Document partitionDocument = (Document)document.clone();
                for (Element testcaseElement : testcaseElementsPartition) {
                    Dom4JUtil.truncateElement(testcaseElement, 2500);
                }
                Element partitionRootElement = partitionDocument.getRootElement();
                Dom4JUtil.addToElement(partitionRootElement, testcaseElementsPartition.toArray());
                Dom4JUtil.addToElement(partitionRootElement, TestrayResultsParserUtil._getSummaryElement(testcaseElementsPartition));
                File partitionFile = new File(TestrayResultsParserUtil._getPartitionFilePath(file, testcaseElementsPartitions.indexOf(testcaseElementsPartition)));
                JenkinsResultsParserUtil.write(partitionFile, partitionDocument.asXML());
                partitionFiles.add(partitionFile);
            }
            file.delete();
        }
        catch (Exception exception) {
            for (File partitionFile : partitionFiles) {
                partitionFile.delete();
            }
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
            throw new RuntimeException(exception);
        }
        System.out.println(JenkinsResultsParserUtil.combine("The Testray result file '", file.getName(), "' has been split into ", String.valueOf(testcaseElementsPartitions.size()), " partitions."));
    }

    public static void processTestrayResultFiles(File dir) {
        FileFilter fileFilter = new FileFilter(){

            @Override
            public boolean accept(File file) {
                String name = file.getName();
                return !file.isDirectory() && name.endsWith(TestrayResultsParserUtil._EXTENSION_TESTRAY_RESULT_FILE) && file.length() > 204800L;
            }
        };
        for (File file : dir.listFiles(fileFilter)) {
            try {
                TestrayResultsParserUtil.processTestrayResultFile(file);
            }
            catch (Exception exception) {
                System.out.println(JenkinsResultsParserUtil.combine("Unable to process large Testray result file '", file.getName(), "'."));
                exception.printStackTrace();
            }
        }
    }

    private static String _getPartitionFilePath(File file, int partitionID) {
        String filePath = file.getAbsolutePath();
        String partitionPredicate = JenkinsResultsParserUtil.combine("_partition_", String.valueOf(partitionID), _EXTENSION_TESTRAY_RESULT_FILE);
        return filePath.replace(_EXTENSION_TESTRAY_RESULT_FILE, partitionPredicate);
    }

    private static Element _getSummaryElement(List<Element> testcaseElements) {
        Element summaryElement = Dom4JUtil.getNewElement("summary");
        int numPassed = 0;
        for (Element testcaseElement : testcaseElements) {
            String testrayTestcaseStatus = TestrayResultsParserUtil._getTestrayTestcaseStatus(testcaseElement);
            if (!testrayTestcaseStatus.equals("passed")) continue;
            ++numPassed;
        }
        Element passedPropertyElement = Dom4JUtil.getNewElement("property");
        passedPropertyElement.addAttribute("name", "passed");
        passedPropertyElement.addAttribute("value", String.valueOf(numPassed));
        Element failedPropertyElement = Dom4JUtil.getNewElement("property");
        failedPropertyElement.addAttribute("name", "failed");
        failedPropertyElement.addAttribute("value", String.valueOf(testcaseElements.size() - numPassed));
        Dom4JUtil.addToElement(summaryElement, passedPropertyElement, failedPropertyElement);
        return summaryElement;
    }

    private static String _getTestrayTestcaseStatus(Element testcaseElement) {
        String testrayTestcaseStatus = "";
        Element propertiesElement = testcaseElement.element("properties");
        List propertyElements = propertiesElement.elements("property");
        for (Element propertyElement : propertyElements) {
            if (!_NAME_TESTRAY_TESTCASE_STATUS_PROPERTY.equals(propertyElement.attributeValue("name", ""))) continue;
            testrayTestcaseStatus = propertyElement.attributeValue("value", "");
        }
        return testrayTestcaseStatus;
    }
}

