/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.JenkinsMaster;
import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.JobReport;
import com.liferay.jenkins.results.parser.URLTopLevelBuildReport;
import com.liferay.jenkins.results.parser.testray.TestrayBuild;
import java.io.File;
import java.io.IOException;
import java.net.URL;

public class TestrayTopLevelBuildReport
extends URLTopLevelBuildReport {
    private File _jenkinsConsoleLocalFile;
    private final String _startYearMonth;

    protected TestrayTopLevelBuildReport(TestrayBuild testrayBuild) {
        super(testrayBuild.getTopLevelBuildURL());
        this._startYearMonth = testrayBuild.getStartYearMonth();
    }

    @Override
    protected File getJenkinsConsoleLocalFile() {
        if (this._jenkinsConsoleLocalFile != null) {
            return this._jenkinsConsoleLocalFile;
        }
        JobReport jobReport = this.getJobReport();
        JenkinsMaster jenkinsMaster = jobReport.getJenkinsMaster();
        try {
            URL jenkinsConsoleURL = new URL(JenkinsResultsParserUtil.combine("https://storage.cloud.google.com/testray-results/", this.getStartYearMonth(), "/", jenkinsMaster.getName(), "/", jobReport.getJobName(), "/", String.valueOf(this.getBuildNumber()), "/jenkins-console.txt.gz"));
            File jenkinsConsoleLocalGzipFile = new File(System.getenv("WORKSPACE"), JenkinsResultsParserUtil.getDistinctTimeStamp() + ".gz");
            JenkinsResultsParserUtil.toFile(jenkinsConsoleURL, jenkinsConsoleLocalGzipFile);
            File jenkinsConsoleLocalFile = new File(System.getenv("WORKSPACE"), JenkinsResultsParserUtil.getDistinctTimeStamp());
            JenkinsResultsParserUtil.unGzip(jenkinsConsoleLocalGzipFile, jenkinsConsoleLocalFile);
            this._jenkinsConsoleLocalFile = jenkinsConsoleLocalFile;
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
        return this._jenkinsConsoleLocalFile;
    }

    @Override
    protected String getStartYearMonth() {
        return this._startYearMonth;
    }
}

