/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class URLCompareUtil {
    private static final Pattern _queryPattern = Pattern.compile("(&|\\A)?(?<name>[^=]+)=(?<value>[^&]+)");

    public static boolean matches(URL url1, URL url2) {
        return Objects.equals(url1.getProtocol(), url2.getProtocol()) && Objects.equals(url1.getHost(), url2.getHost()) && Objects.equals(URLCompareUtil._getPort(url1), URLCompareUtil._getPort(url2)) && Objects.equals(URLCompareUtil._normalizePath(url1.getPath()), URLCompareUtil._normalizePath(url2.getPath())) && Objects.equals(URLCompareUtil._getQueryMap(url1), URLCompareUtil._getQueryMap(url2));
    }

    private static int _getPort(URL url) {
        int port = url.getPort();
        if (port == -1) {
            port = url.getDefaultPort();
        }
        return port;
    }

    private static Map<String, String> _getQueryMap(URL url) {
        String query = url.getQuery();
        if (query == null) {
            return Collections.emptyMap();
        }
        HashMap<String, String> queryMap = new HashMap<String, String>();
        Matcher matcher = _queryPattern.matcher(query);
        while (matcher.find()) {
            queryMap.put(matcher.group("name"), matcher.group("value"));
        }
        return queryMap;
    }

    private static String _normalizePath(String path) {
        String normalizedPath = path.replaceAll("/{2,}", "/");
        return normalizedPath.replaceAll("/*$", "");
    }
}

