/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.BaseTopLevelBuildReport;
import com.liferay.jenkins.results.parser.JenkinsMaster;
import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.JobReport;
import com.liferay.jenkins.results.parser.testray.TestrayS3Object;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import org.json.JSONObject;

public class URLTopLevelBuildReport
extends BaseTopLevelBuildReport {
    private File _jenkinsConsoleLocalFile;

    @Override
    public JSONObject getBuildReportJSONObject() {
        if (this.buildReportJSONObject != null) {
            return this.buildReportJSONObject;
        }
        TestrayS3Object buildReportTestrayS3Object = this.getBuildReportTestrayS3Object();
        if (buildReportTestrayS3Object != null) {
            this.buildReportJSONObject = new JSONObject(buildReportTestrayS3Object.getValue());
        }
        if (this.buildReportJSONObject == null) {
            this.buildReportJSONObject = this.getJSONObjectFromURL(this.getBuildReportJSONUserContentURL());
        }
        if (this.buildReportJSONObject == null) {
            this.buildReportJSONObject = this.getJSONObjectFromURL(this.getBuildReportJSONTestrayURL());
        }
        return this.buildReportJSONObject;
    }

    protected URLTopLevelBuildReport(JSONObject buildJSONObject, JobReport jobReport) {
        super(buildJSONObject, jobReport);
    }

    protected URLTopLevelBuildReport(URL buildURL) {
        super(buildURL);
    }

    @Override
    protected File getJenkinsConsoleLocalFile() {
        if (this._jenkinsConsoleLocalFile != null) {
            return this._jenkinsConsoleLocalFile;
        }
        JobReport jobReport = this.getJobReport();
        JenkinsMaster jenkinsMaster = jobReport.getJenkinsMaster();
        try {
            URL jenkinsConsoleURL = new URL(JenkinsResultsParserUtil.combine("https://storage.cloud.google.com/testray-results/", this.getStartYearMonth(), "/", jenkinsMaster.getName(), "/", jobReport.getJobName(), "/", String.valueOf(this.getBuildNumber()), "/jenkins-console.txt.gz"));
            File jenkinsConsoleLocalGzipFile = new File(System.getenv("WORKSPACE"), JenkinsResultsParserUtil.getDistinctTimeStamp() + ".gz");
            JenkinsResultsParserUtil.toFile(jenkinsConsoleURL, jenkinsConsoleLocalGzipFile);
            File jenkinsConsoleLocalFile = new File(System.getenv("WORKSPACE"), JenkinsResultsParserUtil.getDistinctTimeStamp());
            JenkinsResultsParserUtil.unGzip(jenkinsConsoleLocalGzipFile, jenkinsConsoleLocalFile);
            this._jenkinsConsoleLocalFile = jenkinsConsoleLocalFile;
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
        return this._jenkinsConsoleLocalFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected JSONObject getJSONObjectFromURL(URL url) {
        if (!JenkinsResultsParserUtil.exists(url)) {
            return null;
        }
        String urlString = String.valueOf(url);
        if (!urlString.endsWith(".gz")) {
            try {
                return JenkinsResultsParserUtil.toJSONObject(urlString);
            }
            catch (IOException ioException) {
                return null;
            }
        }
        File file = new File(System.getenv("WORKSPACE"), JenkinsResultsParserUtil.getDistinctTimeStamp() + ".gz");
        try {
            JenkinsResultsParserUtil.toFile(url, file);
            String fileContent = JenkinsResultsParserUtil.read(file);
            if (JenkinsResultsParserUtil.isNullOrEmpty(fileContent)) {
                JSONObject jSONObject = null;
                return jSONObject;
            }
            JSONObject jSONObject = new JSONObject(fileContent);
            return jSONObject;
        }
        catch (Exception exception) {
            JSONObject jSONObject = null;
            return jSONObject;
        }
        finally {
            if (file.exists()) {
                JenkinsResultsParserUtil.delete(file);
            }
        }
    }
}

