/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser.failure.message.generator;

import com.liferay.jenkins.results.parser.Dom4JUtil;
import com.liferay.jenkins.results.parser.failure.message.generator.BaseFailureMessageGenerator;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.dom4j.Element;
import org.dom4j.tree.DefaultElement;

public class JSUnitTestFailureMessageGenerator
extends BaseFailureMessageGenerator {
    private static final Pattern _packageFailurePattern = Pattern.compile("Execution failed for task '[\\D]+:packageRunTest'");

    @Override
    public String getMessage(String consoleText) {
        Matcher packageFailureMatcher = _packageFailurePattern.matcher(consoleText);
        if (!packageFailureMatcher.find()) {
            return null;
        }
        ArrayList<String> packageFailureList = new ArrayList<String>();
        while (packageFailureMatcher.find()) {
            String packageFailure = packageFailureMatcher.group(0);
            if (packageFailureList.contains(packageFailure)) continue;
            packageFailureList.add(packageFailure);
        }
        StringBuilder sb = new StringBuilder();
        sb.append("Build completed with ");
        sb.append(packageFailureList.size());
        sb.append(" failures");
        for (int i = 0; i <= 7; ++i) {
            sb.append("\n* " + (String)packageFailureList.get(i));
        }
        return sb.toString();
    }

    @Override
    public Element getMessageElement(String consoleText) {
        Matcher packageFailureMatcher = _packageFailurePattern.matcher(consoleText);
        if (!packageFailureMatcher.find()) {
            return null;
        }
        ArrayList<Element> elementList = new ArrayList<Element>();
        ArrayList<String> packageFailureList = new ArrayList<String>();
        while (packageFailureMatcher.find()) {
            String packageFailure = packageFailureMatcher.group(0);
            DefaultElement element = new DefaultElement("element");
            element.addText(packageFailure);
            if (element == null || packageFailureList.contains(packageFailure)) continue;
            elementList.add((Element)element);
            packageFailureList.add(packageFailure);
        }
        return Dom4JUtil.getNewElement("div", null, Dom4JUtil.getNewElement("b", null, "Build completed with " + packageFailureList.size() + " failures."), Dom4JUtil.getOrderedListElement(elementList, 7));
    }
}

