/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser.failure.message.generator;

import com.liferay.jenkins.results.parser.Build;
import com.liferay.jenkins.results.parser.failure.message.generator.BaseFailureMessageGenerator;
import org.dom4j.Element;

public class PlaywrightCompilationFailureMessageGenerator
extends BaseFailureMessageGenerator {
    private static final String _TOKEN_END_SNIPPET = "The following error occurred while executing this line:";
    private static final String _TOKEN_START_0_SNIPPET = "Error:";
    private static final String _TOKEN_START_1_SNIPPET = "/tmp/script.sh";
    private static final String _TOKEN_START_2_SNIPPET = "Executing commands:";

    @Override
    public String getMessage(String consoleText) {
        int end = consoleText.indexOf(_TOKEN_END_SNIPPET);
        if ((end = consoleText.lastIndexOf("\n", end)) == -1) {
            return null;
        }
        int start = consoleText.lastIndexOf(_TOKEN_START_0_SNIPPET, end);
        if (start == -1) {
            start = consoleText.lastIndexOf(_TOKEN_START_1_SNIPPET, end);
        }
        if (start == -1) {
            start = consoleText.lastIndexOf(_TOKEN_START_2_SNIPPET, end);
        }
        start = consoleText.lastIndexOf("\n", start);
        return this.getConsoleTextSnippet(consoleText, true, start, end);
    }

    @Override
    public Element getMessageElement(Build build) {
        String jobVariant = build.getJobVariant();
        if (!jobVariant.contains("playwright-compile")) {
            return null;
        }
        return this.getMessageElement(build.getConsoleText());
    }
}

