/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser.failure.message.generator;

import com.liferay.jenkins.results.parser.Build;
import com.liferay.jenkins.results.parser.Dom4JUtil;
import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.TopLevelBuild;
import com.liferay.jenkins.results.parser.failure.message.generator.BaseFailureMessageGenerator;
import java.util.Map;
import org.dom4j.Element;

public class PluginGitIDFailureMessageGenerator
extends BaseFailureMessageGenerator {
    @Override
    public String getMessage(Build build) {
        String message = this.getMessage(build.getConsoleText());
        if (JenkinsResultsParserUtil.isNullOrEmpty(message)) {
            return null;
        }
        TopLevelBuild topLevelBuild = build.getTopLevelBuild();
        StringBuilder sb = new StringBuilder();
        sb.append("Please update ");
        sb.append(this.getGitCommitPluginsAnchorElement(topLevelBuild));
        sb.append(" to an existing Git ID from ");
        sb.append(this.getPluginsBranchAnchorElement(topLevelBuild));
        sb.append(".");
        sb.append(message);
        return sb.toString();
    }

    @Override
    public String getMessage(String consoleText) {
        if (!consoleText.contains("fatal: Could not parse object")) {
            return null;
        }
        int end = consoleText.indexOf("merge-test-results:");
        return this.getConsoleTextSnippetByEnd(consoleText, true, end);
    }

    @Override
    public Element getMessageElement(Build build) {
        String message = this.getMessage(build);
        if (JenkinsResultsParserUtil.isNullOrEmpty(message)) {
            return null;
        }
        TopLevelBuild topLevelBuild = build.getTopLevelBuild();
        return Dom4JUtil.getNewElement("p", null, "Please update ", Dom4JUtil.getNewElement("strong", null, this.getGitCommitPluginsAnchorElement(topLevelBuild)), " to an existing Git ID from ", Dom4JUtil.getNewElement("strong", null, this.getPluginsBranchAnchorElement(topLevelBuild)), ".", message);
    }

    protected Element getPluginsBranchAnchorElement(TopLevelBuild topLevelBuild) {
        String gitRepositoryName = topLevelBuild.getBaseGitRepositoryName();
        String pluginsGitRepositoryName = "liferay-plugins";
        if (gitRepositoryName.endsWith("-ee")) {
            pluginsGitRepositoryName = pluginsGitRepositoryName + "-ee";
        }
        Map<String, String> pluginsGitRepositoryGitDetailsTempMap = topLevelBuild.getBaseGitRepositoryDetailsTempMap();
        StringBuilder sb = new StringBuilder();
        sb.append("https://github.com/liferay/");
        sb.append(pluginsGitRepositoryName);
        sb.append("/commits/");
        sb.append(pluginsGitRepositoryGitDetailsTempMap.get("github.upstream.branch.name"));
        return Dom4JUtil.getNewAnchorElement(sb.toString(), pluginsGitRepositoryName, "/", pluginsGitRepositoryGitDetailsTempMap.get("github.upstream.branch.name"));
    }
}

