/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser.failure.message.generator;

import com.liferay.jenkins.results.parser.Dom4JUtil;
import com.liferay.jenkins.results.parser.failure.message.generator.BaseFailureMessageGenerator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.dom4j.Element;

public class PoshiValidationFailureMessageGenerator
extends BaseFailureMessageGenerator {
    private static final Pattern _poshiFailurePattern = Pattern.compile("\\n(.*errors in (Poshi|POSHI)[\\s\\S]+?FAILED)");

    @Override
    public String getMessage(String consoleText) {
        Matcher poshiFailureMatcher = _poshiFailurePattern.matcher(consoleText);
        if (!poshiFailureMatcher.find()) {
            return null;
        }
        return poshiFailureMatcher.group(1);
    }

    @Override
    public Element getMessageElement(String consoleText) {
        Element messageElement = super.getMessageElement(consoleText);
        if (messageElement == null) {
            return null;
        }
        return Dom4JUtil.getNewElement("div", null, Dom4JUtil.getNewElement("p", null, "POSHI Validation Failure", messageElement));
    }
}

