/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser.github.webhook;

import com.liferay.jenkins.results.parser.GitCommit;
import com.liferay.jenkins.results.parser.GitHubRemoteGitCommit;
import com.liferay.jenkins.results.parser.GitHubRemoteGitRepository;
import com.liferay.jenkins.results.parser.JenkinsMaster;
import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.JenkinsStopBuildUtil;
import com.liferay.jenkins.results.parser.MultiPattern;
import com.liferay.jenkins.results.parser.PullRequest;
import com.liferay.jenkins.results.parser.RemoteGitBranch;
import com.liferay.jenkins.results.parser.github.webhook.Payload;
import com.liferay.jenkins.results.parser.github.webhook.PayloadFactory;
import com.liferay.jenkins.results.parser.github.webhook.PullRequestCommentPayload;
import com.liferay.jenkins.results.parser.github.webhook.PullRequestPayload;
import com.liferay.jenkins.results.parser.github.webhook.PullRequestTesterParameters;
import com.liferay.jenkins.results.parser.github.webhook.PushEventPayload;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class GitHubWebhookPayloadProcessor {
    private static final String[] _URLS_JENKINS_BUILD_PROPERTIES = new String[]{"http://mirrors-no-cache.lax.liferay.com/github.com/liferay/liferay-jenkins-ee/build.properties", "http://mirrors-no-cache.lax.liferay.com/github.com/liferay/liferay-jenkins-ee/commands/build.properties"};
    private static final Log _log = LogFactory.getLog(GitHubWebhookPayloadProcessor.class);
    private static final List<String> _acRepositories = Arrays.asList("com-liferay-osb-asah-private");
    private static final Pattern _buildURLPattern = Pattern.compile("Build[\\w\\s]*started.*Job Link: <a href=\"(?<buildURL>[^\"]+)\"");
    private static final List<String> _gauntletUsernames = Arrays.asList("CsabaTurcsan", "Hanlf", "HarryC0204", "Songyuewen", "SylviaLuan", "ZoltanTakacs", "brianchandotcom", "brianwulbern", "ctampoya", "gergelyszaz", "jpince", "kiyoshilee", "lesliewong92", "liferay-continuous-integration-hu", "michaelhashimoto", "michaelprigge", "pyoo47", "sharonchoi", "shuyangzhou", "stsquared99", "suilin", "vicnate5", "xbrianlee", "yunlinsun");
    private static final Pattern _gitrepoRepoPattern = Pattern.compile("remote = .*/([^\\.]*)\\.git");
    private static final Pattern _gitrepoSHAPattern = Pattern.compile("commit = ([0-9a-f]{40})");
    private static Set<String> _passingTestSuites;
    private static final Pattern _passingTestSuiteStatusDescriptionPattern;
    private static final Pattern _reevaluatePattern;
    private static final Pattern _testPattern;
    private static final List<String> _whiteListedOwnerNames;
    private static final MultiPattern _whiteListedRepositoryMultiPattern;
    private boolean _ciForwardEligible;
    private final Properties _jenkinsBuildProperties;
    private List<String> _jiraProjectKeys;
    private final Payload _payload;
    private final Map<String, Long> _testPullRequestQueryStrings = new ConcurrentHashMap<String, Long>(100);
    private final Map<String, Long> _testPullRequestURLs = new ConcurrentHashMap<String, Long>(100);
    private final Set<String> _validLiferayUsers = new HashSet<String>();

    public static void main(String[] args) {
        try {
            GitHubWebhookPayloadProcessor gitHubWebhookPayloadProcessor = new GitHubWebhookPayloadProcessor(JenkinsResultsParserUtil.read(new File(args[0])));
            gitHubWebhookPayloadProcessor.process();
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
    }

    public GitHubWebhookPayloadProcessor(String payloadJSONSource) {
        JenkinsResultsParserUtil.setBuildProperties(_URLS_JENKINS_BUILD_PROPERTIES);
        try {
            this._jenkinsBuildProperties = JenkinsResultsParserUtil.getBuildProperties();
        }
        catch (IOException ioException) {
            throw new RuntimeException("Unable to get build properties", ioException);
        }
        this._payload = PayloadFactory.newPayload(new JSONObject(this._cleanupJSONSource(payloadJSONSource)));
    }

    public void addTestPullRequestQueryString(String queryString) {
        this._testPullRequestQueryStrings.put(queryString, JenkinsResultsParserUtil.getCurrentTimeMillis());
    }

    public void addTestPullRequestURL(String url) {
        this._testPullRequestURLs.put(url, JenkinsResultsParserUtil.getCurrentTimeMillis());
    }

    public String getCIJobName(PullRequestTesterParameters pullRequestTesterParameters) {
        if (this._ciForwardEligible) {
            return "forward-pullrequest";
        }
        String ciReevaluateBuildId = pullRequestTesterParameters.getCiReevaluateBuildId();
        if (ciReevaluateBuildId != null) {
            return "test-portal-evaluate-pullrequest";
        }
        String ciTestSuiteName = pullRequestTesterParameters.getCiTestSuiteName();
        if (ciTestSuiteName.equals("sf")) {
            return "test-portal-source-format";
        }
        PullRequest pullRequest = pullRequestTesterParameters.getPullRequest();
        String repositoryName = pullRequest.getGitRepositoryName();
        if (repositoryName.equals("liferay-fix-pack-builder-ee")) {
            return "test-fixpack-builder-pullrequest";
        }
        if (repositoryName.equals("liferay-jenkins-ee")) {
            return "test-jenkins-acceptance-pullrequest";
        }
        StringBuilder sb = new StringBuilder();
        if (repositoryName.startsWith("com-liferay-")) {
            sb.append("test-subrepository-acceptance-pullrequest");
        } else if (repositoryName.startsWith("liferay-plugins")) {
            sb.append("test-plugins-acceptance-pullrequest");
        } else if (repositoryName.startsWith("liferay-portal")) {
            sb.append("test-portal-acceptance-pullrequest");
        }
        sb.append("(");
        sb.append(pullRequest.getUpstreamRemoteGitBranchName());
        sb.append(")");
        return sb.toString();
    }

    public List<String> getCITestAutoTestSuiteNames(PullRequest pullRequest) {
        String ciTestAutoRecipientsProperty = JenkinsResultsParserUtil.getCIProperty(pullRequest.getUpstreamRemoteGitBranchName(), "ci.test.auto.recipients", pullRequest.getGitHubRemoteGitRepositoryName());
        if (ciTestAutoRecipientsProperty == null || ciTestAutoRecipientsProperty.isEmpty()) {
            return Collections.emptyList();
        }
        Pattern pattern = Pattern.compile(pullRequest.getOwnerUsername() + "\\[(?<testSuiteNames>[^\\]]+)]");
        for (String ciTestAutoRecipient : ciTestAutoRecipientsProperty.split("\\s*,\\s*")) {
            Matcher matcher = pattern.matcher(ciTestAutoRecipient);
            if (!matcher.matches()) continue;
            String ciTestAutoTestSuiteNames = matcher.group("testSuiteNames");
            return Arrays.asList(ciTestAutoTestSuiteNames.split(":"));
        }
        return Collections.emptyList();
    }

    public Set<String> getPassingTestSuites(PullRequest pullRequest) throws JSONException {
        if (_passingTestSuites != null && !_passingTestSuites.isEmpty()) {
            return _passingTestSuites;
        }
        _passingTestSuites = new HashSet<String>();
        for (String statusDescription : pullRequest.getStatusDescriptions()) {
            Matcher matcher = _passingTestSuiteStatusDescriptionPattern.matcher(statusDescription);
            if (!matcher.matches()) continue;
            _passingTestSuites.add(matcher.group("testSuiteName"));
        }
        return _passingTestSuites;
    }

    public List<String> getTestPullRequestQueryStrings() {
        long expiredTime = this.getTestPullRequestQueryStringExpiredTime();
        for (Map.Entry<String, Long> testPullRequestQueryStringsEntry : this._testPullRequestQueryStrings.entrySet()) {
            long time = testPullRequestQueryStringsEntry.getValue();
            if (time >= expiredTime) continue;
            this._testPullRequestQueryStrings.remove(testPullRequestQueryStringsEntry.getKey());
        }
        return new ArrayList<String>(this._testPullRequestQueryStrings.keySet());
    }

    public List<String> getTestPullRequestURLs() {
        long expiredTime = this.getTestPullRequestURLExpiredTime();
        for (Map.Entry<String, Long> testPullRequestQueryStringsEntry : this._testPullRequestQueryStrings.entrySet()) {
            long time = testPullRequestQueryStringsEntry.getValue();
            if (time >= expiredTime) continue;
            this._testPullRequestURLs.remove(testPullRequestQueryStringsEntry.getKey());
        }
        return new ArrayList<String>(this._testPullRequestURLs.keySet());
    }

    public void invokePullRequestTester(String masterURL, PullRequestTesterParameters pullRequestTesterParameters) {
        PullRequest pullRequest = pullRequestTesterParameters.getPullRequest();
        String invocationURL = JenkinsResultsParserUtil.combine(masterURL, "/job/", this.getCIJobName(pullRequestTesterParameters), "/buildWithParameters?", pullRequestTesterParameters.toQueryString());
        this.addTestPullRequestURL(invocationURL);
        if (this.isJenkinsJobEnabled()) {
            this.processURL(invocationURL);
            if (this._ciForwardEligible || !JenkinsResultsParserUtil.isNullOrEmpty(pullRequestTesterParameters.getCiReevaluateBuildId())) {
                return;
            }
            String publicJobURL = JenkinsResultsParserUtil.getRemoteURL(invocationURL.replaceFirst("([^\\?]*)/.*", "$1"));
            if (_log.isInfoEnabled()) {
                _log.info((Object)JenkinsResultsParserUtil.combine("Pull request test invoked at ", publicJobURL, "."));
            }
            pullRequest.setTestSuiteStatus(pullRequestTesterParameters.getCiTestSuiteName(), PullRequest.TestSuiteStatus.PENDING, publicJobURL);
        } else if (_log.isInfoEnabled()) {
            _log.info((Object)("Pull request test URL " + invocationURL));
        }
    }

    public boolean isGitHubAutopullEnabled() {
        return Boolean.valueOf(this._jenkinsBuildProperties.getProperty("github.webhook.pullrequest.autopull.enabled", Boolean.FALSE.toString()));
    }

    public boolean isGitHubPostEnabled() {
        return Boolean.valueOf(this._jenkinsBuildProperties.getProperty("github.webhook.pullrequest.post.enabled", Boolean.FALSE.toString()));
    }

    public boolean isGitHubRepositorySyncEnabled() {
        return Boolean.valueOf(this._jenkinsBuildProperties.getProperty("github.webhook.repository.sync.enabled", Boolean.FALSE.toString()));
    }

    public boolean isGitHubSubrepoSyncEnabled() {
        return Boolean.valueOf(this._jenkinsBuildProperties.getProperty("github.webhook.subrepository.sync.enabled", Boolean.FALSE.toString()));
    }

    public boolean isJenkinsJobEnabled() {
        return Boolean.valueOf(this._jenkinsBuildProperties.getProperty("github.webhook.pullrequest.jenkins.job.enabled", Boolean.FALSE.toString()));
    }

    public boolean isValidAutopull(String repo) {
        return repo.startsWith("com-liferay-");
    }

    public boolean isValidCIMergeFile(PullRequest pullRequest) {
        List<String> fileNames = pullRequest.getFileNames();
        if (fileNames.size() > 1) {
            return false;
        }
        for (String fileName : fileNames) {
            if (!fileName.endsWith("/ci-merge")) continue;
            return true;
        }
        return false;
    }

    public void process() {
        if (this._payload instanceof PushEventPayload) {
            PushEventPayload pushEventPayload = (PushEventPayload)this._payload;
            this.syncAutopull(pushEventPayload);
            this.syncRepository(pushEventPayload);
            this.syncSubrepo(pushEventPayload);
        }
        if (this._payload instanceof PullRequestCommentPayload) {
            this._processCommentCreated((PullRequestCommentPayload)this._payload);
            return;
        }
        if (this._payload instanceof PullRequestPayload) {
            PullRequestPayload pullRequestPayload = (PullRequestPayload)this._payload;
            String action = this._payload.getAction();
            if (action.equals("opened")) {
                this._processPullRequestOpened(pullRequestPayload);
                return;
            }
            if (action.equals("synchronize")) {
                this._processPullRequestSynchronize(pullRequestPayload);
            }
        }
    }

    public String processURL(String url) {
        return this.processURL(url, null, JenkinsResultsParserUtil.HttpRequestMethod.GET);
    }

    public String processURL(String url, String body) {
        return this.processURL(url, body, JenkinsResultsParserUtil.HttpRequestMethod.POST);
    }

    public String processURL(String url, String body, JenkinsResultsParserUtil.HttpRequestMethod method) {
        if (method == JenkinsResultsParserUtil.HttpRequestMethod.PATCH || method == JenkinsResultsParserUtil.HttpRequestMethod.POST) {
            if (body == null) {
                throw new IllegalArgumentException(method.toString() + " method requires a body");
            }
            body = JenkinsResultsParserUtil.combine("token=", this._jenkinsBuildProperties.getProperty("jenkins.authentication.token"), "&", body);
        } else if (method == JenkinsResultsParserUtil.HttpRequestMethod.DELETE || method == JenkinsResultsParserUtil.HttpRequestMethod.PUT) {
            body = JenkinsResultsParserUtil.combine("token=", this._jenkinsBuildProperties.getProperty("jenkins.authentication.token"));
        } else if (method == JenkinsResultsParserUtil.HttpRequestMethod.GET && body != null) {
            throw new IllegalArgumentException(method.toString() + " method should not have a body");
        }
        try {
            return JenkinsResultsParserUtil.toString(url, false, method, body);
        }
        catch (IOException ioException) {
            throw new RuntimeException("Unable to retrieve URL " + url, ioException);
        }
    }

    public void removeTestPullRequestQueryString(String queryString) {
        this._testPullRequestQueryStrings.remove(queryString);
    }

    public void removeTestPullRequestURL(String url) {
        this._testPullRequestURLs.remove(url);
    }

    protected void commentMergeSubrepoPullRequest(PullRequest pullRequest) {
        block5: {
            try {
                String currentSHA = "";
                StringBuilder sb = new StringBuilder();
                sb.append("https://raw.githubusercontent.com/liferay/");
                sb.append(pullRequest.getGitHubRemoteGitRepositoryName());
                sb.append("/");
                sb.append(pullRequest.getUpstreamRemoteGitBranchName());
                sb.append("/");
                sb.append(pullRequest.getCIMergeSubrepo());
                sb.append("/.gitrepo");
                String gitrepoContent = this.processURL(sb.toString());
                Matcher matcher = _gitrepoSHAPattern.matcher(gitrepoContent);
                while (matcher.find()) {
                    currentSHA = matcher.group(1);
                }
                matcher = _gitrepoRepoPattern.matcher(gitrepoContent);
                String repo = "";
                while (matcher.find()) {
                    repo = matcher.group(1);
                }
                String mergeSHA = pullRequest.getCIMergeSHA();
                String compareURL = "https://github.com/liferay/" + repo + "/compare/" + currentSHA + "..." + mergeSHA;
                if (_log.isInfoEnabled()) {
                    _log.info((Object)("Subrepo compare URL " + compareURL));
                }
                String message = "Subrepo changes: " + compareURL + "\n\nci:test:sf and ci:test:relevant must pass in order for auto-merge to initiate.";
                pullRequest.addComment(message);
            }
            catch (Exception exception) {
                if (!_log.isInfoEnabled()) break block5;
                _log.info((Object)"Skip generation of the ci:merge diff because of an exception", (Throwable)exception);
            }
        }
    }

    protected String formatCSV(String string) {
        string = string.replaceAll("\\s*,\\s*", ", ");
        string = string.replaceFirst(",\\s+$", "");
        return string.replaceFirst("(.*), (.+)", "$1 or $2");
    }

    protected List<String> getAllowedSenderUsernames(PullRequest pullRequest) {
        String allowedSenderNamesProperty = JenkinsResultsParserUtil.getCIProperty(pullRequest.getUpstreamRemoteGitBranchName(), JenkinsResultsParserUtil.combine("allowed.sender.names[", pullRequest.getOwnerUsername(), "]"), pullRequest.getGitHubRemoteGitRepositoryName());
        if (allowedSenderNamesProperty == null || allowedSenderNamesProperty.isEmpty()) {
            return Collections.emptyList();
        }
        return Arrays.asList(allowedSenderNamesProperty.split("\\s*,\\s*"));
    }

    protected List<String> getBuildURLs(PullRequest pullRequest) {
        ArrayList<String> buildURLs = new ArrayList<String>();
        for (PullRequest.Comment comment : pullRequest.getComments()) {
            Matcher buildURLMatcher = _buildURLPattern.matcher(comment.getBody());
            if (!buildURLMatcher.find()) continue;
            buildURLs.add(buildURLMatcher.group("buildURL"));
        }
        return buildURLs;
    }

    protected String[] getCIForwardRequiredPassingSuites() {
        String ciForwardRequiredPassingSuites = this._jenkinsBuildProperties.getProperty("pull.request.forward.required.passing.suites", "");
        if (ciForwardRequiredPassingSuites.isEmpty()) {
            return new String[0];
        }
        return ciForwardRequiredPassingSuites.split("\\s*,\\s*");
    }

    protected String[] getCIForwardRequiredTestSuites() {
        String ciForwardRequiredTestSuites = this._jenkinsBuildProperties.getProperty("pull.request.forward.required.test.suites", "");
        if (ciForwardRequiredTestSuites.isEmpty()) {
            return new String[0];
        }
        return ciForwardRequiredTestSuites.split("\\s*,\\s*");
    }

    protected String getCompanionBranchName(String branchName) {
        if (branchName.contains("-private")) {
            return branchName.replace("-private", "");
        }
        return branchName + "-private";
    }

    protected List<String> getJiraProjectKeys(PullRequest pullRequest) {
        if (this._jiraProjectKeys != null) {
            return this._jiraProjectKeys;
        }
        String jiraProjectKeysProperty = JenkinsResultsParserUtil.getCIProperty(pullRequest.getUpstreamRemoteGitBranchName(), "jira.project.keys", pullRequest.getGitRepositoryName());
        if (jiraProjectKeysProperty != null && jiraProjectKeysProperty.isEmpty()) {
            this._jiraProjectKeys = Arrays.asList(jiraProjectKeysProperty.split("\\s*,\\s*"));
        }
        return this._jiraProjectKeys;
    }

    protected String getSubrepoCentralMergePullRequestRecipientName(String refName) {
        return this._jenkinsBuildProperties.getProperty(JenkinsResultsParserUtil.combine("subrepo.merge.receiver.name[", refName, "]"), "liferay");
    }

    protected String getSubrepoPath(PushEventPayload pushEventPayload) {
        String subrepoPath;
        GitHubRemoteGitCommit headGitHubRemoteGitCommit = pushEventPayload.getHeadGitHubRemoteGitCommit();
        if (headGitHubRemoteGitCommit == null) {
            return null;
        }
        String commitMessage = headGitHubRemoteGitCommit.getMessage();
        if (commitMessage != null && commitMessage.contains("LPS-0 Clear") && ((subrepoPath = commitMessage.replaceAll(".* ", "")).startsWith("modules/apps") || subrepoPath.startsWith("modules/private/apps"))) {
            return subrepoPath;
        }
        for (String filename : headGitHubRemoteGitCommit.getModifiedFilenames()) {
            String subrepoPath2;
            if (!filename.endsWith(".gitrepo") || !(subrepoPath2 = filename.replaceAll("/\\.gitrepo", "")).startsWith("modules/apps") && !subrepoPath2.startsWith("modules/private/apps")) continue;
            return subrepoPath2;
        }
        return null;
    }

    protected long getTestPullRequestQueryStringExpiredTime() {
        long currentTimeMillis = JenkinsResultsParserUtil.getCurrentTimeMillis();
        return currentTimeMillis - 21600000L;
    }

    protected long getTestPullRequestURLExpiredTime() {
        long currentTimeMillis = JenkinsResultsParserUtil.getCurrentTimeMillis();
        return currentTimeMillis - 21600000L;
    }

    protected boolean hasLiferayEmailAddress(String githubUsername) {
        if (githubUsername.equals("liferay")) {
            return true;
        }
        JSONObject jsonObject = new JSONObject(this.processURL("https://api.github.com/users/" + githubUsername));
        String emailAddress = jsonObject.optString("email");
        return emailAddress != null && emailAddress.endsWith("@liferay.com");
    }

    protected boolean hasValidJIRAReferences(PullRequest pullRequest) {
        String ownerUsername = pullRequest.getOwnerUsername();
        if (!ownerUsername.equals("brianchandotcom")) {
            return true;
        }
        List<String> jiraProjectKeys = this.getJiraProjectKeys(pullRequest);
        if (jiraProjectKeys.isEmpty()) {
            return true;
        }
        for (GitCommit gitCommit : pullRequest.getGitHubRemoteCommits()) {
            String message = gitCommit.getMessage();
            if (message.contains("subrepo:ignore")) {
                return true;
            }
            boolean hasJIRAProjectKey = false;
            for (String jiraProjectKey : this._jiraProjectKeys) {
                if (!message.contains(jiraProjectKey + "-")) continue;
                if (_log.isInfoEnabled()) {
                    _log.info((Object)("Contains JIRA project keys " + jiraProjectKey));
                }
                hasJIRAProjectKey = true;
            }
            String emailAddress = gitCommit.getEmailAddress();
            if (emailAddress.equals("brian.chan@liferay.com") || emailAddress.equals("continuous-integration@liferay.com") || emailAddress.equals("samuel.tran@liferay.com")) {
                if (!_log.isInfoEnabled()) continue;
                _log.info((Object)"Allow commit from Brian, Sam, or CI");
                continue;
            }
            if (hasJIRAProjectKey) continue;
            return false;
        }
        return true;
    }

    protected boolean isBlank(String string) {
        if (string == null) {
            return true;
        }
        return (string = string.trim()).isEmpty();
    }

    protected boolean isBotPush(PushEventPayload pushEventPayload) {
        return !JenkinsResultsParserUtil.isNullOrEmpty(this.getSubrepoPath(pushEventPayload));
    }

    protected boolean isLiferayUser(String gitHubUsername) {
        if (gitHubUsername.equals("liferay") || this._validLiferayUsers.contains(gitHubUsername)) {
            return true;
        }
        JSONArray jsonArray = new JSONArray(this.processURL(JenkinsResultsParserUtil.combine("https://api.github.com/users/", gitHubUsername, "/orgs")));
        for (int i = 0; i < jsonArray.length(); ++i) {
            JSONObject jsonObject = jsonArray.getJSONObject(i);
            String organizationLogin = jsonObject.getString("login");
            if (!organizationLogin.equals("liferay")) continue;
            if (_log.isInfoEnabled()) {
                _log.info((Object)("Valid Liferay member " + gitHubUsername));
            }
            this._validLiferayUsers.add(gitHubUsername);
            return true;
        }
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Invalid Liferay member " + gitHubUsername));
        }
        return false;
    }

    protected boolean isSynchronizeablePullRequest(PullRequest pullRequest) {
        String receiverUsername = pullRequest.getReceiverUsername();
        return !receiverUsername.equals("brianchandotcom");
    }

    protected boolean isTestablePullRequest(PullRequest pullRequest) {
        String branchName = pullRequest.getUpstreamRemoteGitBranchName();
        String repositoryName = pullRequest.getGitRepositoryName();
        List<String> ciEnabledBranchNames = this._getCIEnabledBranchNames(repositoryName);
        if (!_acRepositories.contains(repositoryName) && !ciEnabledBranchNames.contains(branchName)) {
            StringBuilder sb = new StringBuilder(4);
            sb.append("Closing pull request because pulls for reference ");
            sb.append(branchName);
            sb.append(" should not be sent to repository ");
            sb.append(repositoryName);
            if (_log.isInfoEnabled()) {
                _log.info((Object)sb.toString());
            }
            pullRequest.addComment(sb.toString());
            pullRequest.close();
            return false;
        }
        String ownerUsername = pullRequest.getOwnerUsername();
        if (!_whiteListedOwnerNames.isEmpty() && !_whiteListedOwnerNames.contains(ownerUsername)) {
            String message = JenkinsResultsParserUtil.combine("Skip pull request because the owner ", ownerUsername, " is not on the whitelist\n\nPull request tests have been ", "temporarily suspended.");
            if (_log.isInfoEnabled()) {
                _log.info((Object)message);
            }
            pullRequest.addComment(message);
            return false;
        }
        String senderUsername = pullRequest.getSenderUsername();
        if (ownerUsername.equals(this.getSubrepoCentralMergePullRequestRecipientName(branchName)) && pullRequest.isMergeSubrepoRequest()) {
            if (!pullRequest.isValidCIMergeFile()) {
                String message = JenkinsResultsParserUtil.combine("Closing pull request because a subrepo merge ", "request must only contain a single change to a ", "single ci-merge file.");
                if (_log.isInfoEnabled()) {
                    _log.info((Object)message);
                }
                pullRequest.addComment(message);
                pullRequest.close();
                return false;
            }
            String sha = pullRequest.getCIMergeSHA();
            if (sha.equals("")) {
                String message = "Closing pull request because the ci-merge file modification is missing or incorrectly formatted";
                if (_log.isInfoEnabled()) {
                    _log.info((Object)message);
                }
                pullRequest.addComment(message);
                pullRequest.close();
                return false;
            }
        }
        GitHubRemoteGitRepository gitHubRemoteGitRepository = pullRequest.getGitHubRemoteGitRepository();
        if (ownerUsername.equals("liferay") && !gitHubRemoteGitRepository.isSubrepository() && !repositoryName.equals("liferay-portal-ee")) {
            if (_log.isInfoEnabled()) {
                _log.info((Object)JenkinsResultsParserUtil.combine("Skip pull request because it is a pull sent to ", "Liferay that is not a subrepo request"));
            }
            return false;
        }
        if (_whiteListedRepositoryMultiPattern.matches(repositoryName) == null) {
            if (_log.isInfoEnabled()) {
                _log.info((Object)JenkinsResultsParserUtil.combine("Skip pull request because the repository ", repositoryName, " is not on the whitelist"));
            }
            return false;
        }
        if (!this.isLiferayUser(ownerUsername)) {
            if (_log.isInfoEnabled()) {
                _log.info((Object)JenkinsResultsParserUtil.combine("Skip pull request because the owner ", ownerUsername, " does not have access"));
            }
            return false;
        }
        if (!this.isLiferayUser(senderUsername)) {
            if (_log.isInfoEnabled()) {
                _log.info((Object)JenkinsResultsParserUtil.combine("Skip pull request because the tester ", senderUsername, " does not have access"));
            }
            if (this.hasLiferayEmailAddress(senderUsername)) {
                StringBuilder sb = new StringBuilder();
                sb.append("Your pull request was not tested because you ");
                sb.append("are not a member of the Liferay organization. ");
                sb.append("Please make sure that you have been added and ");
                sb.append("that your organization membership is set as ");
                sb.append("Public. See https://help.github.com/articles");
                sb.append("/publicizing-or-hiding-organization-");
                sb.append("membership for more information.");
                pullRequest.addComment(sb.toString());
            }
            return false;
        }
        String githubCIUsername = this._jenkinsBuildProperties.getProperty("github.ci.username");
        if (ownerUsername.equals("brianchandotcom") && branchName.equals("master") && repositoryName.equals("liferay-portal") && !senderUsername.equals(githubCIUsername)) {
            StringBuilder sb = new StringBuilder(4);
            sb.append("Closing pull request because all `liferay-portal` pull");
            sb.append("requests sent to Brian Chan must be sent by using ");
            sb.append("`ci:forward` on a pull request that was sent to ");
            sb.append("someone else.");
            String message = sb.toString();
            if (_log.isInfoEnabled()) {
                _log.info((Object)message);
            }
            pullRequest.addComment(message);
            pullRequest.close();
            return false;
        }
        List<String> allowedSenderUsernames = this.getAllowedSenderUsernames(pullRequest);
        if (!allowedSenderUsernames.isEmpty() && !allowedSenderUsernames.contains(senderUsername)) {
            StringBuilder sb = new StringBuilder(7);
            sb.append("Closing pull request because ");
            sb.append(senderUsername);
            sb.append(" is not an allowed sender on this branch. Please ");
            sb.append("resend this pull request to one of the following ");
            sb.append("allowed senders: ");
            sb.append(JenkinsResultsParserUtil.join(", ", allowedSenderUsernames));
            sb.append(".");
            String message = sb.toString();
            if (_log.isInfoEnabled()) {
                _log.info((Object)message);
            }
            pullRequest.addComment(message);
            pullRequest.close();
            return false;
        }
        List<String> collaboratorUsernames = gitHubRemoteGitRepository.getCollaboratorUsernames();
        if (!collaboratorUsernames.contains("liferay-continuous-integration")) {
            StringBuilder sb;
            if (_log.isInfoEnabled()) {
                sb = new StringBuilder(4);
                sb.append("Skip pull request because ");
                sb.append("liferay-continuous-integration does not have ");
                sb.append("write access to ");
                sb.append(gitHubRemoteGitRepository.getHtmlURL());
                _log.info((Object)sb.toString());
            }
            sb = new StringBuilder(5);
            sb.append("Your pull request was not tested because your ");
            sb.append("repository has not set liferay-continuous-integration ");
            sb.append("as a collaborator. See https://grow.liferay.com/share/");
            sb.append("Pull+Request+Tester+for+Liferay+Developers for more ");
            sb.append("information.");
            pullRequest.addComment(sb.toString());
            return false;
        }
        if (!this.hasValidJIRAReferences(pullRequest)) {
            StringBuilder sb = new StringBuilder(7);
            sb.append("Closing pull request because at least one commit ");
            sb.append("message is missing a reference to a required JIRA ");
            sb.append("project: ");
            sb.append(JenkinsResultsParserUtil.join(", ", this.getJiraProjectKeys(pullRequest)));
            sb.append(". Please verify that the JIRA project keys are ");
            sb.append("specified in ci.properties in the liferay-portal ");
            sb.append("repository.");
            String message = sb.toString();
            if (_log.isInfoEnabled()) {
                _log.info((Object)message);
            }
            pullRequest.addComment(message);
            pullRequest.close();
            return false;
        }
        return true;
    }

    protected boolean isValidPullRequestRefSHA(PullRequest pullRequest, String refSHA) {
        StringBuilder sb = new StringBuilder();
        sb.append("https://api.github.com/repos/liferay/");
        sb.append(pullRequest.getGitHubRemoteGitRepositoryName());
        sb.append("/commits/");
        sb.append(refSHA);
        JSONObject commitJSONObject = new JSONObject(this.processURL(sb.toString()));
        return commitJSONObject.has("sha");
    }

    protected String join(String[] array) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < array.length; ++i) {
            if (i + 1 == array.length) {
                sb.append(" or ");
            }
            sb.append(array[i]);
            if (i + 1 >= array.length) continue;
            sb.append(", ");
        }
        return sb.toString();
    }

    protected void mergeSubrepo(PullRequest pullRequest, boolean force) {
        String gitHubWebSubrepoHostname;
        String message;
        JSONObject jsonObject;
        block29: {
            String branchName;
            String subrepoCentralMergePullRequestRecipientName;
            String ownerUsername = pullRequest.getOwnerUsername();
            if (!ownerUsername.equals(subrepoCentralMergePullRequestRecipientName = this.getSubrepoCentralMergePullRequestRecipientName(branchName = pullRequest.getUpstreamRemoteGitBranchName())) && _log.isInfoEnabled()) {
                _log.info((Object)("Skip merge subrepo because the user is not " + subrepoCentralMergePullRequestRecipientName));
            }
            String repositoryName = pullRequest.getGitHubRemoteGitRepositoryName();
            jsonObject = new JSONObject();
            jsonObject.put("branch", (Object)branchName).put("command", (Object)"pull").put("pullRequestNumber", (Object)pullRequest.getNumber()).put("repo", (Object)repositoryName);
            try {
                if (!pullRequest.isValidCIMergeFile()) {
                    String message2 = JenkinsResultsParserUtil.combine("Closing pull request because a subrepo merge request ", "must only contain a single change to a single ", "ci-merge file");
                    if (_log.isInfoEnabled()) {
                        _log.info((Object)message2);
                    }
                    pullRequest.addComment(message2);
                    pullRequest.close();
                    return;
                }
            }
            catch (Exception exception) {
                String message3 = "Skip merge subrepo because of a GitHub error";
                if (_log.isInfoEnabled()) {
                    _log.info((Object)message3, (Throwable)exception);
                }
                pullRequest.addComment(message3 + ".");
                return;
            }
            String sha = pullRequest.getCIMergeSHA();
            if (sha.equals("")) {
                String message4 = "Closing pull request because the ci-merge file modification is missing or incorrectly formatted";
                if (_log.isInfoEnabled()) {
                    _log.info((Object)message4);
                }
                pullRequest.addComment(message4);
                pullRequest.close();
                return;
            }
            if (_log.isInfoEnabled()) {
                _log.info((Object)("Merge subrepo SHA " + sha));
            }
            jsonObject.put("sha", (Object)sha);
            String subrepo = pullRequest.getCIMergeSubrepo();
            if (_log.isInfoEnabled()) {
                _log.info((Object)("Merge subrepo name " + subrepo));
            }
            jsonObject.put("subrepo", (Object)subrepo);
            String statusURL = "https://api.github.com/repos/" + subrepoCentralMergePullRequestRecipientName + "/" + repositoryName + "/commits/" + pullRequest.getSenderSHA() + "/status";
            JSONArray statusesJSONArray = null;
            for (int i = 0; i < 3; ++i) {
                try {
                    JSONObject statusJSONObject = new JSONObject(this.processURL(statusURL));
                    statusesJSONArray = statusJSONObject.getJSONArray("statuses");
                    break;
                }
                catch (Exception exception) {
                    if (_log.isInfoEnabled()) {
                        _log.info((Object)("Retrying " + statusURL), (Throwable)exception);
                    }
                    JenkinsResultsParserUtil.sleep(1000L);
                    continue;
                }
            }
            if (statusesJSONArray == null) {
                String message5 = "Skip merge subrepo because of a GitHub error";
                if (_log.isInfoEnabled()) {
                    _log.info((Object)message5);
                }
                pullRequest.addComment(message5);
                pullRequest.close();
                return;
            }
            if (_log.isInfoEnabled()) {
                _log.info((Object)("Merge subrepo force " + force));
            }
            if (!force) {
                HashMap<String, String> statuses = new HashMap<String, String>();
                for (int i = 0; i < statusesJSONArray.length(); ++i) {
                    JSONObject statusJSONObject = statusesJSONArray.getJSONObject(i);
                    String context = statusJSONObject.getString("context");
                    String state = statusJSONObject.getString("state");
                    statuses.put(context, state);
                }
                boolean validStatus = false;
                if (statuses.containsKey("liferay/ci:test:relevant") && statuses.containsKey("liferay/ci:test:sf")) {
                    String relevantStatus = (String)statuses.get("liferay/ci:test:relevant");
                    String sfStatus = (String)statuses.get("liferay/ci:test:sf");
                    if (relevantStatus.equals("success") && sfStatus.equals("success")) {
                        validStatus = true;
                    }
                }
                if (!validStatus) {
                    message = "Skip merge subrepo because tests have not passed";
                    if (_log.isInfoEnabled()) {
                        _log.info((Object)message);
                    }
                    pullRequest.addComment(message);
                    pullRequest.close();
                    return;
                }
            }
            gitHubWebSubrepoHostname = this._jenkinsBuildProperties.getProperty("github.webhook.pullrequest.web.subrepo.hostname");
            try {
                jsonObject.put("remove", (Object)"true");
                this.processURL("http://" + gitHubWebSubrepoHostname + "/osb-github-web/subrepo", jsonObject.toString());
            }
            catch (Exception exception) {
                if (!_log.isInfoEnabled()) break block29;
                _log.info((Object)"Unable to remove key from subrepo processor queue", (Throwable)exception);
            }
        }
        jsonObject.remove("remove");
        try {
            String subrepoJSON = this.processURL("http://" + gitHubWebSubrepoHostname + "/osb-github-web/subrepo", jsonObject.toString());
            JSONObject subrepoJSONObject = new JSONObject(subrepoJSON);
            int queueSize = subrepoJSONObject.getInt("queueSize");
            String message6 = "This subrepo merge request was added to the processor queue at position " + queueSize;
            if (_log.isInfoEnabled()) {
                _log.info((Object)message6);
            }
            pullRequest.addComment(message6 + ".");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            message = "Skip merge subrepo because of an internal error";
            if (_log.isInfoEnabled()) {
                _log.info((Object)message, (Throwable)exception);
            }
            pullRequest.addComment(message + ".");
        }
    }

    protected void openPullRequest(PullRequest pullRequest) {
        if (!this.isGitHubPostEnabled()) {
            return;
        }
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("state", (Object)"open");
        String repositoryName = pullRequest.getGitHubRemoteGitRepositoryName();
        String pullRequestJSON = this.processURL(JenkinsResultsParserUtil.combine("https://api.github.com/repos/", pullRequest.getOwnerUsername(), "/", repositoryName, "/pulls/", String.valueOf(pullRequest.getNumber())), jsonObject.toString(), JenkinsResultsParserUtil.HttpRequestMethod.PATCH);
        JSONObject pullRequestJSONObject = new JSONObject(pullRequestJSON);
        JSONArray errorsJSONArray = pullRequestJSONObject.optJSONArray("errors");
        if (errorsJSONArray == null) {
            return;
        }
        for (int i = 0; i < errorsJSONArray.length(); ++i) {
            JSONObject errorJSONObject = errorsJSONArray.getJSONObject(i);
            String message = errorJSONObject.optString("message");
            if (message == null) continue;
            pullRequest.addComment("GitHub error message: " + message);
        }
    }

    protected void stopJenkinsTests(PullRequestCommentPayload pullRequestCommentPayload) {
        String regex;
        String ciStopSuite = null;
        PullRequest.Comment comment = pullRequestCommentPayload.getComment();
        String commentBody = comment.getBody();
        if (commentBody.matches(regex = "ci:stop:([^:\\s]+).*")) {
            ciStopSuite = commentBody.replaceAll(regex, "$1");
        }
        for (String buildURL : this.getBuildURLs(pullRequestCommentPayload.getPullRequest())) {
            Map<String, String> buildParameters;
            String ciTestSuite;
            if (!JenkinsResultsParserUtil.isNullOrEmpty(ciStopSuite) && !(ciTestSuite = (buildParameters = JenkinsResultsParserUtil.getBuildParameters(buildURL)).getOrDefault("CI_TEST_SUITE", "")).equals(ciStopSuite)) continue;
            try {
                JenkinsStopBuildUtil.stopBuild(buildURL);
            }
            catch (Exception exception) {
                throw new RuntimeException("Unable to stop build " + buildURL, exception);
            }
        }
    }

    protected void syncAutopull(PushEventPayload pushEventPayload) {
        RemoteGitBranch pusherRemoteGitBranch = pushEventPayload.getPusherRemoteGitBranch();
        if (pusherRemoteGitBranch == null) {
            return;
        }
        String branchName = pusherRemoteGitBranch.getName();
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Sync autopull branch " + branchName));
        }
        GitHubRemoteGitRepository gitHubRemoteGitRepository = pushEventPayload.getRemoteGitRepository();
        String ownerName = gitHubRemoteGitRepository.getUsername();
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Sync autopull owner " + ownerName));
        }
        if (!ownerName.equals("liferay")) {
            if (_log.isInfoEnabled()) {
                _log.info((Object)("Skip sync autopull because the owner " + ownerName + " is not on the whitelist"));
            }
            return;
        }
        String repositoryName = gitHubRemoteGitRepository.getName();
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Sync autopull repo " + repositoryName));
        }
        if (!this.isValidAutopull(repositoryName)) {
            _log.info((Object)"Skip sync autopull because the repo name is invalid");
            return;
        }
        String jenkinsAuthenticationToken = this._jenkinsBuildProperties.getProperty("jenkins.authentication.token");
        ArrayList<String> urls = new ArrayList<String>();
        urls.add(JenkinsResultsParserUtil.combine("http://test-1-0/job/merge-central-subrepository(", branchName, ")/buildWithParameters?token=", jenkinsAuthenticationToken));
        urls.add(JenkinsResultsParserUtil.combine("http://test-1-0/job/merge-central-subrepository(", this.getCompanionBranchName(branchName), ")/buildWithParameters?token=", jenkinsAuthenticationToken));
        for (String url : urls) {
            if (this.isGitHubAutopullEnabled()) {
                try {
                    this.processURL(url);
                    continue;
                }
                catch (Exception exception) {
                    if (_log.isInfoEnabled()) {
                        _log.info((Object)"Skip sync autopull", (Throwable)exception);
                    }
                    return;
                }
            }
            if (!_log.isInfoEnabled()) continue;
            _log.info((Object)("Sync autopull URL " + url));
        }
    }

    protected void syncRepository(PushEventPayload pushEventPayload) {
        block7: {
            if (!this.isGitHubRepositorySyncEnabled()) {
                return;
            }
            GitHubRemoteGitRepository gitHubRemoteGitRepository = pushEventPayload.getRemoteGitRepository();
            String ownerName = gitHubRemoteGitRepository.getUsername();
            if (!ownerName.equals("liferay")) {
                if (_log.isInfoEnabled()) {
                    _log.info((Object)("Skip sync mirror because the owner " + ownerName + " is not on the whitelist"));
                }
                return;
            }
            String repositoryName = gitHubRemoteGitRepository.getName();
            if (_log.isInfoEnabled()) {
                _log.info((Object)("Sync repo " + repositoryName));
            }
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("repo", (Object)repositoryName);
            String sha = pushEventPayload.getAfterSHA();
            if (_log.isInfoEnabled()) {
                _log.info((Object)("Sync SHA " + sha));
            }
            jsonObject.put("sha", (Object)sha);
            String gitHubWebMirrorHostname = this._jenkinsBuildProperties.getProperty("github.webhook.repository.sync.web.hostname");
            try {
                this.processURL("http://" + gitHubWebMirrorHostname + "/osb-github-web/mirror", jsonObject.toString());
            }
            catch (Exception exception) {
                if (!_log.isInfoEnabled()) break block7;
                _log.info((Object)"Skip sync mirror", (Throwable)exception);
            }
        }
    }

    protected void syncSubrepo(PushEventPayload pushEventPayload) {
        block12: {
            if (!this.isGitHubSubrepoSyncEnabled()) {
                return;
            }
            RemoteGitBranch pusherRemoteGitBranch = pushEventPayload.getPusherRemoteGitBranch();
            if (pusherRemoteGitBranch == null) {
                return;
            }
            String branchName = pusherRemoteGitBranch.getName();
            if (_log.isInfoEnabled()) {
                _log.info((Object)("Sync subrepo branch " + branchName));
            }
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("branch", (Object)branchName);
            GitHubRemoteGitRepository gitHubRemoteGitRepository = pushEventPayload.getRemoteGitRepository();
            String ownerName = gitHubRemoteGitRepository.getUsername();
            if (!ownerName.equals("liferay")) {
                if (_log.isInfoEnabled()) {
                    _log.info((Object)("Skip sync subrepo because the owner " + ownerName + " is not on the whitelist"));
                }
                return;
            }
            String repositoryName = this._payload.get("repository/name");
            if (_log.isInfoEnabled()) {
                _log.info((Object)("Sync subrepo repo " + repositoryName));
            }
            jsonObject.put("repo", (Object)repositoryName);
            String sha = pushEventPayload.getAfterSHA();
            if (_log.isInfoEnabled()) {
                _log.info((Object)("Sync subrepo SHA " + sha));
            }
            jsonObject.put("pullRequestNumber", (Object)"0").put("sha", (Object)sha);
            String command = "push";
            String propertyName = "github.webhook.subrepository.sync.subrepo.web.hostname";
            String subrepo = "all";
            if (this.isBotPush(pushEventPayload)) {
                command = "release";
                propertyName = "github.webhook.subrepository.sync.release.web.hostname";
                subrepo = this.getSubrepoPath(pushEventPayload);
            }
            jsonObject.put("command", (Object)command);
            if (_log.isInfoEnabled()) {
                _log.info((Object)("Sync subrepo command " + command));
            }
            jsonObject.put("subrepo", (Object)subrepo);
            if (_log.isInfoEnabled()) {
                _log.info((Object)("Sync subrepo argument " + subrepo));
            }
            String gitHubWebSubrepoHostname = this._jenkinsBuildProperties.getProperty(propertyName);
            try {
                this.processURL("http://" + gitHubWebSubrepoHostname + "/osb-github-web/subrepo", jsonObject.toString());
            }
            catch (Exception exception) {
                if (!_log.isInfoEnabled()) break block12;
                _log.info((Object)"Skip sync subrepo", (Throwable)exception);
            }
        }
    }

    protected void testPullRequest(PullRequestTesterParameters pullRequestTesterParameters) {
        String masterURL;
        block3: {
            if (!this.isTestablePullRequest(pullRequestTesterParameters.getPullRequest())) {
                return;
            }
            String pullRequestTesterQueryString = pullRequestTesterParameters.toQueryString();
            this.addTestPullRequestQueryString(pullRequestTesterQueryString);
            masterURL = "http://test-1.liferay.com";
            try {
                masterURL = JenkinsResultsParserUtil.getMostAvailableMasterURL("http://test-1.liferay.com", this._jenkinsBuildProperties.getProperty("jenkins.load.balancer.blacklist", ""), 1, JenkinsMaster.getSlaveRAMMinimumDefault(), JenkinsMaster.getSlavesPerHostDefault());
            }
            catch (Exception exception) {
                if (!_log.isInfoEnabled()) break block3;
                _log.info((Object)"Setting base invocation URL to http://test-1.liferay.com because load balancer threw an exception");
            }
        }
        this.invokePullRequestTester(masterURL, pullRequestTesterParameters);
    }

    private String _cleanupJSONSource(String source) {
        StringBuilder sb = new StringBuilder();
        while (!source.isEmpty()) {
            int start = source.indexOf("\"");
            if (start == -1) {
                sb.append(source);
                source = "";
                continue;
            }
            sb.append(source.substring(0, start));
            int end = source.indexOf("\"", start + 1);
            if (end == -1) {
                throw new IllegalArgumentException("Unterminated quote found after index " + start);
            }
            String quotedString = source.substring(start, end + 1);
            if (quotedString.contains("\n")) {
                quotedString = quotedString.replaceAll("\n", "");
                System.out.println("quotedString:\n" + quotedString);
            }
            sb.append(quotedString);
            source = source.substring(end + 1);
        }
        return sb.toString();
    }

    private List<String> _getCIEnabledBranchNames(String repositoryName) {
        String ciEnabledBranchNames = this._jenkinsBuildProperties.getProperty(JenkinsResultsParserUtil.combine("github.ci.enabled.branch.names[", repositoryName, "]"), "");
        return Arrays.asList(ciEnabledBranchNames.split(","));
    }

    private void _processCommentCreated(PullRequestCommentPayload pullRequestCommentPayload) {
        Matcher matcher;
        StringBuilder sb;
        PullRequest.Comment comment = pullRequestCommentPayload.getComment();
        String body = comment.getBody();
        String login = comment.getUserLogin();
        PullRequest pullRequest = pullRequestCommentPayload.getPullRequest();
        if (body.startsWith("ci:") && !body.contains("ci:help") && !this.isLiferayUser(login)) {
            if (_log.isInfoEnabled()) {
                _log.info((Object)JenkinsResultsParserUtil.combine("Skip CI action because ", login, " is not a Liferay member"));
            }
            if (this.hasLiferayEmailAddress(login)) {
                StringBuilder sb2 = new StringBuilder();
                sb2.append("You cannot perform that action because you ");
                sb2.append("are not a member of the Liferay organization. ");
                sb2.append("Please make sure that you have been added and ");
                sb2.append("that your organization membership is set as ");
                sb2.append("Public. See https://help.github.com/articles");
                sb2.append("/publicizing-or-hiding-organization-");
                sb2.append("membership for more information.");
                pullRequest.addComment(sb2.toString());
            }
            return;
        }
        PullRequestTesterParameters pullRequestTesterParameters = new PullRequestTesterParameters(pullRequest);
        if (body.startsWith("ci:close")) {
            if (_log.isInfoEnabled()) {
                _log.info((Object)"Comment triggered close pull request");
            }
            pullRequest.close();
        }
        if (body.startsWith("ci:forward")) {
            pullRequestTesterParameters.setCiForwardReceiverUsername(this._jenkinsBuildProperties.getProperty("pull.request.forward.default.receiver.username"));
            String[] ciForwardRequiredTestSuites = this.getCIForwardRequiredTestSuites();
            if (ciForwardRequiredTestSuites.length == 0) {
                StringBuilder sb3 = new StringBuilder();
                sb3.append("There are no required test suites specified ");
                sb3.append("for `ci:forward`.\nNo test will be triggered.");
                sb3.append("\nIf you think this is a mistake please ");
                sb3.append("contact the CI Infrastructure team.");
                pullRequest.addComment(sb3.toString());
                return;
            }
            String[] ciForwardRequiredPassingSuites = this.getCIForwardRequiredPassingSuites();
            if (ciForwardRequiredPassingSuites.length == 0) {
                StringBuilder sb4 = new StringBuilder();
                sb4.append("There are no required passing suites specified");
                sb4.append(" for `ci:forward`.\nNo test will be triggered.");
                sb4.append("\nIf you think this is a mistake please ");
                sb4.append("contact the CI Infrastructure team.");
                pullRequest.addComment(sb4.toString());
                return;
            }
            sb = new StringBuilder();
            sb.append("CI is automatically triggering the following ");
            sb.append("test suites:\n");
            for (String ciForwardRequiredTestSuite : ciForwardRequiredTestSuites) {
                sb.append("- &nbsp;&nbsp;&nbsp;&nbsp;ci:test:**");
                sb.append(ciForwardRequiredTestSuite);
                sb.append("**\n");
            }
            sb.append("\n");
            sb.append("The pull request will automatically be forwarded ");
            sb.append("to the user `");
            sb.append(pullRequestTesterParameters.getCiForwardReceiverUsername());
            sb.append("` if the following test suites pass:\n");
            this._ciForwardEligible = true;
            String[] passingTestSuites = this.getPassingTestSuites(pullRequest);
            for (String ciForwardRequiredPassingSuite : ciForwardRequiredPassingSuites) {
                sb.append("- &nbsp;&nbsp;&nbsp;&nbsp;ci:test:**");
                sb.append(ciForwardRequiredPassingSuite);
                sb.append("**\n");
                if (passingTestSuites.contains(ciForwardRequiredPassingSuite)) continue;
                this._ciForwardEligible = false;
            }
            pullRequest.addComment(sb.toString());
            ArrayList<String> skippedTestSuites = new ArrayList<String>(ciForwardRequiredTestSuites.length);
            for (String ciForwardRequiredTestSuite : ciForwardRequiredTestSuites) {
                if (passingTestSuites.contains(ciForwardRequiredTestSuite)) {
                    skippedTestSuites.add(ciForwardRequiredTestSuite);
                    continue;
                }
                pullRequestTesterParameters.setCiTestSuiteName(ciForwardRequiredTestSuite);
                this.testPullRequest(pullRequestTesterParameters);
            }
            if (!skippedTestSuites.isEmpty()) {
                sb = new StringBuilder();
                sb.append("Skipping previously passed test suites:\n");
                for (String skippedTestSuite : skippedTestSuites) {
                    sb.append("`ci:test:");
                    sb.append(skippedTestSuite);
                    sb.append("`\n");
                }
                if (_log.isInfoEnabled()) {
                    _log.info((Object)sb.toString());
                }
                pullRequest.addComment(sb.toString());
            }
            if (this._ciForwardEligible) {
                this.testPullRequest(pullRequestTesterParameters);
            }
        }
        if (body.startsWith("ci:help")) {
            if (_log.isInfoEnabled()) {
                _log.info((Object)"Comment triggered help message");
            }
            StringBuilder sb5 = new StringBuilder();
            sb5.append("## Available CI commands:\n");
            sb5.append("#### ci:close\n");
            sb5.append("&nbsp;&nbsp;&nbsp;&nbsp;Close the pull request.\n");
            String ciForwardReceiverUsername = this._jenkinsBuildProperties.getProperty("pull.request.forward.default.receiver.username");
            if (ciForwardReceiverUsername != null && !ciForwardReceiverUsername.isEmpty()) {
                sb5.append("#### ci:forward\n");
                sb5.append("&nbsp;&nbsp;&nbsp;&nbsp;Test the pull request ");
                sb5.append(" and forward the pullrequest to `");
                sb5.append(ciForwardReceiverUsername);
                sb5.append("` if the required test suites pass.\n");
            }
            sb5.append("#### ci:merge[:force]\n");
            sb5.append("&nbsp;&nbsp;&nbsp;&nbsp;Merge in the changes from ");
            sb5.append("the subrepo. All tests must pass before this ");
            sb5.append("command will successfully run. Optionally use the ");
            sb5.append("force flag to bypass failed tests.\n");
            sb5.append("#### ci:reevaluate:[buildID]\n");
            sb5.append("&nbsp;&nbsp;&nbsp;&nbsp;Reevaluate the pull request ");
            sb5.append("result from a generated build ID.\n");
            sb5.append("#### ci:reopen\n");
            sb5.append("&nbsp;&nbsp;&nbsp;&nbsp;Reopen the pull request.\n");
            sb5.append("#### ci:stop[:suite]\n");
            sb5.append("&nbsp;&nbsp;&nbsp;&nbsp;Stop all currrently ");
            sb5.append("running tests. Optionally specify the name of the ");
            sb5.append("test suite.\n");
            String ciTestAvailableSuites = JenkinsResultsParserUtil.getCIProperty(pullRequest.getUpstreamRemoteGitBranchName(), "ci.test.available.suites", pullRequest.getGitHubRemoteGitRepositoryName());
            if (ciTestAvailableSuites != null) {
                sb5.append("#### ci:test[:suite][:SHA|nocompile|");
                sb5.append("norebase]\n");
                sb5.append("&nbsp;&nbsp;&nbsp;&nbsp;Test the pull request.");
                sb5.append("Optionally specify the name of the test suite ");
                sb5.append("and/or optionally specify the upstream SHA to ");
                sb5.append("test against or use \"nocompile\" to test ");
                sb5.append("with a prebuilt bundle or use \"norebase\" to ");
                sb5.append("test without rebasing.");
                sb5.append("\n\n&nbsp;&nbsp;&nbsp;&nbsp;List of ");
                sb5.append("available test suites:\n");
                for (String ciTestAvailableSuite : ciTestAvailableSuites.split(",")) {
                    sb5.append("- &nbsp;&nbsp;&nbsp;&nbsp;ci:test:**");
                    sb5.append(ciTestAvailableSuite);
                    sb5.append("** - ");
                    String ciTestSuiteDescription = JenkinsResultsParserUtil.getCIProperty(pullRequest.getUpstreamRemoteGitBranchName(), JenkinsResultsParserUtil.combine("ci.test.suite.description[", ciTestAvailableSuite, "]"), pullRequest.getGitHubRemoteGitRepositoryName());
                    if (ciTestSuiteDescription != null) {
                        sb5.append(ciTestSuiteDescription);
                    } else {
                        sb5.append("No description is available.");
                    }
                    sb5.append("\n");
                }
            } else {
                sb5.append("#### ci:test[:SHA|nocompile|norebase]\n");
                sb5.append("&nbsp;&nbsp;&nbsp;&nbsp;Test the pull request");
                sb5.append(". Optionally specify the upstream SHA to test ");
                sb5.append("against or use \"nocompile\" to test with a ");
                sb5.append("prebuilt bundle or use \"norebase\" to test ");
                sb5.append("without rebasing.\n");
            }
            sb5.append("\n");
            sb5.append("For more details, see ");
            sb5.append("[GROW](https://grow.liferay.com/share/CI+");
            sb5.append("liferay-continuous-integration+GitHub+Commands).");
            pullRequest.addComment(sb5.toString());
        }
        if (body.startsWith("ci:merge")) {
            if (_log.isInfoEnabled()) {
                _log.info((Object)"Comment triggered merge subrepo");
            }
            if (body.startsWith("ci:merge:force")) {
                if (!(login.equals("brianchandotcom") || login.equals("brianwulbern") || login.equals("jpince") || login.equals("pyoo47") || login.equals("shuyangzhou") || login.equals("stsquared99"))) {
                    String message = "Only Brian Chan can force a merge";
                    if (_log.isInfoEnabled()) {
                        _log.info((Object)message);
                    }
                    pullRequest.addComment(message + ".");
                    return;
                }
                this.mergeSubrepo(pullRequest, true);
            } else {
                this.mergeSubrepo(pullRequest, false);
            }
        }
        if (body.startsWith("ci:reevaluate")) {
            matcher = _reevaluatePattern.matcher(body);
            StringBuilder sb6 = new StringBuilder();
            if (matcher.find()) {
                if (_log.isInfoEnabled()) {
                    _log.info((Object)"Comment triggered reevaluate");
                }
                String buildID = matcher.group("buildID");
                pullRequestTesterParameters.setCiReevaluateBuildId(buildID);
                sb6.append("CI is reevaluating the build with build ID: `");
                sb6.append(buildID);
                sb6.append("` against the latest valid upstream results.");
                pullRequest.addComment(sb6.toString());
                this.testPullRequest(pullRequestTesterParameters);
            } else {
                sb6.append("There is a missing or invalid build ID. ");
                sb6.append("No reevaluation was triggered.");
                pullRequest.addComment(sb6.toString());
            }
        }
        if (body.startsWith("ci:reopen")) {
            if (_log.isInfoEnabled()) {
                _log.info((Object)"Comment triggered open pull request");
            }
            this.openPullRequest(pullRequest);
        }
        if (body.startsWith("ci:retest") || body.startsWith("ci:test")) {
            matcher = _testPattern.matcher(body);
            if (matcher.find()) {
                List<String> testOptions;
                String message;
                String testOption1 = matcher.group("testOption1");
                if (testOption1.matches("[0-9a-f]{7,40}")) {
                    if (this.isValidPullRequestRefSHA(pullRequest, testOption1)) {
                        pullRequestTesterParameters.setUpstreamBranchSHA(testOption1);
                    } else {
                        sb = new StringBuilder();
                        sb.append("The test option '");
                        sb.append(testOption1);
                        sb.append("' matching SHA pattern [0-9a-f]{7,40}");
                        sb.append(" is not a valid upstream SHA.\n");
                        sb.append("The test will start with '");
                        sb.append(testOption1);
                        sb.append("' as the test suite");
                        message = sb.toString();
                        if (_log.isInfoEnabled()) {
                            _log.info((Object)message);
                        }
                        pullRequest.addComment(message + ".");
                        pullRequestTesterParameters.setCiTestSuiteName(testOption1);
                    }
                } else {
                    if (testOption1.equals("forward")) {
                        sb = new StringBuilder();
                        sb.append("The test will not be initiated because ");
                        sb.append("`ci:test:forward` is not a valid command. ");
                        sb.append("Please use `ci:forward` instead");
                        message = sb.toString();
                        if (_log.isInfoEnabled()) {
                            _log.info((Object)message);
                        }
                        pullRequest.addComment(message + ".");
                        return;
                    }
                    if (!testOption1.equals("nocompile") && !testOption1.equals("norebase")) {
                        pullRequestTesterParameters.setCiTestSuiteName(testOption1);
                    }
                }
                String testOption2 = matcher.group("testOption2");
                if (testOption2 != null) {
                    if (testOption2.matches("[0-9a-f]{7,40}")) {
                        pullRequestTesterParameters.setUpstreamBranchSHA(testOption2);
                    } else if (testOption2.equals("forward")) {
                        StringBuilder sb7 = new StringBuilder(5);
                        sb7.append("The test will not be initiated ");
                        sb7.append("because ");
                        sb7.append("`ci:test:[testsuite]:forward` ");
                        sb7.append("is not a valid command. Please use");
                        sb7.append("`ci:forward` instead");
                        String message2 = sb7.toString();
                        if (_log.isInfoEnabled()) {
                            _log.info((Object)message2);
                        }
                        pullRequest.addComment(message2 + ".");
                        return;
                    }
                }
                if ((testOptions = Arrays.asList(testOption1, testOption2)).contains("nocompile")) {
                    String distPortalBundlesBuildURL = JenkinsResultsParserUtil.getDistPortalBundlesBuildURL(pullRequest.getUpstreamRemoteGitBranchName());
                    String message3 = null;
                    if (distPortalBundlesBuildURL != null) {
                        pullRequestTesterParameters.setPortalBundlesDistURL(distPortalBundlesBuildURL);
                        String upstreamBranchSHA = this.processURL(distPortalBundlesBuildURL + "/git-hash");
                        pullRequestTesterParameters.setUpstreamBranchSHA(upstreamBranchSHA.trim());
                        message3 = "The test will run with a prebuilt bundle.";
                    } else {
                        message3 = "No valid prebuilt bundle is available.";
                    }
                    if (_log.isInfoEnabled()) {
                        _log.info((Object)message3);
                    }
                    pullRequest.addComment(message3 + ".");
                } else if (testOptions.contains("norebase")) {
                    String message4 = "The test will run without rebasing.";
                    if (_log.isInfoEnabled()) {
                        _log.info((Object)message4);
                    }
                    pullRequest.addComment(message4 + ".");
                    pullRequestTesterParameters.setUpstreamBranchSHA(pullRequest.getCommonParentSHA());
                }
                String testSuiteName = pullRequestTesterParameters.getCiTestSuiteName();
                if (testSuiteName != null && testSuiteName.equals("gauntlet") && !_gauntletUsernames.contains(login)) {
                    String message5 = "You do not have permission to run the test gauntlet";
                    if (_log.isInfoEnabled()) {
                        _log.info((Object)message5);
                    }
                    pullRequest.addComment(message5 + ".");
                    return;
                }
            }
            if (_log.isInfoEnabled()) {
                _log.info((Object)"Comment triggered test");
            }
            this.testPullRequest(pullRequestTesterParameters);
        }
        if (body.startsWith("ci:stop")) {
            if (_log.isInfoEnabled()) {
                _log.info((Object)"Comment triggered stop");
            }
            this.stopJenkinsTests(pullRequestCommentPayload);
        }
    }

    private void _processPullRequestOpened(PullRequestPayload pullRequestPayload) {
        List<String> ciTestAutoTestSuiteNames;
        PullRequest pullRequest = pullRequestPayload.getPullRequest();
        PullRequestTesterParameters pullRequestTesterParameters = new PullRequestTesterParameters(pullRequest);
        List<PullRequest.Comment> pullRequestComments = pullRequest.getComments();
        PullRequest.Comment initialComment = pullRequestComments.get(0);
        String body = initialComment.getBody();
        String githubCIUsername = this._jenkinsBuildProperties.getProperty("github.ci.username");
        String ownerName = pullRequest.getOwnerUsername();
        String pullRequestForwardDefaultReceiverUsername = this._jenkinsBuildProperties.getProperty("pull.request.forward.default.receiver.username");
        String refName = pullRequest.getUpstreamRemoteGitBranchName();
        String repositoryName = pullRequest.getGitHubRemoteGitRepositoryName();
        String senderName = pullRequest.getSenderUsername();
        if (body.startsWith("Forwarded from:") && ownerName.equals(pullRequestForwardDefaultReceiverUsername) && senderName.equals(githubCIUsername)) {
            StringBuilder sb = new StringBuilder(2);
            sb.append("To conserve resources, the PR Tester does not ");
            sb.append("automatically run for forwarded pull requests.");
            pullRequest.addComment(sb.toString());
            return;
        }
        if (ownerName.equals(this.getSubrepoCentralMergePullRequestRecipientName(refName)) && pullRequest.isMergeSubrepoRequest()) {
            this.commentMergeSubrepoPullRequest(pullRequest);
            pullRequestTesterParameters.setCiTestSuiteName("relevant");
            this.testPullRequest(pullRequestTesterParameters);
            pullRequestTesterParameters.setCiTestSuiteName("sf");
            this.testPullRequest(pullRequestTesterParameters);
            return;
        }
        if (ownerName.equals("brianchandotcom") && repositoryName.contains("liferay-portal")) {
            if (!this.isTestablePullRequest(pullRequest)) {
                return;
            }
            if (refName.startsWith("ee-")) {
                StringBuilder sb = new StringBuilder(4);
                sb.append("CI is automatically triggering &quot;ci:");
                sb.append("test:sf&quot; for this pull to run Source ");
                sb.append("Formatter.\n\nComment &quot;ci:test&quot; ");
                sb.append("to run the full PR Tester for this pull.");
                pullRequest.addComment(sb.toString());
            } else {
                StringBuilder sb = new StringBuilder(6);
                sb.append("CI is automatically triggering &quot;ci:");
                sb.append("test:sf&quot; and &quot;ci:test:relevant");
                sb.append("&quot; for this pull to run Source ");
                sb.append("Formatter and relevant tests.\n\nComment ");
                sb.append("&quot;ci:test&quot; to run the full PR ");
                sb.append("Tester for this pull.");
                pullRequest.addComment(sb.toString());
                pullRequestTesterParameters.setCiTestSuiteName("relevant");
                this.testPullRequest(pullRequestTesterParameters);
            }
            pullRequestTesterParameters.setCiTestSuiteName("sf");
            this.testPullRequest(pullRequestTesterParameters);
            return;
        }
        if (!ownerName.equals("liferay") && !(ciTestAutoTestSuiteNames = this.getCITestAutoTestSuiteNames(pullRequest)).isEmpty() && this.isTestablePullRequest(pullRequest)) {
            StringBuilder sb = new StringBuilder();
            sb.append("CI is automatically triggering the following ");
            sb.append("test suites:\n");
            for (String ciTestAutoTestSuiteName : ciTestAutoTestSuiteNames) {
                sb.append("- &nbsp;&nbsp;&nbsp;&nbsp;ci:test:**");
                sb.append(ciTestAutoTestSuiteName);
                sb.append("**\n");
            }
            pullRequest.addComment(sb.toString());
            for (String ciTestAutoTestSuiteName : ciTestAutoTestSuiteNames) {
                pullRequestTesterParameters.setCiTestSuiteName(ciTestAutoTestSuiteName);
                this.testPullRequest(pullRequestTesterParameters);
            }
            return;
        }
        if (this.isLiferayUser(pullRequest.getSenderUsername())) {
            StringBuilder sb = new StringBuilder(7);
            sb.append("To conserve resources, the PR Tester does not ");
            sb.append("automatically run for every pull.\n\nIf your ");
            sb.append("code changes were already tested in another ");
            sb.append("pull, reference that pull in this pull so ");
            sb.append("the test results can be analyzed.\n\nIf your ");
            sb.append("pull was never tested, comment ");
            sb.append("&quot;ci:test&quot; to run the PR Tester for ");
            sb.append("this pull.");
            GitHubRemoteGitRepository gitHubRemoteGitRepository = pullRequest.getGitHubRemoteGitRepository();
            if (!ownerName.equals("liferay") || gitHubRemoteGitRepository.isSubrepository() || repositoryName.equals("liferay-portal-ee")) {
                pullRequest.addComment(sb.toString());
            }
        }
    }

    private void _processPullRequestSynchronize(PullRequestPayload pullRequestPayload) {
        PullRequest pullRequest = pullRequestPayload.getPullRequest();
        if (this.isSynchronizeablePullRequest(pullRequest)) {
            return;
        }
        if (_log.isInfoEnabled()) {
            _log.info((Object)"Synchronize triggered close pull request");
        }
        String message = JenkinsResultsParserUtil.combine("Closing and locking pull request because pull requests ", "sent to this user may not be updated. Please resend ", "this pull request.");
        pullRequest.addComment(message);
        pullRequest.close();
        pullRequest.lock();
    }

    static {
        _passingTestSuiteStatusDescriptionPattern = Pattern.compile("\"ci:test:(?<testSuiteName>[^\"]+)\"\\s*has PASSED.");
        _reevaluatePattern = Pattern.compile("ci:reevaluate:(?<buildID>[\\d]+_[\\d]+)");
        _testPattern = Pattern.compile("ci:(re)?test:(?<testOption1>[^:\\s]+)(:(?<testOption2>[^:\\s]+))?");
        _whiteListedOwnerNames = Collections.emptyList();
        _whiteListedRepositoryMultiPattern = new MultiPattern("com-liferay-.*", "liferay-fix-pack-builder-ee", "liferay-jenkins-ee", "liferay-plugins(-ee)?", "liferay-portal(-ee)?");
    }
}

