/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser.jethr0;

import com.liferay.jenkins.results.parser.JenkinsMaster;
import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.jethr0.Jethr0Client;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.TreeSet;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.Session;
import javax.jms.TextMessage;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.json.JSONArray;
import org.json.JSONObject;

public abstract class BaseJethr0Client
implements Jethr0Client {
    private Connection _connection;
    private final Jethr0Client.Environment _environment;
    private final JenkinsMaster _jenkinsMaster;
    private final Map<String, MessageConsumer> _messageConsumers = new HashMap<String, MessageConsumer>();
    private String _oAuthAccessToken;
    private String _oAuthClientId;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void close() throws IOException {
        if (this._connection == null) {
            return;
        }
        Map<String, MessageConsumer> map = this._messageConsumers;
        synchronized (map) {
            try {
                for (MessageConsumer messageConsumer : this._messageConsumers.values()) {
                    if (messageConsumer == null) continue;
                    messageConsumer.close();
                }
                if (this._connection != null) {
                    this._connection.close();
                }
            }
            catch (JMSException jmsException) {
                throw new IOException(jmsException);
            }
            finally {
                this._connection = null;
                this._messageConsumers.clear();
            }
        }
    }

    @Override
    public synchronized void connect() {
        if (this._connection != null) {
            return;
        }
        ActiveMQConnectionFactory connectionFactory = new ActiveMQConnectionFactory(this.getJMSBrokerURL());
        try {
            this._connection = connectionFactory.createConnection(this.getJMSUserName(), this.getJMSUserPassword());
            this._connection.start();
        }
        catch (JMSException jmsException) {
            throw new RuntimeException(jmsException);
        }
    }

    @Override
    public void createBuild(String jenkinsJobName, Map<String, String> jenkinsBuildParameters, long jobId) {
        this.createBuild(jenkinsJobName, jenkinsBuildParameters, jobId, jenkinsJobName);
    }

    @Override
    public void createBuild(String jenkinsJobName, Map<String, String> jenkinsBuildParameters, long jobId, String buildName) {
        JSONObject jobJSONObject = new JSONObject();
        jobJSONObject.put("id", (Object)jobId);
        JSONArray parametersJSONArray = new JSONArray();
        TreeSet<String> parameterNames = new TreeSet<String>(jenkinsBuildParameters.keySet());
        for (String parameterName : parameterNames) {
            String parameterValue;
            if (!parameterName.matches("[A-Z0-9_]+") || JenkinsResultsParserUtil.isNullOrEmpty(parameterValue = jenkinsBuildParameters.get(parameterName))) continue;
            JSONObject parameterJSONObject = new JSONObject();
            parameterJSONObject.put("name", (Object)parameterName).put("value", (Object)parameterValue);
            parametersJSONArray.put((Object)parameterJSONObject);
        }
        JSONObject buildJSONObject = new JSONObject();
        if (JenkinsResultsParserUtil.isNullOrEmpty(buildName)) {
            buildName = jenkinsJobName;
        }
        buildJSONObject.put("jenkinsJobName", (Object)jenkinsJobName).put("name", (Object)buildName).put("parameters", (Object)parametersJSONArray.toString());
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("build", (Object)buildJSONObject).put("eventType", (Object)Jethr0Client.EventType.CREATE_BUILD).put("job", (Object)jobJSONObject);
        this.sendJRPMessageToJethr0(jsonObject.toString());
    }

    @Override
    public void createBuildRun(long buildId) {
        JSONObject buildJSONObject = new JSONObject();
        buildJSONObject.put("id", buildId);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("build", (Object)buildJSONObject).put("eventType", (Object)Jethr0Client.EventType.CREATE_BUILD_RUN);
        this.sendJRPMessageToJethr0(jsonObject.toString());
    }

    @Override
    public Jethr0Client.Environment getEnvironment() {
        return this._environment;
    }

    @Override
    public JenkinsMaster getJenkinsMaster() {
        return this._jenkinsMaster;
    }

    @Override
    public JSONObject getJobJSONObject(long jobId) {
        return new JSONObject(this.springBootRequest(this.getSpringBootURL() + "/jobs/" + jobId, null));
    }

    @Override
    public String liferayDXPRequest(String urlPath) {
        return this._requestLiferayDXPMessage(urlPath, null, JenkinsResultsParserUtil.HttpRequestMethod.GET);
    }

    @Override
    public String liferayDXPRequest(String urlPath, String message) {
        return this._requestLiferayDXPMessage(urlPath, message, JenkinsResultsParserUtil.HttpRequestMethod.POST);
    }

    @Override
    public void sendGitHubMessageToJethr0(String message) {
        this.connect();
        try {
            Session session = this._connection.createSession(false, 1);
            Queue queue = session.createQueue(this.getJMSGitHubToJethr0QueueName());
            MessageProducer messageProducer = session.createProducer((Destination)queue);
            messageProducer.send((Message)session.createTextMessage(message));
        }
        catch (JMSException jmsException) {
            throw new RuntimeException(jmsException);
        }
    }

    @Override
    public void sendJRPMessageToJethr0(String message) {
        this.connect();
        try {
            Session session = this._connection.createSession(false, 1);
            Queue queue = session.createQueue(this.getJMSJRPToJethr0QueueName());
            MessageProducer messageProducer = session.createProducer((Destination)queue);
            TextMessage textMessage = session.createTextMessage(message);
            textMessage.setStringProperty("jenkinsMasterName", this._jenkinsMaster.getName());
            messageProducer.send((Message)textMessage);
        }
        catch (JMSException jmsException) {
            throw new RuntimeException(jmsException);
        }
    }

    @Override
    public String springBootRequest(String urlPath) {
        return this._requestSpringBootMessage(urlPath, null, JenkinsResultsParserUtil.HttpRequestMethod.GET);
    }

    @Override
    public String springBootRequest(String urlPath, String message) {
        return this._requestSpringBootMessage(urlPath, message, JenkinsResultsParserUtil.HttpRequestMethod.POST);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void subscribe(MessageListener messageListener, String messageSelector) throws JMSException {
        Map<String, MessageConsumer> map = this._messageConsumers;
        synchronized (map) {
            if (this._messageConsumers.containsKey(messageSelector)) {
                return;
            }
            ActiveMQConnectionFactory connectionFactory = new ActiveMQConnectionFactory(this.getJMSBrokerURL());
            Connection connection = connectionFactory.createConnection(this.getJMSUserName(), this.getJMSUserPassword());
            connection.start();
            Session session = connection.createSession(false, 1);
            Queue queue = session.createQueue(this.getJMSJethr0ToJRPQueueName());
            MessageConsumer messageConsumer = session.createConsumer((Destination)queue, messageSelector);
            messageConsumer.setMessageListener(messageListener);
            this._messageConsumers.put(messageSelector, messageConsumer);
            System.out.println("Subscribed with selector \"" + messageSelector + "\"");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unsubscribe(MessageListener messageListener, String messageSelector) throws JMSException {
        Map<String, MessageConsumer> map = this._messageConsumers;
        synchronized (map) {
            if (!this._messageConsumers.containsKey(messageSelector)) {
                return;
            }
            MessageConsumer messageConsumer = this._messageConsumers.get(messageSelector);
            if (messageConsumer == null) {
                return;
            }
            messageConsumer.close();
            this._messageConsumers.remove(messageSelector);
            System.out.println("Unsubscribed with selector \"" + messageSelector + "\"");
        }
    }

    protected BaseJethr0Client(JenkinsMaster jenkinsMaster) {
        this._jenkinsMaster = jenkinsMaster;
        this._environment = this._getEnvironment();
    }

    protected String getBuildPropertyString(String buildPropertyName) {
        Jethr0Client.Environment environment = this.getEnvironment();
        try {
            return JenkinsResultsParserUtil.getBuildProperty(buildPropertyName, environment.getKey());
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
    }

    protected URL getBuildPropertyURL(String buildPropertyName) {
        try {
            return new URL(this.getBuildPropertyString(buildPropertyName));
        }
        catch (MalformedURLException malformedURLException) {
            throw new RuntimeException(malformedURLException);
        }
    }

    protected abstract String getJMSBrokerURL();

    protected abstract String getJMSGitHubToJethr0QueueName();

    protected abstract String getJMSJethr0ToJRPQueueName();

    protected abstract String getJMSJRPToJethr0QueueName();

    protected abstract String getJMSUserName();

    protected abstract String getJMSUserPassword();

    protected abstract URL getLiferayDXPURL();

    protected abstract String getOAuthClientSecret();

    protected abstract String getOAuthExternalReferenceCode();

    protected abstract URL getSpringBootURL();

    private Jethr0Client.Environment _getEnvironment() {
        try {
            Properties buildProperties = JenkinsResultsParserUtil.getBuildProperties();
            for (Jethr0Client.Environment environment : Jethr0Client.Environment.values()) {
                String jenkinsMasterNames = JenkinsResultsParserUtil.getProperty(buildProperties, "jethr0.jenkins.masters[" + environment.getKey() + "]");
                if (JenkinsResultsParserUtil.isNullOrEmpty(jenkinsMasterNames)) continue;
                for (String jenkinsMasterName : jenkinsMasterNames.split(",")) {
                    if (!jenkinsMasterName.equals(this._jenkinsMaster.getName())) continue;
                    return environment;
                }
            }
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
        return Jethr0Client.Environment.DEVELOPMENT;
    }

    private String _getOAuthAccessToken() {
        if (this._oAuthAccessToken != null) {
            return this._oAuthAccessToken;
        }
        try {
            JSONObject jsonObject = JenkinsResultsParserUtil.toJSONObject(JenkinsResultsParserUtil.combine(String.valueOf(this.getLiferayDXPURL()), "/o/oauth2/token?client_id=", this._getOAuthClientId(), "&client_secret=", this.getOAuthClientSecret(), "&grant_type=client_credentials"), false, JenkinsResultsParserUtil.HttpRequestMethod.POST);
            this._oAuthAccessToken = jsonObject.getString("access_token");
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
        return this._oAuthAccessToken;
    }

    private String _getOAuthClientId() {
        if (this._oAuthClientId != null) {
            return this._oAuthClientId;
        }
        try {
            JSONObject jsonObject = JenkinsResultsParserUtil.toJSONObject(JenkinsResultsParserUtil.combine(String.valueOf(this.getLiferayDXPURL()), "/o/oauth2/application?externalReferenceCode=", this.getOAuthExternalReferenceCode()));
            this._oAuthClientId = jsonObject.getString("client_id");
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
        return this._oAuthClientId;
    }

    private JenkinsResultsParserUtil.HTTPAuthorization _getSpringBootHTTPAuthorization() {
        return new JenkinsResultsParserUtil.BearerHTTPAuthorization(this._getOAuthAccessToken());
    }

    private String _requestLiferayDXPMessage(String urlPath, String message, JenkinsResultsParserUtil.HttpRequestMethod httpRequestMethod) {
        try {
            return JenkinsResultsParserUtil.toString(this.getLiferayDXPURL() + "/" + urlPath, false, httpRequestMethod, message, this._getSpringBootHTTPAuthorization());
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
    }

    private String _requestSpringBootMessage(String urlPath, String message, JenkinsResultsParserUtil.HttpRequestMethod httpRequestMethod) {
        try {
            return JenkinsResultsParserUtil.toString(this.getSpringBootURL() + "/" + urlPath, false, httpRequestMethod, message, this._getSpringBootHTTPAuthorization());
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
    }
}

