/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser.jethr0;

import com.liferay.jenkins.results.parser.JenkinsMaster;
import com.liferay.jenkins.results.parser.SecretsUtil;
import com.liferay.jenkins.results.parser.jethr0.BaseJethr0Client;
import java.net.MalformedURLException;
import java.net.URL;

public class CIJethr0Client
extends BaseJethr0Client {
    private String _1PasswordItemTitle;
    private String _1PasswordVaultName;
    private final String _jmsBrokerURL = this._getSecretString("jms.broker.url");
    private final String _jmsGitHubToJethr0QueueName = this._getSecretString("jms.github.jethr0.queue.name");
    private final String _jmsJethr0ToJRPQueueName = this._getSecretString("jms.jethr0.jrp.queue.name");
    private final String _jmsJRPToJethr0QueueName = this._getSecretString("jms.jrp.jethr0.queue.name");
    private final String _jmsUserName = this._getSecretString("jms.user.name");
    private final String _jmsUserPassword = this._getSecretString("jms.user.password");
    private final URL _liferayDXPURL = this._getSecretURL("liferay.dxp.url");
    private final String _oAuthClientSecret;
    private final String _oAuthExternalReferenceCode = this._getSecretString("liferay.oauth.external.reference.code");
    private final URL _springBootURL;

    @Override
    public String getJMSBrokerURL() {
        return this._jmsBrokerURL;
    }

    protected CIJethr0Client(JenkinsMaster jenkinsMaster) {
        super(jenkinsMaster);
        this._oAuthClientSecret = this._getSecretString("liferay.oauth.client.secret");
        this._springBootURL = this._getSecretURL("jethr0.spring.boot.url");
        this.connect();
    }

    @Override
    protected String getJMSGitHubToJethr0QueueName() {
        return this._jmsGitHubToJethr0QueueName;
    }

    @Override
    protected String getJMSJethr0ToJRPQueueName() {
        return this._jmsJethr0ToJRPQueueName;
    }

    @Override
    protected String getJMSJRPToJethr0QueueName() {
        return this._jmsJRPToJethr0QueueName;
    }

    @Override
    protected String getJMSUserName() {
        return this._jmsUserName;
    }

    @Override
    protected String getJMSUserPassword() {
        return this._jmsUserPassword;
    }

    @Override
    protected URL getLiferayDXPURL() {
        return this._liferayDXPURL;
    }

    @Override
    protected String getOAuthClientSecret() {
        return this._oAuthClientSecret;
    }

    @Override
    protected String getOAuthExternalReferenceCode() {
        return this._oAuthExternalReferenceCode;
    }

    @Override
    protected URL getSpringBootURL() {
        return this._springBootURL;
    }

    private String _get1PasswordItemTitle() {
        if (this._1PasswordItemTitle != null) {
            return this._1PasswordItemTitle;
        }
        this._1PasswordItemTitle = this.getBuildPropertyString("jethr0.1password.item.title");
        return this._1PasswordItemTitle;
    }

    private String _get1PasswordVaultName() {
        if (this._1PasswordVaultName != null) {
            return this._1PasswordVaultName;
        }
        this._1PasswordVaultName = this.getBuildPropertyString("jethr0.1password.vault.name");
        return this._1PasswordVaultName;
    }

    private String _getSecretString(String fieldLabel) {
        return SecretsUtil.getSecret(this._get1PasswordVaultName(), this._get1PasswordItemTitle(), fieldLabel);
    }

    private URL _getSecretURL(String fieldLabel) {
        try {
            return new URL(SecretsUtil.getSecret(this._get1PasswordVaultName(), this._get1PasswordItemTitle(), fieldLabel));
        }
        catch (MalformedURLException malformedURLException) {
            throw new RuntimeException(malformedURLException);
        }
    }
}

