/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser.jethr0;

import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.Jethr0BuildUpdater;
import com.liferay.jenkins.results.parser.jethr0.Jethr0Client;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import org.json.JSONException;

public class Jethr0MessageListener
implements MessageListener {
    private static final Map<Long, Jethr0MessageListener> _jethr0MessageOperators = new HashMap<Long, Jethr0MessageListener>();
    private final Set<Jethr0BuildUpdater> _jethr0BuildUpdaters = new HashSet<Jethr0BuildUpdater>();
    private final Jethr0Client _jethr0Client;
    private final long _jethr0JobId;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Jethr0MessageListener getInstance(Jethr0Client jethr0Client, long jethr0JobId) {
        Map<Long, Jethr0MessageListener> map = _jethr0MessageOperators;
        synchronized (map) {
            Jethr0MessageListener jethr0MessageListener = _jethr0MessageOperators.get(jethr0JobId);
            if (jethr0MessageListener == null) {
                _jethr0MessageOperators.put(jethr0JobId, new Jethr0MessageListener(jethr0Client, jethr0JobId));
            }
            return _jethr0MessageOperators.get(jethr0JobId);
        }
    }

    public void onMessage(Message message) {
        for (Jethr0BuildUpdater jethr0BuildUpdater : this._jethr0BuildUpdaters) {
            try {
                jethr0BuildUpdater.processMessage(message);
            }
            catch (JMSException | JSONException exception) {
                throw new RuntimeException(exception);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void subscribe(Jethr0BuildUpdater jethr0BuildUpdater) throws JMSException {
        Set<Jethr0BuildUpdater> set = this._jethr0BuildUpdaters;
        synchronized (set) {
            if (this._jethr0BuildUpdaters.isEmpty()) {
                this._jethr0Client.subscribe(this, this._getMessageSelector());
            }
            this._jethr0BuildUpdaters.add(jethr0BuildUpdater);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unsubscribe(Jethr0BuildUpdater jethr0BuildUpdater) throws JMSException {
        Set<Jethr0BuildUpdater> set = this._jethr0BuildUpdaters;
        synchronized (set) {
            this._jethr0BuildUpdaters.remove(jethr0BuildUpdater);
            if (this._jethr0BuildUpdaters.isEmpty()) {
                this._jethr0Client.unsubscribe(this, this._getMessageSelector());
            }
        }
    }

    protected Jethr0MessageListener(Jethr0Client jethr0Client, long jethr0JobId) {
        this._jethr0Client = jethr0Client;
        this._jethr0JobId = jethr0JobId;
    }

    private String _getMessageSelector() {
        return JenkinsResultsParserUtil.combine("(jethr0JobId = '", String.valueOf(this._jethr0JobId), "')");
    }
}

