/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser.job.property;

import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.Job;
import com.liferay.jenkins.results.parser.TestSuiteJob;
import com.liferay.jenkins.results.parser.job.property.JobProperty;
import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Properties;

public abstract class BaseJobProperty
implements JobProperty {
    private final String _basePropertyName;
    private final Job _job;
    private String _name;
    private File _propertiesFile;
    private boolean _readJobProperties;
    private final String _ruleName;
    private final String _testBatchName;
    private final String _testSuiteName;
    private final JobProperty.Type _type;
    private final boolean _useBasePropertyName;
    private String _value;

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof JobProperty)) {
            return false;
        }
        return Objects.equals(object.toString(), this.toString());
    }

    @Override
    public String getBasePropertyName() {
        return this._basePropertyName;
    }

    @Override
    public Job getJob() {
        return this._job;
    }

    @Override
    public String getName() {
        if (!this._readJobProperties) {
            this.readProperties();
        }
        return this._name;
    }

    @Override
    public String getPropertiesFilePath() {
        if (!this._readJobProperties) {
            this.readProperties();
        }
        if (this._propertiesFile == null) {
            return "CI Properties";
        }
        File workingDirectory = BaseJobProperty.getWorkingDirectory(this._propertiesFile);
        return JenkinsResultsParserUtil.getPathRelativeTo(this._propertiesFile, workingDirectory.getParentFile());
    }

    @Override
    public JobProperty.Type getType() {
        return this._type;
    }

    @Override
    public String getValue() {
        if (!this._readJobProperties) {
            this.readProperties();
        }
        return this._value;
    }

    public int hashCode() {
        String string = this.toString();
        return string.hashCode();
    }

    public String toString() {
        if (!JenkinsResultsParserUtil.isNullOrEmpty(this._ruleName)) {
            return JenkinsResultsParserUtil.join("_", this._job.getJobName(), this._basePropertyName, String.valueOf((Object)this._type), String.valueOf(this._useBasePropertyName), this._testSuiteName, this._testBatchName, this._ruleName);
        }
        return JenkinsResultsParserUtil.join("_", this._job.getJobName(), this._basePropertyName, String.valueOf((Object)this._type), String.valueOf(this._useBasePropertyName), this._testSuiteName, this._testBatchName);
    }

    protected static File getWorkingDirectory(File file) {
        if (file == null) {
            return null;
        }
        File canonicalFile = JenkinsResultsParserUtil.getCanonicalFile(file);
        File parentFile = canonicalFile.getParentFile();
        if (parentFile == null || !parentFile.exists()) {
            return file;
        }
        if (!canonicalFile.isDirectory()) {
            return BaseJobProperty.getWorkingDirectory(parentFile);
        }
        File gitDir = new File(canonicalFile, ".git");
        if (!gitDir.exists()) {
            return BaseJobProperty.getWorkingDirectory(parentFile);
        }
        return canonicalFile;
    }

    protected BaseJobProperty(Job job, JobProperty.Type type, String basePropertyName, boolean useBasePropertyName, String testSuiteName, String testBatchName) {
        this._job = job;
        this._type = type;
        this._basePropertyName = basePropertyName;
        this._useBasePropertyName = useBasePropertyName;
        if (testSuiteName == null && job instanceof TestSuiteJob) {
            TestSuiteJob testSuiteJob = (TestSuiteJob)job;
            testSuiteName = testSuiteJob.getTestSuiteName();
        }
        this._testSuiteName = testSuiteName;
        this._testBatchName = testBatchName;
        this._ruleName = null;
    }

    protected BaseJobProperty(Job job, JobProperty.Type type, String basePropertyName, boolean useBasePropertyName, String testSuiteName, String testBatchName, String ruleName) {
        this._job = job;
        this._type = type;
        this._basePropertyName = basePropertyName;
        this._useBasePropertyName = useBasePropertyName;
        if (testSuiteName == null && job instanceof TestSuiteJob) {
            TestSuiteJob testSuiteJob = (TestSuiteJob)job;
            testSuiteName = testSuiteJob.getTestSuiteName();
        }
        this._testSuiteName = testSuiteName;
        this._testBatchName = testBatchName;
        this._ruleName = ruleName;
    }

    protected List<File> getJobPropertiesFiles() {
        return this._job.getJobPropertiesFiles();
    }

    protected void readProperties() {
        for (File jobPropertiesFile : this.getJobPropertiesFiles()) {
            String value;
            Properties jobProperties = JenkinsResultsParserUtil.getProperties(jobPropertiesFile);
            String name = JenkinsResultsParserUtil.getPropertyName(jobProperties, this._useBasePropertyName, this._basePropertyName, this._getJobPropertyOptions());
            if (JenkinsResultsParserUtil.isNullOrEmpty(name) || (value = JenkinsResultsParserUtil.getProperty(jobProperties, name)) == null) continue;
            this._name = name;
            this._value = value;
            this._propertiesFile = jobPropertiesFile;
            this._readJobProperties = true;
            return;
        }
        Properties jenkinsBuildProperties = JenkinsResultsParserUtil.getJenkinsBuildProperties();
        String name = JenkinsResultsParserUtil.getPropertyName(jenkinsBuildProperties, this._useBasePropertyName, this._basePropertyName, this._getJobPropertyOptions());
        if (JenkinsResultsParserUtil.isNullOrEmpty(name)) {
            this._readJobProperties = true;
            return;
        }
        String value = JenkinsResultsParserUtil.getProperty(jenkinsBuildProperties, name);
        if (value == null) {
            this._readJobProperties = true;
            return;
        }
        this._name = name;
        this._value = value;
        this._propertiesFile = null;
        this._readJobProperties = true;
    }

    private String[] _getJobPropertyOptions() {
        Job job = this.getJob();
        List<String> jobPropertyOptions = job.getJobPropertyOptions();
        jobPropertyOptions.add(this._testSuiteName);
        jobPropertyOptions.add(this._testBatchName);
        if (!JenkinsResultsParserUtil.isNullOrEmpty(this._ruleName)) {
            jobPropertyOptions.add(this._ruleName);
        }
        jobPropertyOptions.removeAll(Collections.singleton(null));
        return jobPropertyOptions.toArray(new String[0]);
    }
}

