/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser.metrics;

import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.metrics.BuildJSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import org.json.JSONArray;
import org.json.JSONObject;

public class BuildHistory {
    private static final long _TIMELINE_SAMPLE_PERIOD_MINUTES = 15L;
    private final Map<String, Long> _dailyInvokedBuilds = new TreeMap<String, Long>();
    private final Map<String, Long> _dailyInvokedTopLevelBuilds = new TreeMap<String, Long>();
    private final Map<String, Long> _dailyTotalBuildDurations = new TreeMap<String, Long>();
    private final Map<String, Long> _dailyTotalTopLevelBuildDurations = new TreeMap<String, Long>();
    private final Map<String, Long> _dailyTotalTopLevelQueueTime = new TreeMap<String, Long>();
    private long _duration;
    private final String _name;
    private long _startTime;
    private Table _table;
    private Timeline _timeline;
    private final Set<String> _topLevelBuildURLs = new HashSet<String>();

    public BuildHistory(long duration, String name, long startTime) {
        this._duration = duration;
        this._name = name;
        this._startTime = startTime;
    }

    public void addBuildJSONObject(BuildJSONObject buildJSONObject) {
        this._addData(buildJSONObject);
        Timeline timeline = this._getTimeline();
        timeline.addData(buildJSONObject);
    }

    public void addBuildJSONObjects(Collection<BuildJSONObject> buildJSONObjects) {
        for (BuildJSONObject buildJSONObject : buildJSONObjects) {
            this.addBuildJSONObject(buildJSONObject);
        }
    }

    public boolean containsTopLevelBuildURL(String url) {
        return this._topLevelBuildURLs.contains(url);
    }

    public Map<String, Long> getDailyInvokedBuilds() {
        return this._dailyInvokedBuilds;
    }

    public Map<String, Long> getDailyInvokedTopLevelBuilds() {
        return this._dailyInvokedTopLevelBuilds;
    }

    public Map<String, Long> getDailyTotalBuildDurations() {
        return this._dailyTotalBuildDurations;
    }

    public Map<String, Long> getDailyTotalQueueTime() {
        return this._dailyTotalTopLevelQueueTime;
    }

    public Map<String, Long> getDailyTotalTopLevelBuildDurations() {
        return this._dailyTotalTopLevelBuildDurations;
    }

    public long getDuration() {
        return this._duration;
    }

    public long getInvokedBuildCount() {
        long totalInvokedBuildCount = 0L;
        for (Long invokedBuildCount : this._dailyInvokedBuilds.values()) {
            totalInvokedBuildCount += invokedBuildCount.longValue();
        }
        return totalInvokedBuildCount;
    }

    public String getName() {
        return this._name;
    }

    public long getStartTime() {
        return this._startTime;
    }

    public JSONArray getTableJSONArray(String groupIdentifierName, int intervalDays) {
        Table table = this._getTable(groupIdentifierName);
        return table.getJSONArray(intervalDays);
    }

    public JSONObject getTimelineJSONObject() {
        Timeline timeline = this._getTimeline();
        return timeline.getJSONObject();
    }

    public Set<String> getTopLevelBuildURLs() {
        return this._topLevelBuildURLs;
    }

    public void merge(BuildHistory buildHistory) {
        this._mergeMap(this._dailyInvokedBuilds, buildHistory.getDailyInvokedBuilds());
        this._mergeMap(this._dailyInvokedTopLevelBuilds, buildHistory.getDailyInvokedTopLevelBuilds());
        this._mergeMap(this._dailyTotalBuildDurations, buildHistory.getDailyTotalBuildDurations());
        this._mergeMap(this._dailyTotalTopLevelBuildDurations, buildHistory.getDailyTotalTopLevelBuildDurations());
        this._mergeMap(this._dailyTotalTopLevelQueueTime, buildHistory.getDailyTotalQueueTime());
        if (buildHistory.getDuration() > this._duration) {
            this.setDuration(buildHistory.getDuration());
        }
        if (buildHistory.getStartTime() < this._startTime) {
            this.setStartTime(buildHistory.getStartTime());
        }
        this._topLevelBuildURLs.addAll(buildHistory.getTopLevelBuildURLs());
    }

    public void setDuration(long duration) {
        this._duration = duration;
    }

    public void setStartTime(long startTime) {
        this._startTime = startTime;
    }

    protected static JSONArray getTimeJSONArray(long duration, long startTime) {
        int size = BuildHistory._getTimelineSize(duration);
        long[] timeMillis = new long[size];
        for (int i = 0; i < timeMillis.length; ++i) {
            timeMillis[i] = i == 0 ? startTime : timeMillis[i - 1] + duration / (long)size;
        }
        return new JSONArray((Object)timeMillis);
    }

    private static int _getTimelineSize(long duration) {
        return (int)(duration / TimeUnit.MINUTES.toMillis(15L));
    }

    private void _addData(BuildJSONObject buildJSONObject) {
        String dateString = buildJSONObject.getStartDateString();
        this._addData(this._dailyInvokedBuilds, dateString, 1L);
        this._addData(this._dailyTotalBuildDurations, dateString, buildJSONObject.getDuration());
        if (buildJSONObject.isTopLevelBuild()) {
            this._topLevelBuildURLs.add(buildJSONObject.getURL());
            this._addData(this._dailyInvokedTopLevelBuilds, dateString, 1L);
            this._addData(this._dailyTotalTopLevelBuildDurations, dateString, buildJSONObject.getDuration());
            this._addData(this._dailyTotalTopLevelQueueTime, dateString, buildJSONObject.getQueueDuration());
        }
    }

    private void _addData(Map<String, Long> dataMap, String key, Long value) {
        if (!dataMap.containsKey(key)) {
            dataMap.put(key, value);
            return;
        }
        dataMap.put(key, dataMap.get(key) + value);
    }

    private Long _getQuotient(Long value1, Long value2) {
        if (value1 == 0L) {
            return value1;
        }
        return value1 / value2;
    }

    private Table _getTable(String firstColumnHeader) {
        if (this._table == null) {
            this._table = new Table(firstColumnHeader);
        }
        return this._table;
    }

    private Timeline _getTimeline() {
        if (this._timeline == null) {
            this._timeline = new Timeline();
        }
        return this._timeline;
    }

    private Long _getTotalValue(Map<String, Long> dailyValueMap, String ... dateStrings) {
        long totalValue = 0L;
        for (String dateString : dateStrings) {
            if (!dailyValueMap.containsKey(dateString)) continue;
            totalValue += dailyValueMap.get(dateString).longValue();
        }
        return totalValue;
    }

    private void _mergeMap(Map<String, Long> dataMap1, Map<String, Long> dataMap2) {
        for (Map.Entry<String, Long> entry : dataMap2.entrySet()) {
            String key;
            Long currentValue = dataMap1.get(key = entry.getKey());
            dataMap1.put(key, currentValue == null ? entry.getValue() : Long.valueOf(entry.getValue() + currentValue));
        }
    }

    private String[][] _split(String[] array, int size) {
        int count = (int)Math.ceil((double)array.length / (double)size);
        String[][] arrays = new String[count][];
        for (int i = 0; i < count; ++i) {
            int start = i * size;
            int length = Math.min(array.length - start, size);
            String[] curArray = new String[length];
            System.arraycopy(array, start, curArray, 0, length);
            arrays[i] = curArray;
        }
        return arrays;
    }

    protected class Timeline {
        private final long[] _averageBuildTime;
        private final long[] _averageQueueTime;
        private final long[] _buildCounts;
        private final long[] _buildCountsForAverage;
        private final int _size;
        private final long[] _topLevelBuildCounts;
        private final long[] _totalBuildTime;
        private final long[] _totalQueueTime;

        public void addData(BuildJSONObject buildJSONObject) {
            long buildStartTime = buildJSONObject.getStartTime();
            int startIndex = this._getIndex(buildStartTime);
            long buildDuration = buildJSONObject.getDuration();
            long relativeStartTime = buildStartTime - BuildHistory.this._startTime;
            long relativeEndTime = relativeStartTime + buildDuration;
            long timelineSamplePeriodMillis = TimeUnit.MINUTES.toMillis(15L);
            if (relativeStartTime > (long)(this._size - 1) * timelineSamplePeriodMillis || relativeStartTime > (long)startIndex * timelineSamplePeriodMillis && relativeEndTime < (long)(startIndex + 1) * timelineSamplePeriodMillis) {
                return;
            }
            if (relativeEndTime > (long)startIndex * timelineSamplePeriodMillis) {
                int endIndex = this._getIndex(buildStartTime + buildDuration);
                if (startIndex < this._size - 1) {
                    ++startIndex;
                }
                for (int i = startIndex; i <= endIndex; ++i) {
                    int n = i;
                    this._buildCounts[n] = this._buildCounts[n] + 1L;
                    if (!BuildHistory.this.containsTopLevelBuildURL(buildJSONObject.getURL())) continue;
                    int n2 = i;
                    this._topLevelBuildCounts[n2] = this._topLevelBuildCounts[n2] + 1L;
                }
                int n = startIndex;
                this._totalBuildTime[n] = this._totalBuildTime[n] + buildDuration;
                long queueDuration = buildJSONObject.getQueueDuration();
                int n3 = startIndex;
                this._totalQueueTime[n3] = this._totalQueueTime[n3] + queueDuration;
                int n4 = startIndex;
                this._buildCountsForAverage[n4] = this._buildCountsForAverage[n4] + 1L;
            }
        }

        public JSONObject getJSONObject() {
            this._calculateAverages();
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("averageBuildTime", (Object)new JSONArray((Object)this._averageBuildTime)).put("averageQueueTime", (Object)new JSONArray((Object)this._averageQueueTime)).put("buildCounts", (Object)new JSONArray((Object)this._buildCounts)).put("name", (Object)BuildHistory.this._name).put("topLevelBuildCounts", (Object)new JSONArray((Object)this._topLevelBuildCounts));
            return jsonObject;
        }

        protected Timeline() {
            this._size = BuildHistory._getTimelineSize(BuildHistory.this._duration);
            this._averageBuildTime = new long[this._size];
            this._averageQueueTime = new long[this._size];
            this._buildCounts = new long[this._size];
            this._buildCountsForAverage = new long[this._size];
            this._topLevelBuildCounts = new long[this._size];
            this._totalBuildTime = new long[this._size];
            this._totalQueueTime = new long[this._size];
        }

        private void _calculateAverages() {
            for (int i = 0; i < this._size; ++i) {
                if (this._buildCountsForAverage[i] == 0L) {
                    this._averageBuildTime[i] = 0L;
                    this._averageQueueTime[i] = 0L;
                    continue;
                }
                this._averageBuildTime[i] = this._totalBuildTime[i] / this._buildCountsForAverage[i];
                this._averageQueueTime[i] = this._totalQueueTime[i] / this._buildCountsForAverage[i];
            }
        }

        private int _getIndex(long timeMillis) {
            int index = (int)((timeMillis - BuildHistory.this._startTime) * (long)this._size / BuildHistory.this._duration);
            if (index >= this._size) {
                return this._size - 1;
            }
            if (index < 0) {
                return 0;
            }
            return index;
        }
    }

    protected class Table {
        private final String _groupIdentifierName;

        public JSONArray getJSONArray(int intervalDays) {
            JSONArray jsonArray = new JSONArray();
            String[][] dateStringsArray = BuildHistory.this._split(JenkinsResultsParserUtil.getDateStrings(BuildHistory.this.getStartTime(), BuildHistory.this.getDuration()), intervalDays);
            final String[] dateStrings = new String[dateStringsArray.length];
            final Long[] averageTopLevelBuildDurations = new Long[dateStringsArray.length];
            final Long[] invokedBuilds = new Long[dateStringsArray.length];
            final Long[] invokedTopLevelBuilds = new Long[dateStringsArray.length];
            final Long[] totalServerDurations = new Long[dateStringsArray.length];
            for (int i = 0; i < dateStringsArray.length; ++i) {
                dateStrings[i] = dateStringsArray[i][0];
                invokedBuilds[i] = BuildHistory.this._getTotalValue(BuildHistory.this._dailyInvokedBuilds, dateStringsArray[i]);
                invokedTopLevelBuilds[i] = BuildHistory.this._getTotalValue(BuildHistory.this._dailyInvokedTopLevelBuilds, dateStringsArray[i]);
                totalServerDurations[i] = BuildHistory.this._getTotalValue(BuildHistory.this._dailyTotalBuildDurations, dateStringsArray[i]);
                long topLevelBuildDuration = BuildHistory.this._getTotalValue(BuildHistory.this._dailyTotalTopLevelBuildDurations, dateStringsArray[i]);
                averageTopLevelBuildDurations[i] = BuildHistory.this._getQuotient(topLevelBuildDuration, invokedTopLevelBuilds[i]);
            }
            ArrayList<ArrayList> rows = new ArrayList<ArrayList>();
            rows.add(new ArrayList<Object>(){
                {
                    this.add(Table.this._groupIdentifierName);
                    this.add("Metric");
                    this.addAll(Arrays.asList(dateStrings));
                }
            });
            rows.add(new ArrayList<Object>(){
                {
                    this.add(BuildHistory.this.getName());
                    this.add("Invoked Builds");
                    this.addAll(Arrays.asList(invokedBuilds));
                }
            });
            rows.add(new ArrayList<Object>(){
                {
                    this.add(BuildHistory.this.getName());
                    this.add("Invoked Top Level Builds");
                    this.addAll(Arrays.asList(invokedTopLevelBuilds));
                }
            });
            rows.add(new ArrayList<Object>(){
                {
                    this.add(BuildHistory.this.getName());
                    this.add("Average Top Level Build Duration");
                    this.addAll(Arrays.asList(averageTopLevelBuildDurations));
                }
            });
            rows.add(new ArrayList<Object>(){
                {
                    this.add(BuildHistory.this.getName());
                    this.add("Total Server Duration");
                    this.addAll(Arrays.asList(totalServerDurations));
                }
            });
            for (List list : rows) {
                jsonArray.put((Object)new JSONArray((Collection)list));
            }
            return jsonArray;
        }

        protected Table(String groupIdentifierName) {
            this._groupIdentifierName = groupIdentifierName;
        }
    }
}

