/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser.metrics;

import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.ParallelExecutor;
import com.liferay.jenkins.results.parser.metrics.BuildHistory;
import com.liferay.jenkins.results.parser.metrics.BuildJSONObject;
import java.io.File;
import java.io.IOException;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeoutException;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.json.JSONArray;

public class BuildHistoryProcessor {
    private static final File _BASE_DIR;
    private static final Integer _THREAD_COUNT;
    private static final Properties _buildProperties;
    private static final ExecutorService _executorService;

    public static ExecutorService getExecutorService() {
        return _executorService;
    }

    public static BuildHistory mergeBuildHistories(Collection<BuildHistory> buildHistories, String name) {
        return BuildHistoryProcessor._mergeBuildHistories(new ArrayList<BuildHistory>(buildHistories), name);
    }

    public static BuildHistory mergeBuildHistories(String name, BuildHistory ... buildHistories) {
        return BuildHistoryProcessor._mergeBuildHistories(Arrays.asList(buildHistories), name);
    }

    public static Collection<BuildHistory> newAggregateJobHistories(final long duration, final long startTime) {
        BiConsumer<Set<BuildJSONObject>, Map<String, BuildHistory>> biConsumer = new BiConsumer<Set<BuildJSONObject>, Map<String, BuildHistory>>(){

            @Override
            public void accept(Set<BuildJSONObject> buildJSONObjects, Map<String, BuildHistory> buildHistories) {
                BuildHistoryProcessor._addToBuildHistoriesMap(buildJSONObjects, buildHistories, duration, new GroupByCategory(), startTime);
            }
        };
        return BuildHistoryProcessor._getBuildHistories(duration, null, null, biConsumer, startTime);
    }

    public static Collection<BuildHistory> newDefaultJobHistories(final long duration, final long startTime) {
        BiConsumer<Set<BuildJSONObject>, Map<String, BuildHistory>> biConsumer = new BiConsumer<Set<BuildJSONObject>, Map<String, BuildHistory>>(){

            @Override
            public void accept(Set<BuildJSONObject> buildJSONObjects, Map<String, BuildHistory> buildHistories) {
                BuildHistoryProcessor._addToBuildHistoriesMap(buildJSONObjects, buildHistories, duration, new GroupByJobName(), startTime);
            }
        };
        return BuildHistoryProcessor._getBuildHistories(duration, null, null, biConsumer, startTime);
    }

    public static Collection<BuildHistory> newTestSuiteJobHistories(final long duration, Pattern jobNamePattern, final long startTime) {
        final GroupByTopLevelTestSuite groupByTopLevelTestSuite = new GroupByTopLevelTestSuite();
        BiConsumer<Set<BuildJSONObject>, Map<String, BuildHistory>> biConsumer = new BiConsumer<Set<BuildJSONObject>, Map<String, BuildHistory>>(){

            @Override
            public void accept(Set<BuildJSONObject> buildJSONObjects, Map<String, BuildHistory> buildHistories) {
                HashSet<BuildJSONObject> downstreamBuildJSONObjects = new HashSet<BuildJSONObject>();
                HashSet<BuildJSONObject> topLevelBuildJSONObjects = new HashSet<BuildJSONObject>();
                for (BuildJSONObject buildJSONObject : buildJSONObjects) {
                    if (buildJSONObject.isTopLevelBuild()) {
                        topLevelBuildJSONObjects.add(buildJSONObject);
                        continue;
                    }
                    downstreamBuildJSONObjects.add(buildJSONObject);
                }
                BuildHistoryProcessor._addToBuildHistoriesMap(topLevelBuildJSONObjects, buildHistories, duration, groupByTopLevelTestSuite, startTime);
                Map groupedBuildDataJSONObjectsMap = BuildHistoryProcessor._getGroupedBuildDataJSONObjectsMap(downstreamBuildJSONObjects, groupByTopLevelTestSuite);
                for (Map.Entry entry : groupedBuildDataJSONObjectsMap.entrySet()) {
                    BuildHistory buildHistory;
                    String key = (String)entry.getKey();
                    if (!buildHistories.containsKey(key)) {
                        buildHistory = new BuildHistory(duration, key, startTime);
                        buildHistories.put(key, buildHistory);
                    }
                    buildHistory = buildHistories.get(key);
                    buildHistory.addBuildJSONObjects((Collection)groupedBuildDataJSONObjectsMap.get(key));
                }
            }
        };
        return BuildHistoryProcessor._getBuildHistories(duration, null, jobNamePattern, biConsumer, startTime);
    }

    public static Collection<BuildHistory> newUtilizationBuildHistories(final long duration, final long startTime) {
        BiConsumer<Set<BuildJSONObject>, Map<String, BuildHistory>> biConsumer = new BiConsumer<Set<BuildJSONObject>, Map<String, BuildHistory>>(){

            @Override
            public void accept(Set<BuildJSONObject> buildJSONObjects, Map<String, BuildHistory> buildHistories) {
                BuildHistoryProcessor._addToBuildHistoriesMap(buildJSONObjects, buildHistories, duration, new GroupByWeeklyUtilization(), startTime);
            }
        };
        return BuildHistoryProcessor._getBuildHistories(duration, null, null, biConsumer, startTime);
    }

    private static void _addToBuildHistoriesMap(Collection<BuildJSONObject> buildJSONObjects, Map<String, BuildHistory> buildHistoriesMap, long duration, Function<BuildJSONObject, String> groupingFunction, long startTime) {
        Map<String, Set<BuildJSONObject>> groupedBuildDataJSONObjectsMap = BuildHistoryProcessor._getGroupedBuildDataJSONObjectsMap(buildJSONObjects, groupingFunction);
        for (Map.Entry<String, Set<BuildJSONObject>> entry : groupedBuildDataJSONObjectsMap.entrySet()) {
            BuildHistory buildHistory;
            if (!buildHistoriesMap.containsKey(entry.getKey())) {
                buildHistory = new BuildHistory(duration, entry.getKey(), startTime);
                buildHistoriesMap.put(entry.getKey(), buildHistory);
            }
            buildHistory = buildHistoriesMap.get(entry.getKey());
            buildHistory.addBuildJSONObjects((Collection<BuildJSONObject>)entry.getValue());
        }
    }

    private static Collection<BuildHistory> _getBuildHistories(long duration, Pattern jobNameExcludesPattern, Pattern jobNameIncludesPattern, BiConsumer<Set<BuildJSONObject>, Map<String, BuildHistory>> buildHistoryBiConsumer, long startTime) {
        HashMap buildHistoriesMap = new HashMap();
        for (String dateString : JenkinsResultsParserUtil.getDateStrings(startTime, duration)) {
            HashSet<BuildJSONObject> buildJSONObjects = new HashSet<BuildJSONObject>();
            for (BuildJSONObject buildJSONObject : BuildHistoryProcessor._getBuildJSONObjects(dateString)) {
                Matcher jobNameExcludesMatcher;
                if (jobNameExcludesPattern != null && (jobNameExcludesMatcher = jobNameExcludesPattern.matcher(buildJSONObject.getJobName())).matches()) continue;
                if (jobNameIncludesPattern == null) {
                    buildJSONObjects.add(buildJSONObject);
                    continue;
                }
                Matcher jobNameIncludesMatcher = jobNameIncludesPattern.matcher(buildJSONObject.getJobName());
                if (!jobNameIncludesMatcher.matches()) continue;
                buildJSONObjects.add(buildJSONObject);
            }
            buildHistoryBiConsumer.accept(buildJSONObjects, buildHistoriesMap);
        }
        return BuildHistoryProcessor._getSortedBuildHistories(buildHistoriesMap.values());
    }

    private static Set<BuildJSONObject> _getBuildJSONObjects(String dateString) {
        File dateDir = new File(_BASE_DIR, dateString);
        if (dateDir.listFiles() == null) {
            return Collections.emptySet();
        }
        final Set<BuildJSONObject> buildJSONObjects = Collections.synchronizedSet(new HashSet());
        System.out.println("Reading files from: " + dateDir.toPath());
        ArrayList callables = new ArrayList();
        for (final File jsonFile : dateDir.listFiles()) {
            callables.add(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    try {
                        String jsonFileName = jsonFile.getCanonicalPath();
                        if (jsonFileName.contains("test-1-0") || jsonFileName.contains("test-1-41")) {
                            return null;
                        }
                        String content = JenkinsResultsParserUtil.read(jsonFile);
                        JSONArray jsonArray = new JSONArray(content.trim());
                        HashSet<BuildJSONObject> newBuildJSONObjects = new HashSet<BuildJSONObject>();
                        for (int i = 0; i < jsonArray.length(); ++i) {
                            newBuildJSONObjects.add(new BuildJSONObject(jsonArray.getJSONObject(i)));
                        }
                        buildJSONObjects.addAll(newBuildJSONObjects);
                    }
                    catch (IOException ioException) {
                        System.out.println("Unable to read " + jsonFile);
                    }
                    return null;
                }
            });
        }
        ParallelExecutor parallelExecutor = new ParallelExecutor(callables, _executorService, "_getBuildJSONObjects");
        try {
            parallelExecutor.execute();
        }
        catch (TimeoutException timeoutException) {
            throw new RuntimeException(timeoutException);
        }
        return buildJSONObjects;
    }

    private static Map<String, Set<BuildJSONObject>> _getGroupedBuildDataJSONObjectsMap(Collection<BuildJSONObject> buildJSONObjects, Function<BuildJSONObject, String> groupingFunction) {
        HashMap<String, Set<BuildJSONObject>> groupedBuildDataJSONObjectsMap = new HashMap<String, Set<BuildJSONObject>>();
        for (BuildJSONObject buildJSONObject : buildJSONObjects) {
            String groupName = groupingFunction.apply(buildJSONObject);
            if (!groupedBuildDataJSONObjectsMap.containsKey(groupName)) {
                groupedBuildDataJSONObjectsMap.put(groupName, new HashSet());
            }
            Set groupedBuildJSONObjects = (Set)groupedBuildDataJSONObjectsMap.get(groupName);
            groupedBuildJSONObjects.add(buildJSONObject);
        }
        return groupedBuildDataJSONObjectsMap;
    }

    private static List<BuildHistory> _getSortedBuildHistories(Collection<BuildHistory> buildHistories) {
        ArrayList<BuildHistory> buildHistoryList = new ArrayList<BuildHistory>(buildHistories);
        Collections.sort(buildHistoryList, new Comparator<BuildHistory>(){

            @Override
            public int compare(BuildHistory buildHistory1, BuildHistory buildHistory2) {
                Integer buildCount1 = (int)buildHistory1.getInvokedBuildCount();
                Integer buildCount2 = (int)buildHistory2.getInvokedBuildCount();
                return buildCount2.compareTo(buildCount1);
            }
        });
        return buildHistoryList;
    }

    private static BuildHistory _mergeBuildHistories(List<BuildHistory> buildHistories, String name) {
        BuildHistory mergedBuildHistory = new BuildHistory(0L, name, System.currentTimeMillis());
        for (BuildHistory buildHistory : buildHistories) {
            mergedBuildHistory.merge(buildHistory);
        }
        return mergedBuildHistory;
    }

    static {
        _THREAD_COUNT = 8;
        _executorService = JenkinsResultsParserUtil.getNewThreadPoolExecutor(_THREAD_COUNT, true);
        _buildProperties = new Properties(){
            {
                try {
                    this.putAll((Map<?, ?>)JenkinsResultsParserUtil.getBuildProperties());
                }
                catch (IOException ioException) {
                    throw new RuntimeException(ioException);
                }
            }
        };
        _BASE_DIR = new File(_buildProperties.getProperty("archive.ci.build.data.tmp.dir"), "builds");
    }

    private static class GroupByWeeklyUtilization
    implements Function<BuildJSONObject, String> {
        private GroupByWeeklyUtilization() {
        }

        @Override
        public String apply(BuildJSONObject buildJSONObject) {
            String jobName = buildJSONObject.getJobName();
            LocalDate localDate = LocalDate.parse(buildJSONObject.getStartDateString(), DateTimeFormatter.ofPattern("yyyyMMdd"));
            DayOfWeek dayOfWeek = localDate.getDayOfWeek();
            boolean weekday = false;
            if (dayOfWeek.getValue() <= 5) {
                weekday = true;
            }
            if (jobName.contains("test-portal-acceptance-pullrequest")) {
                if (weekday) {
                    return Category.PORTAL_PULLREQUEST_WEEKDAYS.toString();
                }
                return Category.PORTAL_PULLREQUEST_WEEKENDS.toString();
            }
            if (jobName.contains("release") || jobName.contains("upstream")) {
                if (weekday) {
                    return Category.PORTAL_RELEASE_AND_UPSTREAM_WEEKDAYS.toString();
                }
                return Category.PORTAL_RELEASE_AND_UPSTREAM_WEEKENDS.toString();
            }
            if (weekday) {
                return Category.OTHER_WEEKDAYS.toString();
            }
            return Category.OTHER_WEEKENDS.toString();
        }

        private static enum Category {
            OTHER_WEEKDAYS("Other (Weekdays)"),
            OTHER_WEEKENDS("Other (Weekends)"),
            PORTAL_PULLREQUEST_WEEKDAYS("Portal Pull Requests (Weekdays)"),
            PORTAL_PULLREQUEST_WEEKENDS("Portal Pull Requests (Weekends)"),
            PORTAL_RELEASE_AND_UPSTREAM_WEEKDAYS("Portal Release & Upstream (Weekdays)"),
            PORTAL_RELEASE_AND_UPSTREAM_WEEKENDS("Portal Release & Upstream (Weekends)");

            private final String _string;

            public String toString() {
                return this._string;
            }

            private Category(String string2) {
                this._string = string2;
            }
        }
    }

    private static class GroupByTopLevelTestSuite
    implements Function<BuildJSONObject, String> {
        private final Map<String, String> _topLevelBuildTestSuiteMap = new HashMap<String, String>();

        private GroupByTopLevelTestSuite() {
        }

        @Override
        public String apply(BuildJSONObject buildJSONObject) {
            String jobName = buildJSONObject.getJobName();
            if (jobName.contains("acceptance-upstream-dxp")) {
                return "acceptance-dxp";
            }
            if (buildJSONObject.isTopLevelBuild()) {
                Map<String, String> parameters = buildJSONObject.getParameters();
                if (parameters.containsKey("CI_TEST_SUITE")) {
                    this._topLevelBuildTestSuiteMap.put(buildJSONObject.getURL(), parameters.get("CI_TEST_SUITE"));
                    return parameters.get("CI_TEST_SUITE");
                }
                return "[Unknown]";
            }
            String topLevelBuildURL = buildJSONObject.getTopLevelBuildURL();
            if (this._topLevelBuildTestSuiteMap.containsKey(topLevelBuildURL)) {
                return this._topLevelBuildTestSuiteMap.get(topLevelBuildURL);
            }
            return "[Unknown]";
        }
    }

    private static class GroupByJobName
    implements Function<BuildJSONObject, String> {
        private GroupByJobName() {
        }

        @Override
        public String apply(BuildJSONObject buildJSONObject) {
            String jobName = buildJSONObject.getJobName();
            String name = jobName.replace("-batch", "");
            name = name.replace("-downstream", "");
            name = name.replace("-validation", "");
            return name;
        }
    }

    private static class GroupByCategory
    implements Function<BuildJSONObject, String> {
        private GroupByCategory() {
        }

        @Override
        public String apply(BuildJSONObject buildJSONObject) {
            String jobName = buildJSONObject.getJobName();
            jobName = jobName.replace("-batch", "");
            jobName = jobName.replace("-downstream", "");
            if ((jobName = jobName.replace("-validation", "")).contains("maintenance-") || jobName.contains("mirrors-") || jobName.contains("verification-")) {
                return Category.MAINTENANCE.toString();
            }
            if (jobName.equals("test-portal-acceptance-pullrequest(master)")) {
                return Category.PORTAL_MASTER_PULLREQUEST.toString();
            }
            if (jobName.equals("test-portal-acceptance-upstream(master)") || jobName.equals("test-portal-acceptance-upstream-dxp(master)") || jobName.equals("test-portal-testsuite-upstream(master)")) {
                return Category.PORTAL_MASTER_UPSTREAM.toString();
            }
            if (jobName.equals("test-portal-fixpack-release") || jobName.equals("test-portal-hotfix-release") || jobName.equals("test-portal-release")) {
                return Category.PORTAL_RELEASE.toString();
            }
            if (jobName.contains("test-portal-")) {
                return Category.PORTAL_OTHER.toString();
            }
            return Category.OTHER.toString();
        }

        private static enum Category {
            MAINTENANCE("CI Maintenance"),
            OTHER("Other"),
            PORTAL_MASTER_PULLREQUEST("liferay-portal/master PR's"),
            PORTAL_MASTER_UPSTREAM("liferay-portal/master Upstream"),
            PORTAL_OTHER("liferay-portal-ee PR's & Upstream"),
            PORTAL_OTHER_RELEASE("Portal Fixpack & Hotfix Release"),
            PORTAL_RELEASE("Portal Release");

            private final String _string;

            public String toString() {
                return this._string;
            }

            private Category(String string2) {
                this._string = string2;
            }
        }
    }
}

