/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser.metrics;

import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.metrics.BuildHistory;
import com.liferay.jenkins.results.parser.metrics.BuildHistoryProcessor;
import java.io.File;
import java.io.IOException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.json.JSONArray;
import org.json.JSONObject;

public class BuildHistoryReport {
    private static final Pattern _portalMasterPullRequestJobNamePattern = Pattern.compile("test-portal-acceptance-pullrequest(|-downstream)\\(master\\)");
    private static final Pattern _portalMasterUpstreamJobNamePattern = Pattern.compile("test-portal-(acceptance-upstream-dxp|testsuite-upstream)(|-downstream)\\(master\\)");
    private static final Pattern _portalReleaseJobNamePattern = Pattern.compile("test-portal(|-fixpack|-hotfix)-release(|-downstream)");
    private final Map<File, String> _fileMap = new HashMap<File, String>();
    private final File _outputDir;

    public static BuildHistoryReport newAggregateReport(long durationDays, File outputDir, String startDateString) {
        BuildHistoryReport buildHistoryReport = new BuildHistoryReport(outputDir);
        buildHistoryReport.addFilesFromResource("dependencies/metrics/aggregate-report", "/index.html");
        long startTime = BuildHistoryReport._getStartTime(startDateString);
        long duration = TimeUnit.DAYS.toMillis(durationDays);
        Collection<BuildHistory> buildHistories = BuildHistoryProcessor.newAggregateJobHistories(duration, startTime);
        buildHistoryReport.addFile("js/table-data.js", BuildHistoryReport._getTableDataJSFileContent(buildHistories, "Job Category", 1, "[Total]"));
        buildHistoryReport.addFile("js/timeline-data.js", BuildHistoryReport._getTimelineDataJSFileContent(buildHistories, duration, startTime));
        return buildHistoryReport;
    }

    public static BuildHistoryReport newPullRequestTestSuiteReport(long durationDays, File outputDir, String startDateString) {
        return BuildHistoryReport._newTestSuiteReport(durationDays, _portalMasterPullRequestJobNamePattern, outputDir, "liferay-portal/master Pull Request History Report", startDateString);
    }

    public static BuildHistoryReport newReleaseTestSuiteReport(long durationDays, File outputDir, String startDateString) {
        return BuildHistoryReport._newTestSuiteReport(durationDays, _portalReleaseJobNamePattern, outputDir, "Portal Release History Report", startDateString);
    }

    public static BuildHistoryReport newUpstreamTestSuiteReport(long durationDays, File outputDir, String startDateString) {
        return BuildHistoryReport._newTestSuiteReport(durationDays, _portalMasterUpstreamJobNamePattern, outputDir, "liferay-portal/master Upstream History Report", startDateString);
    }

    public static BuildHistoryReport newUtilizationReport(long durationDays, File outputDir, String startDateString) {
        BuildHistoryReport buildHistoryReport = new BuildHistoryReport(outputDir);
        buildHistoryReport.addFilesFromResource("dependencies/metrics/utilization-report", "/index.html");
        Collection<BuildHistory> buildHistories = BuildHistoryProcessor.newUtilizationBuildHistories(TimeUnit.DAYS.toMillis(durationDays), BuildHistoryReport._getStartTime(startDateString));
        StringBuilder sb = new StringBuilder();
        sb.append(BuildHistoryReport._getTableDataJSFileContent(buildHistories, "Category", 7, "All"));
        sb.append("\nvar reportName = \"Utilization Report\";");
        buildHistoryReport.addFile("js/table-data.js", sb.toString());
        return buildHistoryReport;
    }

    public BuildHistoryReport(File outputDir) {
        this._outputDir = outputDir;
    }

    public void addFile(String fileName, String fileContent) {
        this._fileMap.put(new File(this._outputDir, fileName), fileContent);
    }

    public void addFilesFromResource(String resourceDirPath, String ... fileNames) {
        for (String fileName : fileNames) {
            try {
                this.addFile(fileName, JenkinsResultsParserUtil.getResourceFileContent(resourceDirPath + fileName));
            }
            catch (IOException ioException) {
                System.out.println("Unable to get file content from resource: " + resourceDirPath + fileName);
            }
        }
    }

    public void write() throws IOException {
        FileUtils.deleteDirectory((File)this._outputDir);
        for (Map.Entry<File, String> entry : this._fileMap.entrySet()) {
            File file = entry.getKey();
            String filePath = file.getCanonicalPath();
            if (filePath.contains(".html")) {
                System.out.println("Report created at: file://" + filePath);
            }
            JenkinsResultsParserUtil.write(entry.getKey(), entry.getValue());
        }
    }

    private static LocalDateTime _getLocalDateTime(String startDateString) {
        return LocalDateTime.parse(startDateString + " 00:00:00", DateTimeFormatter.ofPattern("yyyyMMdd HH:mm:ss"));
    }

    private static long _getStartTime(String startDateString) {
        return JenkinsResultsParserUtil.getMillis(BuildHistoryReport._getLocalDateTime(startDateString));
    }

    private static String _getTableDataJSFileContent(Collection<BuildHistory> buildHistories, String groupIdentifierName, int intervalDays, String mergedBuildHistoryName) {
        JSONArray jsonArray = new JSONArray();
        boolean removeHeader = false;
        for (BuildHistory buildHistory : buildHistories) {
            JSONArray tableJSONArray = buildHistory.getTableJSONArray(groupIdentifierName, intervalDays);
            if (removeHeader) {
                tableJSONArray.remove(0);
            } else {
                removeHeader = true;
            }
            jsonArray.putAll(tableJSONArray);
        }
        if (mergedBuildHistoryName != null) {
            BuildHistory mergedBuildHistory = BuildHistoryProcessor.mergeBuildHistories(buildHistories, mergedBuildHistoryName);
            JSONArray tableJSONArray = mergedBuildHistory.getTableJSONArray(groupIdentifierName, intervalDays);
            tableJSONArray.remove(0);
            jsonArray.putAll(tableJSONArray);
        }
        return "var tableData = " + jsonArray.toString();
    }

    private static String _getTimelineDataJSFileContent(Collection<BuildHistory> buildHistories, long duration, long startTime) {
        JSONObject jsonObject = new JSONObject();
        JSONArray jsonArray = new JSONArray();
        for (BuildHistory buildHistory : buildHistories) {
            jsonArray.put((Object)buildHistory.getTimelineJSONObject());
        }
        jsonObject.put("jobTimelines", (Object)jsonArray).put("time", (Object)BuildHistory.getTimeJSONArray(duration, startTime));
        return "var timelineData = " + jsonObject.toString();
    }

    private static BuildHistoryReport _newTestSuiteReport(long durationDays, Pattern jobNamePattern, File outputDir, String reportName, String startDateString) {
        BuildHistoryReport buildHistoryReport = new BuildHistoryReport(outputDir);
        buildHistoryReport.addFilesFromResource("dependencies/metrics/test-suite-report", "/index.html");
        long duration = TimeUnit.DAYS.toMillis(durationDays);
        Collection<BuildHistory> buildHistories = BuildHistoryProcessor.newTestSuiteJobHistories(duration, jobNamePattern, BuildHistoryReport._getStartTime(startDateString));
        StringBuilder sb = new StringBuilder();
        sb.append(BuildHistoryReport._getTableDataJSFileContent(buildHistories, "Test Suite Name", 1, "[Total]"));
        sb.append("\nvar reportName = \"");
        sb.append(reportName);
        sb.append("\";");
        buildHistoryReport.addFile("js/table-data.js", sb.toString());
        return buildHistoryReport;
    }
}

