/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser.metrics;

import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.json.JSONArray;
import org.json.JSONObject;

public class BuildJSONObject
extends JSONObject {
    private static final Pattern _buildURLPattern = Pattern.compile(JenkinsResultsParserUtil.combine("(?<jobURL>https?://(?<masterHostname>", "(?<cohortName>test-\\d+)-\\d+)(\\.liferay\\.com)?/job/", "(?<jobName>[^/]+)/(.*/)?)(?<buildNumber>\\d+)/?"));
    private static final Pattern _distPathPattern = Pattern.compile(JenkinsResultsParserUtil.combine("[\\w\\/]+(?<masterName>test-[\\d]+-[\\d]+)\\/", "(?<jobName>[\\w\\-\\(\\)]+)\\/(?<buildNumber>[\\d]+)"));
    private String _startDateString;
    private final String _topLevelBuildURL = this._getTopLevelBuildURL();

    public BuildJSONObject(JSONObject jsonObject) {
        this(jsonObject.toString());
    }

    public BuildJSONObject(String source) {
        super(source);
    }

    public long getDuration() {
        return this.optLong("duration");
    }

    public String getJobName() {
        return this._getJobName(this.getURL());
    }

    public Map<String, String> getParameters() {
        HashMap<String, String> parameters = new HashMap<String, String>();
        JSONArray parametersJSONArray = this.optJSONArray("parameters");
        for (int i = 0; i < parametersJSONArray.length(); ++i) {
            JSONObject jsonObject = parametersJSONArray.getJSONObject(i);
            parameters.put(jsonObject.optString("name"), jsonObject.optString("value"));
        }
        return parameters;
    }

    public long getQueueDuration() {
        return this.optLong("queueDuration");
    }

    public String getStartDateString() {
        if (this._startDateString == null) {
            LocalDate startDate = JenkinsResultsParserUtil.getLocalDate(this.getStartTime());
            this._startDateString = startDate.format(DateTimeFormatter.ofPattern("yyyyMMdd"));
        }
        return this._startDateString;
    }

    public long getStartTime() {
        String jobName = this.getJobName();
        if (jobName.equals("maintenance-daily")) {
            return this.optLong("startTime") + this.optLong("queueDuration");
        }
        return this.optLong("startTime");
    }

    public String getTopLevelBuildURL() {
        return this._topLevelBuildURL;
    }

    public String getURL() {
        return this.optString("url");
    }

    public boolean isTopLevelBuild() {
        String url = this.getURL();
        return !url.contains("-batch") && !url.contains("-downstream") && !url.contains("maintenance") && !url.contains("-validation");
    }

    private String _getJobName(String buildURL) {
        if (buildURL == null) {
            return null;
        }
        Matcher matcher = _buildURLPattern.matcher(buildURL);
        if (!matcher.find()) {
            return null;
        }
        return matcher.group("jobName");
    }

    private String _getTopLevelBuildURL() {
        if (this.isTopLevelBuild()) {
            return null;
        }
        Map<String, String> parameters = this.getParameters();
        if (!parameters.containsKey("DIST_PATH")) {
            return null;
        }
        Matcher distPathMatcher = _distPathPattern.matcher(parameters.get("DIST_PATH"));
        if (!distPathMatcher.find()) {
            return null;
        }
        return JenkinsResultsParserUtil.combine("https://", distPathMatcher.group("masterName"), ".liferay.com/job/", distPathMatcher.group("jobName"), "/", distPathMatcher.group("buildNumber"), "/");
    }
}

