/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser.scancode;

import com.google.cloud.storage.Blob;
import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.scancode.ScanCodeS3Bucket;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;

public class ScanCodeS3Object {
    private final Blob _blob;
    private final ScanCodeS3Bucket _scanCodeS3Bucket;
    private final URL _url;

    public void delete() {
        this._blob.delete(new Blob.BlobSourceOption[0]);
    }

    public boolean exists() {
        return this._blob.exists(new Blob.BlobSourceOption[0]);
    }

    public String getKey() {
        return this._blob.getName();
    }

    public ScanCodeS3Bucket getScanCodeS3Bucket() {
        return this._scanCodeS3Bucket;
    }

    public URL getURL() {
        return this._url;
    }

    public String getURLString() {
        return JenkinsResultsParserUtil.fixURL(String.valueOf(this._url));
    }

    public String getValue() {
        if (!this.exists()) {
            return null;
        }
        return new String(this._blob.getContent(new Blob.BlobSourceOption[0]), StandardCharsets.UTF_8);
    }

    public String toString() {
        return this.getURLString();
    }

    protected ScanCodeS3Object(Blob blob, ScanCodeS3Bucket scanCodeS3Bucket) {
        this._blob = blob;
        this._scanCodeS3Bucket = scanCodeS3Bucket;
        try {
            this._url = new URL(JenkinsResultsParserUtil.combine(scanCodeS3Bucket.getScanCodeS3BaseURL(), "/", this.getKey()));
        }
        catch (MalformedURLException malformedURLException) {
            throw new RuntimeException(malformedURLException);
        }
    }
}

