/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser.test.batch;

import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.Job;
import com.liferay.jenkins.results.parser.job.property.JobProperty;
import com.liferay.jenkins.results.parser.job.property.JobPropertyFactory;
import com.liferay.jenkins.results.parser.test.batch.TestBatch;
import com.liferay.jenkins.results.parser.test.batch.TestSelector;
import com.liferay.jenkins.results.parser.test.suite.RelevantRuleConfigurationException;
import com.liferay.jenkins.results.parser.test.suite.RelevantRuleEngine;
import java.io.File;
import java.util.Properties;

public abstract class BaseTestSelector
implements TestSelector {
    private final File _baseDir;
    private final String _batchName;
    private final Job _job;
    private final Properties _properties;
    private final File _propertiesFile;
    private final String _relevantRuleName;
    private TestBatch _testBatch;
    private final String _testSuiteName;

    public BaseTestSelector(File propertiesFile, Properties properties, String batchName, String relevantRuleName, String testSuiteName) {
        this._propertiesFile = propertiesFile;
        this._properties = properties;
        this._batchName = batchName;
        this._relevantRuleName = relevantRuleName;
        this._testSuiteName = testSuiteName;
        RelevantRuleEngine relevantRuleEngine = RelevantRuleEngine.getInstance();
        this._baseDir = relevantRuleEngine.getBaseDir();
        this._job = relevantRuleEngine.getJob();
        if (this._job == null) {
            throw new RuntimeException("Job is not set for test selector");
        }
    }

    public String getBatchName() {
        return this._batchName;
    }

    public JobProperty getGlobalJobProperty(String basePropertyName) {
        return JobPropertyFactory.newJobProperty(basePropertyName, this._testSuiteName, this._batchName, this._job, this._baseDir, null, true);
    }

    public JobProperty getGlobalJobProperty(String basePropertyName, JobProperty.Type type) {
        return JobPropertyFactory.newJobProperty(basePropertyName, this._testSuiteName, this._batchName, this._job, this._baseDir, type, true);
    }

    public Job getJob() {
        return this._job;
    }

    public JobProperty getJobProperty(String basePropertyName, JobProperty.Type type) {
        return JobPropertyFactory.newJobProperty(basePropertyName, this._testSuiteName, this._batchName, this._relevantRuleName, this._job, this._propertiesFile.getParentFile(), type, true);
    }

    public File getPropertiesFile() {
        return this._propertiesFile;
    }

    public String getProperty(String propertyName) {
        return JenkinsResultsParserUtil.getProperty(this._properties, propertyName, this._batchName, this._relevantRuleName, this._testSuiteName);
    }

    public String getRelevantRuleName() {
        return this._relevantRuleName;
    }

    public TestBatch getTestBatch() {
        return this._testBatch;
    }

    public String getTestSuiteName() {
        return this._testSuiteName;
    }

    public void setTestBatch(TestBatch testBatch) {
        this._testBatch = testBatch;
    }

    protected void validate(String propertyName) throws RelevantRuleConfigurationException {
        if (this.getProperty(propertyName) == null) {
            StringBuilder sb = new StringBuilder();
            sb.append("Unable to create batch ");
            sb.append(this._batchName);
            sb.append(" since ");
            sb.append(propertyName);
            sb.append("[");
            sb.append(this.getRelevantRuleName());
            sb.append("][");
            sb.append(this.getTestSuiteName());
            sb.append("][");
            sb.append(this.getBatchName());
            sb.append("] is not set in ");
            sb.append(this.getPropertiesFile());
            throw new RelevantRuleConfigurationException(sb.toString());
        }
    }
}

