/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser.test.batch;

import com.liferay.jenkins.results.parser.job.property.JobProperty;
import com.liferay.jenkins.results.parser.test.batch.BaseTestSelector;
import com.liferay.jenkins.results.parser.test.batch.TestSelector;
import com.liferay.jenkins.results.parser.test.suite.RelevantRuleConfigurationException;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

public class JUnitTestSelector
extends BaseTestSelector {
    private static final String _MODULES_INCLUDES_REQUIRED_TEST_BATCH_CLASS_NAMES_EXCLUDES = "modules.includes.required.test.batch.class.names.excludes";
    private static final String _MODULES_INCLUDES_REQUIRED_TEST_BATCH_CLASS_NAMES_INCLUDES = "modules.includes.required.test.batch.class.names.includes";
    private final List<JobProperty> _excludesJobProperties = new ArrayList<JobProperty>();
    private final List<JobProperty> _includesJobProperties = new ArrayList<JobProperty>();

    public JUnitTestSelector(File propertiesFile, Properties properties, String batchName, String relevantRuleName, String testSuiteName) throws RelevantRuleConfigurationException {
        super(propertiesFile, properties, batchName, relevantRuleName, testSuiteName);
        this.validate();
        this._addJobProperties();
    }

    public List<JobProperty> getExcludesJobProperties() {
        JobProperty jobProperty = this.getGlobalJobProperty("test.batch.class.names.excludes", JobProperty.Type.EXCLUDE_GLOB);
        if (!this._excludesJobProperties.contains(jobProperty)) {
            this._excludesJobProperties.add(jobProperty);
        }
        return this._excludesJobProperties;
    }

    public JobProperty getExcludesJobProperty() {
        return this.getJobProperty(_MODULES_INCLUDES_REQUIRED_TEST_BATCH_CLASS_NAMES_EXCLUDES, JobProperty.Type.MODULE_EXCLUDE_GLOB);
    }

    public List<JobProperty> getIncludesJobProperties() {
        return this._includesJobProperties;
    }

    public JobProperty getIncludesJobProperty() {
        return this.getJobProperty(_MODULES_INCLUDES_REQUIRED_TEST_BATCH_CLASS_NAMES_INCLUDES, JobProperty.Type.MODULE_INCLUDE_GLOB);
    }

    @Override
    public void merge(TestSelector testSelector) {
        if (!(testSelector instanceof JUnitTestSelector)) {
            throw new RuntimeException("Unable to merge test selectors");
        }
        JUnitTestSelector jUnitTestSelector = (JUnitTestSelector)testSelector;
        if (!this._includesJobProperties.contains(jUnitTestSelector.getIncludesJobProperty())) {
            this._includesJobProperties.add(jUnitTestSelector.getIncludesJobProperty());
        }
        if (!this._excludesJobProperties.contains(jUnitTestSelector.getExcludesJobProperty())) {
            this._excludesJobProperties.add(jUnitTestSelector.getExcludesJobProperty());
        }
    }

    @Override
    public void validate() throws RelevantRuleConfigurationException {
        this.validate(_MODULES_INCLUDES_REQUIRED_TEST_BATCH_CLASS_NAMES_INCLUDES);
    }

    private void _addJobProperties() {
        this._excludesJobProperties.add(this.getExcludesJobProperty());
        this._includesJobProperties.add(this.getIncludesJobProperty());
    }
}

