/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser.test.batch;

import com.liferay.jenkins.results.parser.job.property.JobProperty;
import com.liferay.jenkins.results.parser.test.batch.BaseTestSelector;
import com.liferay.jenkins.results.parser.test.batch.TestSelector;
import com.liferay.jenkins.results.parser.test.suite.RelevantRuleConfigurationException;
import java.io.File;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;

public class PlaywrightTestSelector
extends BaseTestSelector {
    private final Set<JobProperty> _playwrightJobProperties = new HashSet<JobProperty>();

    public PlaywrightTestSelector(File propertiesFile, Properties properties, String batchName, String relevantRuleName, String testSuiteName) throws RelevantRuleConfigurationException {
        super(propertiesFile, properties, batchName, relevantRuleName, testSuiteName);
        this.validate();
        JobProperty jobProperty = this.getJobProperty("playwright.test.project", JobProperty.Type.MODULE_TEST_DIR);
        if (jobProperty.getValue() == null) {
            jobProperty = this.getJobProperty("playwright.projects.includes", JobProperty.Type.MODULE_TEST_DIR);
        }
        this._playwrightJobProperties.add(jobProperty);
    }

    public JobProperty getPlaywrightExcludesJobProperty() {
        JobProperty excludesJobProperty = this.getJobProperty("playwright.projects.excludes", JobProperty.Type.MODULE_TEST_DIR);
        if (excludesJobProperty.getValue() != null) {
            return excludesJobProperty;
        }
        return null;
    }

    public Set<JobProperty> getPlaywrightJobProperties() {
        return this._playwrightJobProperties;
    }

    @Override
    public void merge(TestSelector testSelector) {
        if (!(testSelector instanceof PlaywrightTestSelector)) {
            throw new RuntimeException("Unable to merge test selectors");
        }
        PlaywrightTestSelector playwrightTestSelector = (PlaywrightTestSelector)testSelector;
        this._playwrightJobProperties.addAll(playwrightTestSelector.getPlaywrightJobProperties());
    }

    @Override
    public void validate() throws RelevantRuleConfigurationException {
        if (this.getProperty("playwright.projects.includes") == null && this.getProperty("playwright.test.project") == null) {
            StringBuilder sb = new StringBuilder();
            sb.append("Unable to create batch ");
            sb.append(this.getBatchName());
            sb.append(" since playwright.projects.includes[");
            sb.append(this.getRelevantRuleName());
            sb.append("][");
            sb.append(this.getTestSuiteName());
            sb.append("][");
            sb.append(this.getBatchName());
            sb.append("] or playwright.test.project[");
            sb.append(this.getRelevantRuleName());
            sb.append("][");
            sb.append(this.getTestSuiteName());
            sb.append("][");
            sb.append(this.getBatchName());
            sb.append("] is not set in ");
            sb.append(this.getPropertiesFile());
            throw new RelevantRuleConfigurationException(sb.toString());
        }
    }
}

