/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser.test.batch;

import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.job.property.JobProperty;
import com.liferay.jenkins.results.parser.test.batch.BaseTestSelector;
import com.liferay.jenkins.results.parser.test.batch.TestSelector;
import com.liferay.jenkins.results.parser.test.suite.RelevantRuleConfigurationException;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

public class PoshiTestSelector
extends BaseTestSelector {
    private static final String _TEST_BATCH_RUN_PROPERTY_GLOBAL_QUERY = "test.batch.run.property.global.query";
    private static final String _TEST_BATCH_RUN_PROPERTY_QUERY = "test.batch.run.property.query";
    private String _globalPoshiQuery;
    private final List<JobProperty> _poshiJobProperties = new ArrayList<JobProperty>();
    private String _poshiQuery;

    public PoshiTestSelector(File propertiesFile, Properties properties, String batchName, String relevantRuleName, String testSuiteName) throws RelevantRuleConfigurationException {
        super(propertiesFile, properties, batchName, relevantRuleName, testSuiteName);
        this.validate();
        this._addPoshiQuery();
    }

    public List<JobProperty> getPoshiJobProperties() {
        return this._poshiJobProperties;
    }

    public String getPoshiQuery() {
        return this.getPoshiQuery(true);
    }

    public String getPoshiQuery(boolean includeGlobalPoshiQuery) {
        String globalPoshiQuery = this._getGlobalPoshiQuery();
        if (includeGlobalPoshiQuery && !JenkinsResultsParserUtil.isNullOrEmpty(globalPoshiQuery) && !this._poshiQuery.contains(globalPoshiQuery)) {
            return JenkinsResultsParserUtil.combine("(", globalPoshiQuery, ") AND (", this._poshiQuery, ")");
        }
        return this._poshiQuery;
    }

    @Override
    public void merge(TestSelector testSelector) {
        if (!(testSelector instanceof PoshiTestSelector)) {
            throw new RuntimeException("Unable to merge test selectors");
        }
        PoshiTestSelector poshiTestSelector = (PoshiTestSelector)testSelector;
        String newPoshiQuery = poshiTestSelector.getPoshiQuery(false);
        this._poshiJobProperties.addAll(poshiTestSelector.getPoshiJobProperties());
        JenkinsResultsParserUtil.validatePQL(newPoshiQuery, this.getPropertiesFile());
        if (newPoshiQuery.contains(this._poshiQuery)) {
            this._poshiQuery = newPoshiQuery;
        } else if (!this._poshiQuery.contains(newPoshiQuery)) {
            this._poshiQuery = this._poshiQuery + JenkinsResultsParserUtil.combine(" OR (", newPoshiQuery, ")");
        }
    }

    @Override
    public void validate() throws RelevantRuleConfigurationException {
        this.validate(_TEST_BATCH_RUN_PROPERTY_QUERY);
    }

    private void _addPoshiQuery() throws RelevantRuleConfigurationException {
        JobProperty poshiJobProperty = this.getJobProperty(_TEST_BATCH_RUN_PROPERTY_QUERY, JobProperty.Type.MODULE_TEST_DIR);
        if (!JenkinsResultsParserUtil.isNullOrEmpty(poshiJobProperty.getValue())) {
            this._poshiJobProperties.add(poshiJobProperty);
            this._poshiQuery = poshiJobProperty.getValue();
            try {
                JenkinsResultsParserUtil.validatePQL(this._poshiQuery, this.getPropertiesFile());
            }
            catch (Exception exception) {
                throw new RelevantRuleConfigurationException(exception.getMessage());
            }
        }
    }

    private String _getGlobalPoshiQuery() {
        if (this._globalPoshiQuery != null) {
            return this._globalPoshiQuery;
        }
        JobProperty globalJobProperty = this.getGlobalJobProperty(_TEST_BATCH_RUN_PROPERTY_GLOBAL_QUERY);
        if (!JenkinsResultsParserUtil.isNullOrEmpty(globalJobProperty.getValue())) {
            this._poshiJobProperties.add(globalJobProperty);
        }
        this._globalPoshiQuery = globalJobProperty.getValue();
        return this._globalPoshiQuery;
    }
}

