/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser.test.batch;

import com.liferay.jenkins.results.parser.test.batch.DefaultTestBatch;
import com.liferay.jenkins.results.parser.test.batch.JUnitTestBatch;
import com.liferay.jenkins.results.parser.test.batch.JUnitTestSelector;
import com.liferay.jenkins.results.parser.test.batch.PlaywrightTestBatch;
import com.liferay.jenkins.results.parser.test.batch.PlaywrightTestSelector;
import com.liferay.jenkins.results.parser.test.batch.PoshiTestBatch;
import com.liferay.jenkins.results.parser.test.batch.PoshiTestSelector;
import com.liferay.jenkins.results.parser.test.batch.TestBatch;
import com.liferay.jenkins.results.parser.test.suite.RelevantRuleConfigurationException;
import java.io.File;
import java.util.Properties;

public class TestBatchFactory {
    public static TestBatch newTestBatch(File propertiesFile, Properties properties, String batchName, String relevantRuleName, String testSuiteName) {
        if (batchName == null) {
            return null;
        }
        try {
            if (batchName.startsWith("functional")) {
                PoshiTestSelector poshiTestSelector = new PoshiTestSelector(propertiesFile, properties, batchName, relevantRuleName, testSuiteName);
                PoshiTestBatch poshiTestBatch = new PoshiTestBatch(batchName, poshiTestSelector);
                poshiTestSelector.setTestBatch(poshiTestBatch);
                return poshiTestBatch;
            }
            if (batchName.startsWith("modules-integration") || batchName.startsWith("modules-unit")) {
                JUnitTestSelector jUnitTestSelector = new JUnitTestSelector(propertiesFile, properties, batchName, relevantRuleName, testSuiteName);
                JUnitTestBatch jUnitTestBatch = new JUnitTestBatch(batchName, jUnitTestSelector);
                jUnitTestSelector.setTestBatch(jUnitTestBatch);
                return jUnitTestBatch;
            }
            if (batchName.startsWith("playwright-js")) {
                PlaywrightTestSelector playwrightTestSelector = new PlaywrightTestSelector(propertiesFile, properties, batchName, relevantRuleName, testSuiteName);
                PlaywrightTestBatch playwrightTestBatch = new PlaywrightTestBatch(batchName, playwrightTestSelector);
                playwrightTestSelector.setTestBatch(playwrightTestBatch);
                return playwrightTestBatch;
            }
        }
        catch (RelevantRuleConfigurationException relevantRuleConfigurationException) {
            RelevantRuleConfigurationException.addException(relevantRuleConfigurationException);
        }
        return new DefaultTestBatch(batchName);
    }
}

