/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser.test.clazz;

import com.liferay.jenkins.results.parser.BatchHistory;
import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.PortalGitWorkingDirectory;
import com.liferay.jenkins.results.parser.TestHistory;
import com.liferay.jenkins.results.parser.test.clazz.TestClass;
import com.liferay.jenkins.results.parser.test.clazz.TestClassFactory;
import com.liferay.jenkins.results.parser.test.clazz.TestClassMethod;
import com.liferay.jenkins.results.parser.test.clazz.group.BatchTestClassGroup;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.json.JSONArray;
import org.json.JSONObject;

public abstract class BaseTestClass
implements TestClass {
    private Long _averageDuration;
    private Long _averageOverheadDuration;
    private Long _averageTestTaskDuration;
    private final BatchTestClassGroup _batchTestClassGroup;
    private final File _testClassFile;
    private final List<TestClassMethod> _testClassMethods = new ArrayList<TestClassMethod>();
    private TestHistory _testHistory;

    @Override
    public void addTestClassMethod(TestClassMethod testClassMethod) {
        this._testClassMethods.add(testClassMethod);
    }

    @Override
    public int compareTo(TestClass testClass) {
        if (testClass == null) {
            throw new NullPointerException("Test class is null");
        }
        return this._testClassFile.compareTo(testClass.getTestClassFile());
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof TestClass)) {
            return false;
        }
        return Objects.equals(this.hashCode(), object.hashCode());
    }

    @Override
    public long getAverageDuration() {
        if (this._averageDuration != null) {
            return this._averageDuration;
        }
        BatchTestClassGroup batchTestClassGroup = this.getBatchTestClassGroup();
        this._averageDuration = batchTestClassGroup.getAverageTestDuration(this.getTestName());
        return this._averageDuration;
    }

    @Override
    public long getAverageOverheadDuration() {
        if (this._averageOverheadDuration != null) {
            return this._averageOverheadDuration;
        }
        BatchTestClassGroup batchTestClassGroup = this.getBatchTestClassGroup();
        this._averageOverheadDuration = batchTestClassGroup.getAverageTestOverheadDuration(this.getTestName());
        return this._averageOverheadDuration;
    }

    @Override
    public long getAverageTestTaskDuration() {
        if (this._averageTestTaskDuration != null) {
            return this._averageTestTaskDuration;
        }
        BatchTestClassGroup batchTestClassGroup = this.getBatchTestClassGroup();
        this._averageTestTaskDuration = batchTestClassGroup.getAverageTestTaskDuration(this.getTestName());
        return this._averageTestTaskDuration;
    }

    @Override
    public JSONObject getJSONObject() {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("average_duration", this.getAverageDuration()).put("average_overhead_duration", this.getAverageOverheadDuration()).put("file", (Object)this.getTestClassFile()).put("ignored", this.isIgnored());
        JSONArray methodsJSONArray = new JSONArray();
        for (TestClassMethod testClassMethod : this.getTestClassMethods()) {
            methodsJSONArray.put((Object)testClassMethod.getJSONObject());
        }
        jsonObject.put("methods", (Object)methodsJSONArray).put("name", (Object)this.getName());
        return jsonObject;
    }

    @Override
    public String getName() {
        PortalGitWorkingDirectory portalGitWorkingDirectory = this.getPortalGitWorkingDirectory();
        return JenkinsResultsParserUtil.getPathRelativeTo(this.getTestClassFile(), portalGitWorkingDirectory.getWorkingDirectory());
    }

    @Override
    public File getTestClassFile() {
        return this._testClassFile;
    }

    @Override
    public List<TestClassMethod> getTestClassMethods() {
        return this._testClassMethods;
    }

    @Override
    public TestHistory getTestHistory() {
        if (this._testHistory != null) {
            return this._testHistory;
        }
        BatchTestClassGroup batchTestClassGroup = this.getBatchTestClassGroup();
        BatchHistory batchHistory = batchTestClassGroup.getBatchHistory();
        if (batchHistory == null) {
            return null;
        }
        this._testHistory = batchHistory.getTestHistory(this.getTestName());
        return this._testHistory;
    }

    @Override
    public String getTestTaskName() {
        BatchTestClassGroup batchTestClassGroup = this.getBatchTestClassGroup();
        return batchTestClassGroup.getTestTaskName(this.getTestName());
    }

    public int hashCode() {
        JSONObject jsonObject = this.getJSONObject();
        return jsonObject.hashCode();
    }

    @Override
    public boolean hasTestClassMethods() {
        List<TestClassMethod> testClassMethods = this.getTestClassMethods();
        return testClassMethods != null && !testClassMethods.isEmpty();
    }

    @Override
    public boolean isIgnored() {
        return false;
    }

    protected BaseTestClass(BatchTestClassGroup batchTestClassGroup, File testClassFile) {
        this._batchTestClassGroup = batchTestClassGroup;
        this._testClassFile = testClassFile;
    }

    protected BaseTestClass(BatchTestClassGroup batchTestClassGroup, JSONObject jsonObject) {
        this._batchTestClassGroup = batchTestClassGroup;
        this._testClassFile = new File(jsonObject.getString("file"));
        JSONArray methodsJSONArray = jsonObject.getJSONArray("methods");
        if (methodsJSONArray != null && !methodsJSONArray.isEmpty()) {
            for (int i = 0; i < methodsJSONArray.length(); ++i) {
                JSONObject methodJSONObject = methodsJSONArray.getJSONObject(i);
                if (methodJSONObject == null) continue;
                this._testClassMethods.add(TestClassFactory.newTestClassMethod(methodJSONObject, this));
            }
        }
    }

    protected void addTestClassMethod(boolean methodIgnored, String methodName) {
        this.addTestClassMethod(TestClassFactory.newTestClassMethod(methodIgnored, methodName, this));
    }

    protected void addTestClassMethod(String methodName) {
        this.addTestClassMethod(false, methodName);
    }

    protected BatchTestClassGroup getBatchTestClassGroup() {
        return this._batchTestClassGroup;
    }

    protected PortalGitWorkingDirectory getPortalGitWorkingDirectory() {
        return this._batchTestClassGroup.getPortalGitWorkingDirectory();
    }

    protected File getPortalWorkingDirectory() {
        PortalGitWorkingDirectory portalGitWorkingDirectory = this.getPortalGitWorkingDirectory();
        return portalGitWorkingDirectory.getWorkingDirectory();
    }

    protected String getTestName() {
        return this.getName();
    }

    protected File getTestPropertiesBaseDir(File file) {
        if (file == null) {
            return null;
        }
        File canonicalFile = JenkinsResultsParserUtil.getCanonicalFile(file);
        File parentFile = canonicalFile.getParentFile();
        if (parentFile == null || !parentFile.exists()) {
            return file;
        }
        if (!canonicalFile.isDirectory()) {
            return this.getTestPropertiesBaseDir(parentFile);
        }
        File testPropertiesFile = new File(canonicalFile, "test.properties");
        if (!testPropertiesFile.exists()) {
            return this.getTestPropertiesBaseDir(parentFile);
        }
        return canonicalFile;
    }
}

