/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser.test.clazz;

import com.liferay.jenkins.results.parser.BalancedListSplitter;
import com.liferay.jenkins.results.parser.test.clazz.TestClass;

public class FunctionalTestClassBalancedListSplitter
extends BalancedListSplitter<TestClass> {
    public FunctionalTestClassBalancedListSplitter(long maxListWeight) {
        super(maxListWeight);
    }

    @Override
    public long getWeight(BalancedListSplitter.ListItemList listItemList) {
        if (listItemList == null || listItemList.isEmpty()) {
            return 0L;
        }
        long averageDuration = 0L;
        long averageOverheadDuration = 0L;
        for (BalancedListSplitter.ListItem listItem : listItemList) {
            TestClass testClass = (TestClass)listItem.getItem();
            averageDuration += testClass.getAverageDuration();
            averageOverheadDuration += testClass.getAverageOverheadDuration();
        }
        return averageDuration += averageOverheadDuration / (long)listItemList.size();
    }

    @Override
    public long getWeight(TestClass item) {
        return item.getAverageDuration() + item.getAverageOverheadDuration();
    }
}

