/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser.test.clazz;

import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.test.clazz.ModulesTestClass;
import com.liferay.jenkins.results.parser.test.clazz.group.BatchTestClassGroup;
import com.liferay.jenkins.results.parser.test.clazz.group.JSUnitModulesBatchTestClassGroup;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;

public class JSUnitModulesTestClass
extends ModulesTestClass {
    private final File _testPropertiesFile;
    private final String _testrayMainComponentName;

    public String getTestrayMainComponentName() {
        return this._testrayMainComponentName;
    }

    protected JSUnitModulesTestClass(BatchTestClassGroup batchTestClassGroup, File testClassFile) {
        super(batchTestClassGroup, testClassFile, "packageRunTest");
        File testPropertiesBaseDir = this.getTestPropertiesBaseDir(this.getTestClassFile());
        if (testPropertiesBaseDir != null && testPropertiesBaseDir.exists()) {
            this._testPropertiesFile = new File(testPropertiesBaseDir, "test.properties");
            this._testrayMainComponentName = JenkinsResultsParserUtil.getProperty(JenkinsResultsParserUtil.getProperties(this._testPropertiesFile), "testray.main.component.name");
        } else {
            this._testPropertiesFile = null;
            this._testrayMainComponentName = null;
        }
    }

    protected JSUnitModulesTestClass(BatchTestClassGroup batchTestClassGroup, JSONObject jsonObject) {
        super(batchTestClassGroup, jsonObject);
        this._testPropertiesFile = jsonObject.has("file") ? new File(jsonObject.getString("file") + "/test.properties") : (jsonObject.has("test_properties_file") ? new File(jsonObject.getString("test_properties_file")) : null);
        if (this._testPropertiesFile != null) {
            String testrayMainComponentName = JenkinsResultsParserUtil.getProperty(JenkinsResultsParserUtil.getProperties(this._testPropertiesFile), "testray.main.component.name");
            if (JenkinsResultsParserUtil.isNullOrEmpty(testrayMainComponentName)) {
                File parentFile = this._testPropertiesFile.getParentFile();
                parentFile = parentFile.getParentFile();
                testrayMainComponentName = JenkinsResultsParserUtil.getProperty(JenkinsResultsParserUtil.getProperties(new File(parentFile + "/test.properties")), "testray.main.component.name");
            }
            this._testrayMainComponentName = JenkinsResultsParserUtil.isNullOrEmpty(testrayMainComponentName) ? null : testrayMainComponentName;
        } else {
            this._testrayMainComponentName = jsonObject.optString("testray_main_component_name");
        }
    }

    @Override
    protected List<File> getModulesProjectDirs() {
        final ArrayList<File> modulesProjectDirs = new ArrayList<File>();
        final boolean testGitrepoJSUnit = this._testGitrepoJSUnit();
        final File portalModulesBaseDir = this.getPortalModulesBaseDir();
        try {
            Files.walkFileTree(this.getModuleBaseDirPath(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult preVisitDirectory(Path filePath, BasicFileAttributes basicFileAttributes) {
                    File gitrepoFile;
                    if (filePath.equals(portalModulesBaseDir.toPath())) {
                        return FileVisitResult.CONTINUE;
                    }
                    File file = filePath.toFile();
                    File currentDirectory = new File(JenkinsResultsParserUtil.getCanonicalPath(file));
                    String currentDirectoryPath = currentDirectory.getAbsolutePath();
                    if (currentDirectoryPath.contains("modules") && !currentDirectoryPath.contains("modules/apps") && !currentDirectoryPath.contains("modules/dxp")) {
                        return FileVisitResult.SKIP_SUBTREE;
                    }
                    if (!testGitrepoJSUnit && (gitrepoFile = new File(currentDirectory, ".gitrepo")).exists() && !currentDirectoryPath.contains("osb-faro")) {
                        return FileVisitResult.SKIP_SUBTREE;
                    }
                    File buildGradleFile = new File(currentDirectory, "build.gradle");
                    File packageJSONFile = new File(currentDirectory, "package.json");
                    if (!buildGradleFile.exists() || !packageJSONFile.exists()) {
                        return FileVisitResult.CONTINUE;
                    }
                    try {
                        JSONObject packageJSONObject = new JSONObject(JenkinsResultsParserUtil.read(packageJSONFile));
                        if (!packageJSONObject.has("scripts")) {
                            return FileVisitResult.CONTINUE;
                        }
                        JSONObject scriptsJSONObject = packageJSONObject.getJSONObject("scripts");
                        if (!scriptsJSONObject.has("test")) {
                            return FileVisitResult.CONTINUE;
                        }
                        modulesProjectDirs.add(currentDirectory);
                        return FileVisitResult.SKIP_SUBTREE;
                    }
                    catch (IOException | JSONException exception) {
                        return FileVisitResult.CONTINUE;
                    }
                }
            });
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
        return modulesProjectDirs;
    }

    private boolean _testGitrepoJSUnit() {
        BatchTestClassGroup batchTestClassGroup = this.getBatchTestClassGroup();
        if (!(batchTestClassGroup instanceof JSUnitModulesBatchTestClassGroup)) {
            return false;
        }
        JSUnitModulesBatchTestClassGroup jsUnitModulesBatchTestClassGroup = (JSUnitModulesBatchTestClassGroup)batchTestClassGroup;
        return jsUnitModulesBatchTestClassGroup.testGitrepoJSUnit();
    }
}

