/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser.test.clazz;

import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.PortalGitWorkingDirectory;
import com.liferay.jenkins.results.parser.test.clazz.BaseTestClass;
import com.liferay.jenkins.results.parser.test.clazz.TestClass;
import com.liferay.jenkins.results.parser.test.clazz.TestClassFactory;
import com.liferay.jenkins.results.parser.test.clazz.TestClassMethod;
import com.liferay.jenkins.results.parser.test.clazz.group.BatchTestClassGroup;
import com.liferay.jenkins.results.parser.test.clazz.group.JUnitBatchTestClassGroup;
import java.io.File;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.json.JSONObject;

public class JUnitTestClass
extends BaseTestClass {
    private static final Pattern _classHeaderPattern = Pattern.compile(JenkinsResultsParserUtil.combine("\\*/(?<annotations>[^/]*)public\\s+class\\s+", "(?<className>[^\\(\\s]+)"));
    private static final Pattern _methodHeaderPattern = Pattern.compile(JenkinsResultsParserUtil.combine("\\t(?<annotations>(@[\\s\\S]+?))public\\s+void\\s+", "(?<methodName>[^\\(\\s]+)"));
    private boolean _classIgnored;
    private final File _modulesBaseDir;
    private final File _testPropertiesFile;
    private final String _testrayMainComponentName;

    @Override
    public JSONObject getJSONObject() {
        JSONObject jsonObject = super.getJSONObject();
        if (this._testPropertiesFile != null && this._testPropertiesFile.exists()) {
            jsonObject.put("test_properties_file", (Object)this._testPropertiesFile);
        }
        if (!JenkinsResultsParserUtil.isNullOrEmpty(this._testrayMainComponentName)) {
            jsonObject.put("testray_main_component_name", (Object)this._testrayMainComponentName);
        }
        return jsonObject;
    }

    public String getTestClassName() {
        return JenkinsResultsParserUtil.combine(this._getPackageName(), ".", this._getClassName());
    }

    public String getTestrayMainComponentName() {
        return this._testrayMainComponentName;
    }

    @Override
    public boolean isIgnored() {
        return this._classIgnored;
    }

    protected JUnitTestClass(BatchTestClassGroup batchTestClassGroup, File testClassFile) {
        super(batchTestClassGroup, testClassFile);
        File modulesBaseDir = this._getPortalModulesBaseDir();
        this._modulesBaseDir = modulesBaseDir != null && modulesBaseDir.exists() ? modulesBaseDir : new File(".");
        File testPropertiesBaseDir = this.getTestPropertiesBaseDir(this.getTestClassFile());
        if (testPropertiesBaseDir != null && testPropertiesBaseDir.exists()) {
            this._testPropertiesFile = new File(testPropertiesBaseDir, "test.properties");
            String testrayMainComponentName = JenkinsResultsParserUtil.getProperty(JenkinsResultsParserUtil.getProperties(this._testPropertiesFile), "testray.main.component.name");
            if (testrayMainComponentName == null && this._modulesBaseDir.exists()) {
                testrayMainComponentName = JenkinsResultsParserUtil.getProperty(JenkinsResultsParserUtil.getProperties(this._getParentTestPropertiesFile(testPropertiesBaseDir)), "testray.main.component.name");
            }
            this._testrayMainComponentName = testrayMainComponentName;
        } else {
            this._testPropertiesFile = null;
            this._testrayMainComponentName = null;
        }
        String testClassFileName = testClassFile.getName();
        if (!testClassFileName.endsWith(".java")) {
            return;
        }
        try {
            this._initTestClassMethods(JenkinsResultsParserUtil.read(this.getTestClassFile()));
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
    }

    protected JUnitTestClass(BatchTestClassGroup batchTestClassGroup, JSONObject jsonObject) {
        super(batchTestClassGroup, jsonObject);
        this._classIgnored = jsonObject.getBoolean("ignored");
        File modulesBaseDir = this._getPortalModulesBaseDir();
        this._modulesBaseDir = modulesBaseDir != null && modulesBaseDir.exists() ? modulesBaseDir : null;
        this._testPropertiesFile = jsonObject.has("test_properties_file") ? new File(jsonObject.getString("test_properties_file")) : null;
        File testPropertiesBaseDir = this.getTestPropertiesBaseDir(this.getTestClassFile());
        String testrayMainComponentName = jsonObject.optString("testray_main_component_name");
        if (testrayMainComponentName == null && this._modulesBaseDir.exists()) {
            testrayMainComponentName = JenkinsResultsParserUtil.getProperty(JenkinsResultsParserUtil.getProperties(this._getParentTestPropertiesFile(testPropertiesBaseDir)), "testray.main.component.name");
        }
        this._testrayMainComponentName = testrayMainComponentName;
    }

    @Override
    protected String getTestName() {
        return this._getPackageName() + "." + this._getClassName();
    }

    private String _getClassName() {
        File testClassFile = this.getTestClassFile();
        String testClassFileName = testClassFile.getName();
        return testClassFileName.substring(0, testClassFileName.lastIndexOf("."));
    }

    private String _getPackageName() {
        String testClassFilePath = JenkinsResultsParserUtil.getCanonicalPath(this.getTestClassFile());
        int x = testClassFilePath.indexOf("/com/");
        int y = testClassFilePath.lastIndexOf("/");
        testClassFilePath = testClassFilePath.substring(x + 1, y);
        return testClassFilePath.replaceAll("/", ".");
    }

    private String _getParentClassName(String fileContent) {
        Pattern classHeaderPattern = Pattern.compile(JenkinsResultsParserUtil.combine("public\\s+(abstract\\s+)?(class|interface)\\s+", this._getClassName(), "(\\<[^\\<]+\\>)?(?<classHeaderEntities>[^\\{]+)\\{"));
        Matcher classHeaderMatcher = classHeaderPattern.matcher(fileContent);
        if (!classHeaderMatcher.find()) {
            throw new RuntimeException("No class header found in " + this.getTestClassFile());
        }
        String classHeaderEntities = classHeaderMatcher.group("classHeaderEntities");
        Pattern parentClassPattern = Pattern.compile(JenkinsResultsParserUtil.combine("extends\\s+(?<parentClassName>[^\\s\\<]+)"));
        Matcher parentClassMatcher = parentClassPattern.matcher(classHeaderEntities);
        if (parentClassMatcher.find()) {
            return parentClassMatcher.group("parentClassName");
        }
        return null;
    }

    private String _getParentFullClassName(String fileContent) {
        String parentClassName = this._getParentClassName(fileContent);
        if (parentClassName == null) {
            return null;
        }
        if (parentClassName.contains(".") && parentClassName.matches("[a-z].*")) {
            if (!parentClassName.startsWith("com.liferay")) {
                return null;
            }
            return parentClassName;
        }
        String parentPackageName = this._getParentPackageName(fileContent, parentClassName);
        if (parentPackageName == null) {
            return null;
        }
        return parentPackageName + "." + parentClassName;
    }

    private String _getParentPackageName(String fileContent, String parentClassName) {
        Pattern parentImportClassPattern = Pattern.compile(JenkinsResultsParserUtil.combine("import\\s+(?<parentPackageName>[^;]+)\\.", parentClassName, ";"));
        Matcher parentImportClassMatcher = parentImportClassPattern.matcher(fileContent);
        if (parentImportClassMatcher.find()) {
            String parentPackageName = parentImportClassMatcher.group("parentPackageName");
            if (!parentPackageName.startsWith("com.liferay")) {
                return null;
            }
            return parentPackageName;
        }
        return this._getPackageName();
    }

    private File _getParentTestPropertiesFile(File currentDir) {
        if (currentDir == null || currentDir.compareTo(this._modulesBaseDir) == 0) {
            return null;
        }
        File parentDir = currentDir.getParentFile();
        File parentPropertiesFile = new File(parentDir, "test.properties");
        if (parentPropertiesFile.exists()) {
            return parentPropertiesFile;
        }
        return this._getParentTestPropertiesFile(parentDir);
    }

    private File _getPortalModulesBaseDir() {
        PortalGitWorkingDirectory portalGitWorkingDirectory = this.getPortalGitWorkingDirectory();
        return new File(portalGitWorkingDirectory.getWorkingDirectory(), "modules");
    }

    private void _initTestClassMethods(String fileContent) {
        String annotations;
        Matcher classHeaderMatcher = _classHeaderPattern.matcher(fileContent);
        this._classIgnored = false;
        if (classHeaderMatcher.find() && (annotations = classHeaderMatcher.group("annotations")) != null && annotations.contains("@Ignore")) {
            this._classIgnored = true;
        }
        Matcher methodHeaderMatcher = _methodHeaderPattern.matcher(fileContent);
        while (methodHeaderMatcher.find()) {
            String annotations2 = methodHeaderMatcher.group("annotations");
            boolean methodIgnored = false;
            if (this._classIgnored || annotations2.contains("@Ignore")) {
                methodIgnored = true;
            }
            if (!annotations2.contains("@Test")) continue;
            String methodName = methodHeaderMatcher.group("methodName");
            this.addTestClassMethod(methodIgnored, methodName);
        }
        String parentFullClassName = this._getParentFullClassName(fileContent);
        if (parentFullClassName == null) {
            return;
        }
        JUnitBatchTestClassGroup jUnitBatchTestClassGroup = (JUnitBatchTestClassGroup)this.getBatchTestClassGroup();
        File parentJavaFile = jUnitBatchTestClassGroup.getJavaFileFromFullClassName(parentFullClassName);
        if (parentJavaFile == null) {
            System.out.println("No matching files found for " + parentFullClassName);
            return;
        }
        TestClass parentTestClass = TestClassFactory.newTestClass(this.getBatchTestClassGroup(), parentJavaFile);
        if (parentTestClass == null) {
            return;
        }
        for (TestClassMethod testClassMethod : parentTestClass.getTestClassMethods()) {
            this.addTestClassMethod(this._classIgnored, testClassMethod.getName());
        }
    }
}

