/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser.test.clazz;

import com.liferay.jenkins.results.parser.BalancedListSplitter;
import com.liferay.jenkins.results.parser.test.clazz.TestClass;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

public class JUnitTestClassBalancedListSplitter
extends BalancedListSplitter<TestClass> {
    public JUnitTestClassBalancedListSplitter(long maxListWeight) {
        super(maxListWeight);
    }

    @Override
    public long getWeight(BalancedListSplitter.ListItemList listItemList) {
        if (listItemList == null || listItemList.isEmpty()) {
            return 0L;
        }
        long averageDuration = 0L;
        long averageOverheadDuration = 0L;
        HashMap<String, Long> testTaskDurations = new HashMap<String, Long>();
        for (BalancedListSplitter.ListItem listItem : listItemList) {
            TestClass testClass = (TestClass)listItem.getItem();
            averageDuration += testClass.getAverageDuration();
            averageOverheadDuration += testClass.getAverageOverheadDuration();
            String testTaskName = testClass.getTestTaskName();
            if (testTaskDurations.containsKey(testTaskName)) continue;
            testTaskDurations.put(testTaskName, testClass.getAverageTestTaskDuration());
        }
        averageDuration += averageOverheadDuration / (long)listItemList.size();
        for (Long testTaskDuration : testTaskDurations.values()) {
            averageDuration += testTaskDuration.longValue();
        }
        return averageDuration;
    }

    @Override
    public long getWeight(TestClass item) {
        return item.getAverageDuration() + item.getAverageOverheadDuration() + item.getAverageTestTaskDuration();
    }

    @Override
    public List<List<TestClass>> split(List<TestClass> list) {
        BalancedListSplitter.ListItemList listItems = new BalancedListSplitter.ListItemList(this);
        for (TestClass testClass : list) {
            listItems.add(new BalancedListSplitter.ListItem(this, testClass));
        }
        Collections.sort(listItems);
        ArrayList<BalancedListSplitter.ListItemList> listItemLists = new ArrayList<BalancedListSplitter.ListItemList>();
        for (BalancedListSplitter.ListItem listItem : listItems) {
            boolean addedToList = false;
            for (BalancedListSplitter.ListItemList listItemList : listItemLists) {
                long availableWeight = listItemList.getAvailableWeight();
                if (availableWeight <= 0L || availableWeight < listItem.getWeight(listItemList)) continue;
                listItemList.add(listItem);
                addedToList = true;
                break;
            }
            if (addedToList) continue;
            BalancedListSplitter.ListItemList newListItemList = new BalancedListSplitter.ListItemList(this, this.getMaxListWeight());
            newListItemList.add(listItem);
            listItemLists.add(newListItemList);
        }
        ArrayList<List<TestClass>> arrayList = new ArrayList<List<TestClass>>(listItemLists.size());
        for (BalancedListSplitter.ListItemList listItemList : listItemLists) {
            List newList = listItemList.toList();
            if (newList == null || newList.isEmpty()) continue;
            arrayList.add(newList);
        }
        return arrayList;
    }
}

