/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser.test.clazz;

import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.test.clazz.JUnitTestClass;
import com.liferay.jenkins.results.parser.test.clazz.PlaywrightTestClassMethod;
import com.liferay.jenkins.results.parser.test.clazz.TestClassMethod;
import com.liferay.jenkins.results.parser.test.clazz.group.BatchTestClassGroup;
import java.io.File;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.json.JSONObject;

public class PlaywrightJUnitTestClass
extends JUnitTestClass {
    private static final String _MINIMUM_SLAVE_RAM_DEFAULT = "12";
    private static final String _SLAVE_LABEL_DEFAULT = "!master";
    private static final Pattern _testFilePathPattern = Pattern.compile(".+/playwright/(setup|tests)/(?<specFilePath>.+)");
    private Long _averageDuration;
    private final Integer _minimumSlaveRAM;
    private final String _slaveLabel;

    @Override
    public long getAverageDuration() {
        if (this._averageDuration != null) {
            return this._averageDuration;
        }
        for (TestClassMethod testClassMethod : this.getTestClassMethods()) {
            PlaywrightTestClassMethod playwrightTestClassMethod = (PlaywrightTestClassMethod)testClassMethod;
            BatchTestClassGroup batchTestClassGroup = this.getBatchTestClassGroup();
            long averageDuration = batchTestClassGroup.getAverageTestDuration(JenkinsResultsParserUtil.combine(this.getName(), ".", playwrightTestClassMethod.getTestName()));
            if (this._averageDuration == null) {
                this._averageDuration = averageDuration;
                continue;
            }
            this._averageDuration = this._averageDuration + averageDuration;
        }
        return this._averageDuration;
    }

    @Override
    public JSONObject getJSONObject() {
        JSONObject jsonObject = super.getJSONObject();
        jsonObject.put("minimum_slave_ram", (Object)this._minimumSlaveRAM).put("slave_label", (Object)this._slaveLabel);
        return jsonObject;
    }

    public Integer getMinimumSlaveRAM() {
        return this._minimumSlaveRAM;
    }

    @Override
    public String getName() {
        return this.getSpecFilePath();
    }

    public String getSlaveLabel() {
        return this._slaveLabel;
    }

    public String getSpecFilePath() {
        Matcher matcher = _testFilePathPattern.matcher(JenkinsResultsParserUtil.getCanonicalPath(this.getTestClassFile()));
        if (!matcher.find()) {
            return null;
        }
        return matcher.group("specFilePath");
    }

    protected PlaywrightJUnitTestClass(BatchTestClassGroup batchTestClassGroup, File testClassFile) {
        super(batchTestClassGroup, testClassFile);
        File testPropertiesBaseDir = this.getTestPropertiesBaseDir(this.getTestClassFile());
        if (testPropertiesBaseDir != null && testPropertiesBaseDir.exists()) {
            File testPropertiesFile = new File(testPropertiesBaseDir, "test.properties");
            Properties testProperties = JenkinsResultsParserUtil.getProperties(testPropertiesFile);
            String minimumSlaveRAM = JenkinsResultsParserUtil.getProperty(testProperties, "test.batch.minimum.slave.ram");
            if (minimumSlaveRAM == null || !minimumSlaveRAM.matches("\\d+")) {
                minimumSlaveRAM = _MINIMUM_SLAVE_RAM_DEFAULT;
            }
            this._minimumSlaveRAM = Integer.valueOf(minimumSlaveRAM);
            String slaveLabel = JenkinsResultsParserUtil.getProperty(testProperties, "test.batch.slave.label");
            if (JenkinsResultsParserUtil.isNullOrEmpty(slaveLabel)) {
                slaveLabel = _SLAVE_LABEL_DEFAULT;
            }
            this._slaveLabel = slaveLabel;
        } else {
            this._minimumSlaveRAM = null;
            this._slaveLabel = null;
        }
    }

    protected PlaywrightJUnitTestClass(BatchTestClassGroup batchTestClassGroup, JSONObject jsonObject) {
        super(batchTestClassGroup, jsonObject);
        this._minimumSlaveRAM = jsonObject.optInt("minimum_slave_ram");
        this._slaveLabel = jsonObject.optString("slave_label");
    }
}

