/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser.test.clazz;

import com.liferay.jenkins.results.parser.test.clazz.ModulesTestClass;
import com.liferay.jenkins.results.parser.test.clazz.group.BatchTestClassGroup;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONObject;

public class RESTBuilderModulesTestClass
extends ModulesTestClass {
    protected RESTBuilderModulesTestClass(BatchTestClassGroup batchTestClassGroup, File testClassFile) {
        super(batchTestClassGroup, testClassFile, "buildREST");
    }

    protected RESTBuilderModulesTestClass(BatchTestClassGroup batchTestClassGroup, JSONObject jsonObject) {
        super(batchTestClassGroup, jsonObject);
    }

    @Override
    protected List<File> getModulesProjectDirs() {
        final ArrayList<File> modulesProjectDirs = new ArrayList<File>();
        Path moduleBaseDirPath = this.getModuleBaseDirPath();
        try {
            Files.walkFileTree(moduleBaseDirPath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult preVisitDirectory(Path filePath, BasicFileAttributes basicFileAttributes) {
                    File currentDirectory = filePath.toFile();
                    String filePathString = filePath.toString();
                    if (filePathString.endsWith("-impl")) {
                        File restConfigYAMLFile = new File(currentDirectory, "rest-config.yaml");
                        File restOpenAPIYAMLFile = new File(currentDirectory, "rest-openapi.yaml");
                        if (restConfigYAMLFile.exists() && restOpenAPIYAMLFile.exists()) {
                            modulesProjectDirs.add(currentDirectory);
                            return FileVisitResult.SKIP_SUBTREE;
                        }
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException ioException) {
            throw new RuntimeException("Unable to get module marker files from " + moduleBaseDirPath, ioException);
        }
        return modulesProjectDirs;
    }
}

