/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser.test.clazz;

import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.test.clazz.ModulesTestClass;
import com.liferay.jenkins.results.parser.test.clazz.group.BatchTestClassGroup;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONObject;

public class SemVerModulesTestClass
extends ModulesTestClass {
    private final File _testPropertiesFile;
    private final String _testrayMainComponentName;

    @Override
    public JSONObject getJSONObject() {
        JSONObject jsonObject = super.getJSONObject();
        if (this._testPropertiesFile != null && this._testPropertiesFile.exists()) {
            jsonObject.put("test_properties_file", (Object)this._testPropertiesFile);
        }
        if (!JenkinsResultsParserUtil.isNullOrEmpty(this._testrayMainComponentName)) {
            jsonObject.put("testray_main_component_name", (Object)this._testrayMainComponentName);
        }
        return jsonObject;
    }

    public String getTestrayMainComponentName() {
        return this._testrayMainComponentName;
    }

    protected SemVerModulesTestClass(BatchTestClassGroup batchTestClassGroup, File moduleBaseDir) {
        super(batchTestClassGroup, moduleBaseDir, "baseline");
        File testPropertiesBaseDir = this.getTestPropertiesBaseDir(this.getTestClassFile());
        if (testPropertiesBaseDir != null && testPropertiesBaseDir.exists()) {
            this._testPropertiesFile = new File(testPropertiesBaseDir, "test.properties");
            this._testrayMainComponentName = JenkinsResultsParserUtil.getProperty(JenkinsResultsParserUtil.getProperties(this._testPropertiesFile), "testray.main.component.name");
        } else {
            this._testPropertiesFile = null;
            this._testrayMainComponentName = null;
        }
    }

    protected SemVerModulesTestClass(BatchTestClassGroup batchTestClassGroup, JSONObject jsonObject) {
        super(batchTestClassGroup, jsonObject);
        this._testPropertiesFile = jsonObject.has("test_properties_file") ? new File(jsonObject.getString("test_properties_file")) : null;
        this._testrayMainComponentName = jsonObject.optString("testray_main_component_name");
    }

    @Override
    protected List<File> getModulesProjectDirs() {
        final ArrayList<File> modulesProjectDirs = new ArrayList<File>();
        final File portalModulesBaseDir = this.getPortalModulesBaseDir();
        Path moduleBaseDirPath = this.getModuleBaseDirPath();
        try {
            Files.walkFileTree(moduleBaseDirPath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult preVisitDirectory(Path filePath, BasicFileAttributes basicFileAttributes) {
                    if (filePath.equals(portalModulesBaseDir.toPath())) {
                        return FileVisitResult.CONTINUE;
                    }
                    String filePathString = filePath.toString();
                    if (filePathString.endsWith("-test")) {
                        return FileVisitResult.SKIP_SUBTREE;
                    }
                    File currentDirectory = filePath.toFile();
                    File bndBndFile = new File(currentDirectory, "bnd.bnd");
                    File buildFile = new File(currentDirectory, "build.gradle");
                    File lfrRelengIgnoreFile = new File(currentDirectory, ".lfrbuild-releng-ignore");
                    if (buildFile.exists() && bndBndFile.exists() && !lfrRelengIgnoreFile.exists()) {
                        modulesProjectDirs.add(currentDirectory);
                        return FileVisitResult.SKIP_SUBTREE;
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException ioException) {
            throw new RuntimeException("Unable to get module marker files from " + moduleBaseDirPath, ioException);
        }
        return modulesProjectDirs;
    }
}

