/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser.test.clazz.group;

import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.PortalGitWorkingDirectory;
import com.liferay.jenkins.results.parser.PortalTestClassJob;
import com.liferay.jenkins.results.parser.test.clazz.TestClass;
import com.liferay.jenkins.results.parser.test.clazz.TestClassFactory;
import com.liferay.jenkins.results.parser.test.clazz.group.BatchTestClassGroup;
import com.liferay.jenkins.results.parser.test.clazz.group.ModulesBatchTestClassGroup;
import java.io.File;
import java.io.IOException;
import java.nio.file.PathMatcher;
import java.util.Collections;
import java.util.List;
import org.json.JSONObject;

public class CompileModulesBatchTestClassGroup
extends ModulesBatchTestClassGroup {
    protected CompileModulesBatchTestClassGroup(JSONObject jsonObject, PortalTestClassJob portalTestClassJob) {
        super(jsonObject, portalTestClassJob);
    }

    protected CompileModulesBatchTestClassGroup(String batchName, PortalTestClassJob portalTestClassJob) {
        super(batchName, portalTestClassJob);
    }

    @Override
    protected void setTestClasses() throws IOException {
        PortalGitWorkingDirectory portalGitWorkingDirectory = this.getPortalGitWorkingDirectory();
        List<PathMatcher> excludesPathMatchers = this.getPathMatchers(this.getExcludesJobProperties());
        List<PathMatcher> includesPathMatchers = this.getIncludesPathMatchers();
        if (!(!this.testRelevantChanges || this.includeStableTestSuite && this.isStableTestSuiteBatch())) {
            List<File> modifiedModuleDirsList = portalGitWorkingDirectory.getModifiedModuleDirsList(excludesPathMatchers, includesPathMatchers);
            for (File modifiedModuleDir : modifiedModuleDirsList) {
                List<File> lfrBuildPortalFiles = JenkinsResultsParserUtil.findFiles(modifiedModuleDir, "\\.lfrbuild-portal");
                if (lfrBuildPortalFiles.isEmpty()) continue;
                this.moduleDirsList.add(modifiedModuleDir);
            }
        } else {
            this.moduleDirsList.addAll(portalGitWorkingDirectory.getModuleDirsList(excludesPathMatchers, includesPathMatchers));
        }
        for (File moduleDir : this.moduleDirsList) {
            TestClass testClass = TestClassFactory.newTestClass((BatchTestClassGroup)this, moduleDir);
            if (!testClass.hasTestClassMethods()) continue;
            this.testClasses.add(testClass);
        }
        Collections.sort(this.testClasses);
    }
}

