/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser.test.clazz.group;

import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.Job;
import com.liferay.jenkins.results.parser.PortalFixpackEnvironmentJob;
import com.liferay.jenkins.results.parser.PortalGitWorkingDirectory;
import com.liferay.jenkins.results.parser.job.property.JobProperty;
import com.liferay.jenkins.results.parser.test.clazz.group.BatchTestClassGroup;
import com.liferay.jenkins.results.parser.test.clazz.group.FunctionalSegmentTestClassGroup;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import org.json.JSONObject;

public class EnvironmentFunctionalSegmentTestClassGroup
extends FunctionalSegmentTestClassGroup {
    @Override
    public String getTestCasePropertiesContent() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.getTestCasePropertiesContent());
        sb.append("\n");
        ArrayList<Map.Entry<String, String>> entries = new ArrayList<Map.Entry<String, String>>();
        entries.add(this._getAppServerTypeEntry());
        entries.add(this._getAppServerVersionEntry());
        entries.add(this._getBrowserTypeEntry());
        entries.add(this._getBrowserVersionEntry());
        entries.add(this._getDatabaseTypeEntry());
        entries.add(this._getDatabaseVersionEntry());
        entries.add(this._getFixPackURLEntry());
        entries.add(this._getJavaJDKArchitectureEntry());
        entries.add(this._getJavaJDKTypeEntry());
        entries.add(this._getJavaJDKVersionEntry());
        entries.add(this._getOperatingSystemTypeEntry());
        entries.add(this._getOperatingSystemVersionEntry());
        entries.add(this._getTestrayBuildNameEntry());
        entries.removeAll(Collections.singleton(null));
        for (Map.Entry entry : entries) {
            sb.append((String)entry.getKey());
            sb.append("=");
            sb.append((String)entry.getValue());
            sb.append("\n");
        }
        return sb.toString();
    }

    protected EnvironmentFunctionalSegmentTestClassGroup(BatchTestClassGroup parentBatchTestClassGroup) {
        super(parentBatchTestClassGroup);
    }

    protected EnvironmentFunctionalSegmentTestClassGroup(BatchTestClassGroup parentBatchTestClassGroup, JSONObject jsonObject) {
        super(parentBatchTestClassGroup, jsonObject);
    }

    private String _getAppServerType() {
        BatchTestClassGroup batchTestClassGroup = this.getBatchTestClassGroup();
        JobProperty jobProperty = batchTestClassGroup.getJobProperty("environment.app.server.type");
        String jobPropertyValue = jobProperty.getValue();
        if (!JenkinsResultsParserUtil.isNullOrEmpty(jobPropertyValue)) {
            return jobPropertyValue;
        }
        PortalGitWorkingDirectory portalGitWorkingDirectory = batchTestClassGroup.getPortalGitWorkingDirectory();
        if (portalGitWorkingDirectory == null) {
            return null;
        }
        return JenkinsResultsParserUtil.getProperty(portalGitWorkingDirectory.getAppServerProperties(), "app.server.type");
    }

    private Map.Entry<String, String> _getAppServerTypeEntry() {
        String appServerType = this._getAppServerType();
        if (JenkinsResultsParserUtil.isNullOrEmpty(appServerType)) {
            return null;
        }
        return new AbstractMap.SimpleEntry<String, String>("APP_SERVER_TYPE", appServerType);
    }

    private String _getAppServerVersion() {
        BatchTestClassGroup batchTestClassGroup = this.getBatchTestClassGroup();
        JobProperty jobProperty = batchTestClassGroup.getJobProperty("environment.app.server.version");
        String jobPropertyValue = jobProperty.getValue();
        if (!JenkinsResultsParserUtil.isNullOrEmpty(jobPropertyValue)) {
            return jobPropertyValue;
        }
        PortalGitWorkingDirectory portalGitWorkingDirectory = batchTestClassGroup.getPortalGitWorkingDirectory();
        String appServerType = this._getAppServerType();
        if (portalGitWorkingDirectory == null || JenkinsResultsParserUtil.isNullOrEmpty(appServerType)) {
            return null;
        }
        return JenkinsResultsParserUtil.getProperty(portalGitWorkingDirectory.getAppServerProperties(), "app.server." + appServerType + ".version");
    }

    private Map.Entry<String, String> _getAppServerVersionEntry() {
        String appServerVersion = this._getAppServerVersion();
        if (JenkinsResultsParserUtil.isNullOrEmpty(appServerVersion)) {
            return null;
        }
        return new AbstractMap.SimpleEntry<String, String>("APP_SERVER_VERSION", appServerVersion);
    }

    private Map.Entry<String, String> _getBrowserTypeEntry() {
        return this.getEnvironmentVariableEntry("BROWSER_TYPE", "environment.browser.type");
    }

    private Map.Entry<String, String> _getBrowserVersionEntry() {
        return this.getEnvironmentVariableEntry("BROWSER_VERSION", "environment.browser.version");
    }

    private Map.Entry<String, String> _getDatabaseTypeEntry() {
        return this.getEnvironmentVariableEntry("DATABASE_TYPE", "environment.database.type");
    }

    private Map.Entry<String, String> _getDatabaseVersionEntry() {
        return this.getEnvironmentVariableEntry("DATABASE_VERSION", "environment.database.version");
    }

    private Map.Entry<String, String> _getFixPackURLEntry() {
        Job job = this.getJob();
        if (!(job instanceof PortalFixpackEnvironmentJob)) {
            return null;
        }
        String fixPackZipURL = System.getenv("TEST_BUILD_FIX_PACK_ZIP_URL");
        if (fixPackZipURL == null || !fixPackZipURL.matches("https?://.*")) {
            fixPackZipURL = this.getBuildStartProperty("TEST_BUILD_FIX_PACK_ZIP_URL");
        }
        if (fixPackZipURL == null || !fixPackZipURL.matches("https?://.*")) {
            return null;
        }
        return new AbstractMap.SimpleEntry<String, String>("TEST_BUILD_FIX_PACK_ZIP_URL", fixPackZipURL);
    }

    private Map.Entry<String, String> _getJavaJDKArchitectureEntry() {
        return this.getEnvironmentVariableEntry("JAVA_JDK_ARCHITECTURE", "environment.java.jdk.architecture");
    }

    private Map.Entry<String, String> _getJavaJDKTypeEntry() {
        return this.getEnvironmentVariableEntry("JAVA_JDK_TYPE", "environment.java.jdk.type");
    }

    private Map.Entry<String, String> _getJavaJDKVersionEntry() {
        return this.getEnvironmentVariableEntry("JAVA_JDK_VERSION", "environment.java.jdk.version");
    }

    private Map.Entry<String, String> _getOperatingSystemTypeEntry() {
        return this.getEnvironmentVariableEntry("OPERATING_SYSTEM_TYPE", "environment.operating.system.type");
    }

    private Map.Entry<String, String> _getOperatingSystemVersionEntry() {
        return this.getEnvironmentVariableEntry("OPERATING_SYSTEM_VERSION", "environment.operating.system.version");
    }

    private Map.Entry<String, String> _getTestrayBuildNameEntry() {
        Job job = this.getJob();
        if (!(job instanceof PortalFixpackEnvironmentJob)) {
            return null;
        }
        String testrayBuildName = System.getenv("TESTRAY_BUILD_NAME");
        if (JenkinsResultsParserUtil.isNullOrEmpty(testrayBuildName)) {
            testrayBuildName = this.getBuildStartProperty("TESTRAY_BUILD_NAME");
        }
        if (JenkinsResultsParserUtil.isNullOrEmpty(testrayBuildName)) {
            return null;
        }
        return new AbstractMap.SimpleEntry<String, String>("TESTRAY_BUILD_NAME", testrayBuildName);
    }
}

