/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser.test.clazz.group;

import com.liferay.jenkins.results.parser.AntException;
import com.liferay.jenkins.results.parser.AntUtil;
import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.PortalGitWorkingDirectory;
import com.liferay.jenkins.results.parser.PortalHotfixReleaseJob;
import com.liferay.jenkins.results.parser.PortalTestClassJob;
import com.liferay.jenkins.results.parser.job.property.JobProperty;
import com.liferay.jenkins.results.parser.test.batch.PoshiTestBatch;
import com.liferay.jenkins.results.parser.test.batch.PoshiTestSelector;
import com.liferay.jenkins.results.parser.test.clazz.FunctionalTestClassBalancedListSplitter;
import com.liferay.jenkins.results.parser.test.clazz.TestClass;
import com.liferay.jenkins.results.parser.test.clazz.TestClassFactory;
import com.liferay.jenkins.results.parser.test.clazz.group.AxisTestClassGroup;
import com.liferay.jenkins.results.parser.test.clazz.group.BatchTestClassGroup;
import com.liferay.jenkins.results.parser.test.clazz.group.TestClassGroupFactory;
import com.liferay.poshi.core.PoshiContext;
import com.liferay.poshi.core.util.PropsUtil;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.json.JSONObject;

public class FunctionalBatchTestClassGroup
extends BatchTestClassGroup {
    private static List<File> _modifiedFiles;
    private static final Pattern _poshiTestCasePattern;
    private static final AtomicReference<File> _testBaseDirAtomicReference;
    private static final Pattern _upgradeFileNamePattern;
    private final Map<File, String> _testBatchRunPropertyQueries = new HashMap<File, String>();
    private final Set<File> _traversedPropertyFiles = new HashSet<File>();
    private final Set<File> _traversedUpgradeFiles = new HashSet<File>();

    @Override
    public int getAxisCount() {
        if (this.ignore()) {
            return 0;
        }
        return this.axisTestClassGroups.size();
    }

    @Override
    public JSONObject getJSONObject() {
        if (this.jsonObject != null) {
            return this.jsonObject;
        }
        this.jsonObject = super.getJSONObject();
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append(this.getTestBatchRunPropertyQuery());
        sb.append(") AND (ignored == null)");
        String testRunEnvironment = PropsUtil.get((String)"test.run.environment");
        if (!JenkinsResultsParserUtil.isNullOrEmpty(testRunEnvironment)) {
            sb.append(" AND (test.run.environment == \"");
            sb.append(testRunEnvironment);
            sb.append("\" OR test.run.environment == null)");
        }
        this.jsonObject.put("pql_query", (Object)sb.toString());
        this.jsonObject.put("target_duration", this.getTargetAxisDuration());
        this.jsonObject.put("test_batch_run_property_queries", this._testBatchRunPropertyQueries);
        return this.jsonObject;
    }

    public List<File> getTestBaseDirs() {
        String testBaseDirPath = this._getTestBaseDirPath();
        if (!JenkinsResultsParserUtil.isNullOrEmpty(testBaseDirPath)) {
            return Arrays.asList(new File(testBaseDirPath));
        }
        return Arrays.asList(new File(this.portalGitWorkingDirectory.getWorkingDirectory(), "portal-web/test/functional/portalweb"));
    }

    public String getTestBatchRunPropertyQuery() {
        List<File> testBaseDirs = this.getTestBaseDirs();
        if (testBaseDirs.isEmpty()) {
            return null;
        }
        return this.getTestBatchRunPropertyQuery(testBaseDirs.get(0));
    }

    public String getTestBatchRunPropertyQuery(File testBaseDir) {
        return this._testBatchRunPropertyQueries.get(testBaseDir);
    }

    @Override
    public List<TestClass> getTestClasses() {
        ArrayList<TestClass> testClasses = new ArrayList<TestClass>();
        for (AxisTestClassGroup axisTestClassGroup : this.axisTestClassGroups) {
            testClasses.addAll(axisTestClassGroup.getTestClasses());
        }
        return testClasses;
    }

    public String getWorkspaceName() {
        JobProperty jobProperty = this.getJobProperty("test.workspace.name", this.testSuiteName, this.batchName);
        if (jobProperty == null || JenkinsResultsParserUtil.isNullOrEmpty(jobProperty.getValue())) {
            return null;
        }
        this.recordJobProperty(jobProperty);
        return jobProperty.getValue();
    }

    public boolean isUpgradeFile(File file) {
        Matcher matcher = _upgradeFileNamePattern.matcher(file.toString());
        return matcher.find();
    }

    protected FunctionalBatchTestClassGroup(JSONObject jsonObject, PortalTestClassJob portalTestClassJob) {
        super(jsonObject, portalTestClassJob);
        JSONObject testBatchRunPropertyQueriesJSONObject = jsonObject.optJSONObject("test_batch_run_property_queries");
        if (testBatchRunPropertyQueriesJSONObject == null) {
            return;
        }
        for (String key : testBatchRunPropertyQueriesJSONObject.keySet()) {
            this._testBatchRunPropertyQueries.put(new File(key), testBatchRunPropertyQueriesJSONObject.getString(key));
        }
    }

    protected FunctionalBatchTestClassGroup(String batchName, PortalTestClassJob portalTestClassJob) {
        super(batchName, portalTestClassJob);
        if (this.ignore()) {
            return;
        }
        this._setTestBatchRunPropertyQueries();
        this.setAxisTestClassGroups();
        this.setSegmentTestClassGroups();
    }

    protected FunctionalBatchTestClassGroup(String batchName, PortalTestClassJob portalTestClassJob, PoshiTestBatch poshiTestBatch) {
        super(batchName, portalTestClassJob);
        if (this.ignore()) {
            return;
        }
        this._setTestBatchRunPropertyQueries((PoshiTestSelector)poshiTestBatch.getTestSelector());
        this.setAxisTestClassGroups();
        this.setSegmentTestClassGroups();
    }

    @Override
    protected int getAxisMaxSize() {
        long targetAxisDuration = this.getTargetAxisDuration();
        if (targetAxisDuration > 0L) {
            return 5000;
        }
        return super.getAxisMaxSize();
    }

    protected String getDefaultTestBatchRunPropertyQuery(File testBaseDir, String testSuiteName) {
        String query = System.getenv("TEST_BATCH_RUN_PROPERTY_QUERY");
        if (JenkinsResultsParserUtil.isNullOrEmpty(query)) {
            query = this.getBuildStartProperty("TEST_BATCH_RUN_PROPERTY_QUERY");
        }
        if (!JenkinsResultsParserUtil.isNullOrEmpty(query)) {
            return query;
        }
        JobProperty jobProperty = this.getJobProperty("test.batch.run.property.query", testSuiteName, this.batchName);
        File testPropertiesFile = new File(this.portalGitWorkingDirectory.getWorkingDirectory(), "test.properties");
        JenkinsResultsParserUtil.validatePQL(jobProperty.getValue(), testPropertiesFile);
        this.recordJobProperty(jobProperty);
        return jobProperty.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<File> getModifiedFiles() {
        Pattern pattern = _poshiTestCasePattern;
        synchronized (pattern) {
            if (_modifiedFiles != null) {
                return _modifiedFiles;
            }
            _modifiedFiles = new ArrayList<File>();
            if (this.portalTestClassJob instanceof PortalHotfixReleaseJob) {
                PortalHotfixReleaseJob portalHotfixReleaseJob = (PortalHotfixReleaseJob)this.portalTestClassJob;
                _modifiedFiles = portalHotfixReleaseJob.getModifiedFiles();
            } else {
                _modifiedFiles = this.portalGitWorkingDirectory.getModifiedFilesList();
            }
            return _modifiedFiles;
        }
    }

    protected List<List<TestClass>> getPoshiTestClassGroups(File testBaseDir) {
        String query = this.getTestBatchRunPropertyQuery(testBaseDir);
        if (JenkinsResultsParserUtil.isNullOrEmpty(query)) {
            return new ArrayList<List<TestClass>>();
        }
        Pattern pattern = _poshiTestCasePattern;
        synchronized (pattern) {
            File cachedTestBaseDir = _testBaseDirAtomicReference.get();
            if (cachedTestBaseDir == null || !cachedTestBaseDir.equals(testBaseDir)) {
                PortalGitWorkingDirectory portalGitWorkingDirectory = this.portalTestClassJob.getPortalGitWorkingDirectory();
                File portalWorkingDirectory = portalGitWorkingDirectory.getWorkingDirectory();
                HashMap<String, String> parameters = new HashMap<String, String>();
                String testBaseDirPath = null;
                if (testBaseDir != null && testBaseDir.exists()) {
                    testBaseDirPath = JenkinsResultsParserUtil.getCanonicalPath(testBaseDir);
                    parameters.put("test.base.dir.name", testBaseDirPath);
                }
                try {
                    AntUtil.callTarget(portalWorkingDirectory, "build-test.xml", "prepare-poshi-runner-properties", parameters);
                }
                catch (AntException antException) {
                    throw new RuntimeException(antException);
                }
                Properties properties = JenkinsResultsParserUtil.getProperties(new File(portalWorkingDirectory, "portal-web/poshi.properties"), new File(portalWorkingDirectory, "portal-web/poshi-ext.properties"));
                File poshiPropertiesFile = new File(testBaseDirPath, "poshi.properties");
                if (poshiPropertiesFile.exists()) {
                    properties = JenkinsResultsParserUtil.getProperties(poshiPropertiesFile, new File(testBaseDirPath, "poshi-ext.properties"));
                }
                if (!JenkinsResultsParserUtil.isNullOrEmpty(testBaseDirPath)) {
                    properties.setProperty("test.base.dir.name", testBaseDirPath);
                }
                properties.setProperty("poshi.file.read.thread.pool", "4");
                properties.setProperty("poshi.file.read.timeout", "30");
                PropsUtil.clear();
                PropsUtil.setProperties((Properties)properties);
                try {
                    PoshiContext.clear();
                    PoshiContext.readFiles();
                }
                catch (Exception exception) {
                    throw new RuntimeException(exception);
                }
                _testBaseDirAtomicReference.set(testBaseDir);
            }
            try {
                return this.getTestClassGroups(PoshiContext.getTestBatchGroups((String)query, (long)this.getAxisMaxSize()));
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }
    }

    protected List<List<TestClass>> getTestClassGroups(List<List<String>> testBatchGroups) {
        ArrayList<List<TestClass>> testClassGroups = new ArrayList<List<TestClass>>();
        if (testBatchGroups.isEmpty()) {
            return testClassGroups;
        }
        for (List<String> testBatchGroup : testBatchGroups) {
            ArrayList<TestClass> testClassGroup = new ArrayList<TestClass>();
            for (String testClassMethodName : testBatchGroup) {
                testClassGroup.add(TestClassFactory.newTestClass((BatchTestClassGroup)this, testClassMethodName));
            }
            testClassGroups.add(testClassGroup);
        }
        return testClassGroups;
    }

    @Override
    protected void setAxisTestClassGroups() {
        if (!this.axisTestClassGroups.isEmpty()) {
            return;
        }
        for (File testBaseDir : this.getTestBaseDirs()) {
            String query = this.getTestBatchRunPropertyQuery(testBaseDir);
            if (query == null) continue;
            List<List<TestClass>> poshiTestClassGroups = this.getPoshiTestClassGroups(testBaseDir);
            long targetAxisDuration = this.getTargetAxisDuration();
            for (List<TestClass> poshiTestClassGroup : poshiTestClassGroups) {
                if (poshiTestClassGroup.isEmpty()) continue;
                if (targetAxisDuration > 0L) {
                    FunctionalTestClassBalancedListSplitter functionalTestClassBalancedListSplitter = new FunctionalTestClassBalancedListSplitter(targetAxisDuration);
                    List<List<TestClass>> testClassLists = functionalTestClassBalancedListSplitter.split(poshiTestClassGroup);
                    for (List<TestClass> testClassList : testClassLists) {
                        AxisTestClassGroup axisTestClassGroup = TestClassGroupFactory.newAxisTestClassGroup(this, testBaseDir);
                        axisTestClassGroup.addTestClasses(testClassList);
                        this.axisTestClassGroups.add(axisTestClassGroup);
                    }
                    continue;
                }
                AxisTestClassGroup axisTestClassGroup = TestClassGroupFactory.newAxisTestClassGroup(this, testBaseDir);
                for (TestClass testClass : poshiTestClassGroup) {
                    axisTestClassGroup.addTestClass(testClass);
                }
                this.axisTestClassGroups.add(axisTestClassGroup);
            }
        }
    }

    private String _concatPQL(File file, String testSuiteName, String concatedPQL) {
        Properties testProperties;
        boolean ignoreParents;
        if (file == null) {
            return null;
        }
        if (JenkinsResultsParserUtil.isPoshiFile(file)) {
            return "";
        }
        File canonicalFile = JenkinsResultsParserUtil.getCanonicalFile(file);
        if (canonicalFile.equals(this.portalGitWorkingDirectory.getWorkingDirectory())) {
            return concatedPQL;
        }
        File parentFile = canonicalFile.getParentFile();
        if (parentFile == null || !parentFile.exists()) {
            return "";
        }
        File modulesBaseDir = new File(this.portalGitWorkingDirectory.getWorkingDirectory(), "modules");
        Path modulesBaseDirPath = modulesBaseDir.toPath();
        Path parentFilePath = parentFile.toPath();
        File testPropertiesFile = new File(canonicalFile, "test.properties");
        if (modulesBaseDirPath.equals(parentFilePath) && !testPropertiesFile.exists()) {
            return concatedPQL;
        }
        if (!canonicalFile.isDirectory() || !testPropertiesFile.exists()) {
            return this._concatPQL(parentFile, testSuiteName, concatedPQL);
        }
        if (this._traversedPropertyFiles.contains(testPropertiesFile) && testSuiteName.equals("relevant") || this._traversedUpgradeFiles.contains(testPropertiesFile)) {
            return concatedPQL;
        }
        if (testSuiteName.equals("upgrades-relevant") && !this._traversedUpgradeFiles.contains(testPropertiesFile)) {
            this._traversedUpgradeFiles.add(testPropertiesFile);
        }
        this._traversedPropertyFiles.add(testPropertiesFile);
        JobProperty jobProperty = this.getJobProperty("test.batch.run.property.query", testSuiteName, this.batchName, canonicalFile, JobProperty.Type.MODULE_TEST_DIR);
        String testBatchPropertyQuery = jobProperty.getValue();
        if (!(JenkinsResultsParserUtil.isNullOrEmpty(testBatchPropertyQuery) || testBatchPropertyQuery.equals("false") || concatedPQL.contains(testBatchPropertyQuery))) {
            JenkinsResultsParserUtil.validatePQL(testBatchPropertyQuery, testPropertiesFile);
            this.recordJobProperty(jobProperty);
            concatedPQL = !concatedPQL.isEmpty() ? concatedPQL + JenkinsResultsParserUtil.combine(" OR (", testBatchPropertyQuery, ")") : concatedPQL + testBatchPropertyQuery;
        }
        if ((ignoreParents = Boolean.valueOf(JenkinsResultsParserUtil.getProperty(testProperties = JenkinsResultsParserUtil.getProperties(testPropertiesFile), "ignoreParents", false, testSuiteName)).booleanValue()) || parentFile.equals(this.portalGitWorkingDirectory.getWorkingDirectory())) {
            return concatedPQL;
        }
        if (!parentFilePath.equals(modulesBaseDirPath)) {
            return this._concatPQL(parentFile, testSuiteName, concatedPQL);
        }
        return concatedPQL;
    }

    private String _getTestBaseDirPath() {
        JobProperty jobProperty = this.getJobProperty("test.base.dir", this.testSuiteName, this.batchName);
        if (jobProperty == null || JenkinsResultsParserUtil.isNullOrEmpty(jobProperty.getValue())) {
            String workspaceName = this.getWorkspaceName();
            if (JenkinsResultsParserUtil.isNullOrEmpty(workspaceName)) {
                return null;
            }
            File testBaseDir = new File(this.portalGitWorkingDirectory.getWorkingDirectory(), JenkinsResultsParserUtil.combine("workspaces/", workspaceName, "/poshi"));
            if (!testBaseDir.exists()) {
                return null;
            }
            return JenkinsResultsParserUtil.getCanonicalPath(testBaseDir);
        }
        File testBaseDir = new File(this.portalGitWorkingDirectory.getWorkingDirectory(), jobProperty.getValue());
        if (!testBaseDir.exists()) {
            return null;
        }
        this.recordJobProperty(jobProperty);
        return JenkinsResultsParserUtil.getCanonicalPath(testBaseDir);
    }

    private String _getTestBatchRunPropertyQuery(File testBaseDir) {
        JobProperty jobProperty;
        String jobPropertyValue;
        if (!this.testRelevantChanges && !this.testHotfixChanges) {
            String defaultPQL = this.getDefaultTestBatchRunPropertyQuery(testBaseDir, this.testSuiteName);
            JobProperty globalJobProperty = this.getJobProperty("test.batch.run.property.global.query", this.testSuiteName, this.batchName);
            String globalJobPropertyValue = globalJobProperty.getValue();
            if (!JenkinsResultsParserUtil.isNullOrEmpty(globalJobPropertyValue)) {
                JenkinsResultsParserUtil.validatePQL(globalJobPropertyValue, testBaseDir);
                this.recordJobProperty(globalJobProperty);
                return JenkinsResultsParserUtil.combine("(", globalJobPropertyValue, ") AND (", defaultPQL, ")");
            }
            return defaultPQL;
        }
        File testPropertiesFile = new File(this.portalGitWorkingDirectory.getWorkingDirectory(), "test.properties");
        StringBuilder sb = new StringBuilder();
        for (File modifiedFile : this.getModifiedFiles()) {
            String upgradePQL;
            String testBatchPQL = this._concatPQL(modifiedFile, this.getTestSuiteName(), "");
            if (JenkinsResultsParserUtil.isNullOrEmpty(testBatchPQL) || testBatchPQL.equals("false")) continue;
            if (sb.indexOf(testBatchPQL) == -1) {
                if (!JenkinsResultsParserUtil.isNullOrEmpty(sb.toString())) {
                    sb.append(" OR ");
                }
                sb.append("(");
                sb.append(testBatchPQL);
                sb.append(")");
            }
            if (!this.isUpgradeFile(modifiedFile) || JenkinsResultsParserUtil.isNullOrEmpty(upgradePQL = this._concatPQL(modifiedFile, "upgrades-relevant", ""))) continue;
            if (sb.length() > 0) {
                sb.append(" OR ");
            }
            sb.append("(");
            sb.append(upgradePQL);
            sb.append(")");
        }
        String defaultPQL = this.getDefaultTestBatchRunPropertyQuery(testBaseDir, this.testSuiteName);
        if (!JenkinsResultsParserUtil.isNullOrEmpty(defaultPQL) && sb.indexOf(defaultPQL) == -1) {
            JenkinsResultsParserUtil.validatePQL(defaultPQL, testBaseDir);
            if (sb.length() > 0) {
                sb.append(" OR ");
            }
            sb.append("(");
            sb.append(defaultPQL);
            sb.append(")");
        }
        if (!"stable".equals(this.getTestSuiteName())) {
            String batchName = this.getBatchName();
            if (!batchName.endsWith("_stable")) {
                batchName = batchName + "_stable";
            }
            if ((jobPropertyValue = (jobProperty = this.getJobProperty("test.batch.run.property.query", "stable", batchName)).getValue()) != null && this.includeStableTestSuite && this.isStableTestSuiteBatch(batchName) && sb.indexOf(jobPropertyValue) == -1) {
                JenkinsResultsParserUtil.validatePQL(jobPropertyValue, testPropertiesFile);
                this.recordJobProperty(jobProperty);
                if (sb.length() > 0) {
                    sb.append(" OR ");
                }
                sb.append("(");
                sb.append(jobPropertyValue);
                sb.append(")");
            }
        }
        String testBatchRunPropertyQuery = sb.toString();
        jobProperty = this.getJobProperty("test.batch.run.property.global.query", this.testSuiteName, this.batchName);
        jobPropertyValue = jobProperty.getValue();
        if (jobPropertyValue != null) {
            JenkinsResultsParserUtil.validatePQL(jobPropertyValue, testPropertiesFile);
            this.recordJobProperty(jobProperty);
            testBatchRunPropertyQuery = JenkinsResultsParserUtil.combine("(", jobPropertyValue, ") AND (", testBatchRunPropertyQuery, ")");
        }
        return testBatchRunPropertyQuery;
    }

    private void _setTestBatchRunPropertyQueries() {
        if (this.isRootCauseAnalysis()) {
            String portalBatchTestSelector = System.getenv("PORTAL_BATCH_TEST_SELECTOR");
            if (JenkinsResultsParserUtil.isNullOrEmpty(portalBatchTestSelector)) {
                portalBatchTestSelector = this.getBuildStartProperty("PORTAL_BATCH_TEST_SELECTOR");
            }
            if (portalBatchTestSelector != null && portalBatchTestSelector.startsWith("LocalFile.")) {
                portalBatchTestSelector = portalBatchTestSelector.replace("LocalFile.", "");
            }
            this._testBatchRunPropertyQueries.put(new File(this.portalGitWorkingDirectory.getWorkingDirectory(), "portal-web/test/functional/portalweb"), "test.class.method.name == " + portalBatchTestSelector);
            return;
        }
        for (File testBaseDir : this.getTestBaseDirs()) {
            String testBatchRunPropertyQuery = this._getTestBatchRunPropertyQuery(testBaseDir);
            if (JenkinsResultsParserUtil.isNullOrEmpty(testBatchRunPropertyQuery)) continue;
            this._testBatchRunPropertyQueries.put(testBaseDir, testBatchRunPropertyQuery);
        }
    }

    private void _setTestBatchRunPropertyQueries(PoshiTestSelector poshiTestSelector) {
        this.recordJobProperties(poshiTestSelector.getPoshiJobProperties());
        PortalGitWorkingDirectory portalGitWorkingDirectory = this.portalTestClassJob.getPortalGitWorkingDirectory();
        this._testBatchRunPropertyQueries.put(new File(portalGitWorkingDirectory.getWorkingDirectory(), "portal-web/test/functional/portalweb"), poshiTestSelector.getPoshiQuery());
    }

    static {
        _poshiTestCasePattern = Pattern.compile("(?<namespace>[^\\.]+)\\.(?<className>[^\\#]+)\\#(?<methodName>.*)");
        _testBaseDirAtomicReference = new AtomicReference();
        _upgradeFileNamePattern = Pattern.compile("(.*\\/verify\\/.*|.*\\/upgrade\\/.*|.*\\.sql)");
    }
}

