/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser.test.clazz.group;

import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.Job;
import com.liferay.jenkins.results.parser.PortalWorkspaceJob;
import com.liferay.jenkins.results.parser.job.property.JobProperty;
import com.liferay.jenkins.results.parser.test.clazz.group.AxisTestClassGroup;
import com.liferay.jenkins.results.parser.test.clazz.group.BatchTestClassGroup;
import com.liferay.jenkins.results.parser.test.clazz.group.FunctionalAxisTestClassGroup;
import com.liferay.jenkins.results.parser.test.clazz.group.FunctionalBatchTestClassGroup;
import com.liferay.jenkins.results.parser.test.clazz.group.SegmentTestClassGroup;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.json.JSONObject;

public class FunctionalSegmentTestClassGroup
extends SegmentTestClassGroup {
    private final BatchTestClassGroup _batchTestClassGroup;
    private Boolean _testAnalyticsCloud;

    public FunctionalAxisTestClassGroup getFunctionalAxisTestClassGroup(int segmentIndex) {
        List<FunctionalAxisTestClassGroup> functionalAxisTestClassGroups = this.getFunctionalAxisTestClassGroups();
        return functionalAxisTestClassGroups.get(segmentIndex);
    }

    public List<FunctionalAxisTestClassGroup> getFunctionalAxisTestClassGroups() {
        ArrayList<FunctionalAxisTestClassGroup> functionalAxisTestClassGroups = new ArrayList<FunctionalAxisTestClassGroup>();
        for (AxisTestClassGroup axisTestClassGroup : this.getAxisTestClassGroups()) {
            if (!(axisTestClassGroup instanceof FunctionalAxisTestClassGroup)) continue;
            FunctionalAxisTestClassGroup functionalAxisTestClassGroup = (FunctionalAxisTestClassGroup)axisTestClassGroup;
            functionalAxisTestClassGroups.add(functionalAxisTestClassGroup);
        }
        return functionalAxisTestClassGroups;
    }

    @Override
    public Integer getMinimumSlaveRAM() {
        Properties poshiProperties = this.getPoshiProperties();
        String minimumSlaveRAM = poshiProperties.getProperty("minimum.slave.ram");
        if (minimumSlaveRAM != null && minimumSlaveRAM.matches("\\d+")) {
            return Integer.valueOf(minimumSlaveRAM);
        }
        return super.getMinimumSlaveRAM();
    }

    public Properties getPoshiProperties() {
        List<FunctionalAxisTestClassGroup> functionalAxisTestClassGroups = this.getFunctionalAxisTestClassGroups();
        FunctionalAxisTestClassGroup functionalAxisTestClassGroup = functionalAxisTestClassGroups.get(0);
        return functionalAxisTestClassGroup.getPoshiProperties();
    }

    @Override
    public String getSlaveLabel() {
        Properties poshiProperties = this.getPoshiProperties();
        String slaveLabel = poshiProperties.getProperty("slave.label");
        if (!JenkinsResultsParserUtil.isNullOrEmpty(slaveLabel)) {
            return slaveLabel;
        }
        return super.getSlaveLabel();
    }

    @Override
    public String getTestCasePropertiesContent() {
        String workspaceName;
        StringBuilder sb = new StringBuilder();
        sb.append(super.getTestCasePropertiesContent());
        ArrayList<String> axisGroupNames = new ArrayList<String>();
        int batchIndex = this.getBatchIndex();
        for (int axisIndex = 0; axisIndex < this.getAxisCount(); ++axisIndex) {
            axisGroupNames.add(batchIndex + "_" + axisIndex);
            sb.append("RUN_TEST_CASE_METHOD_GROUP_");
            sb.append(batchIndex);
            sb.append("_");
            sb.append(axisIndex);
            sb.append("=");
            FunctionalAxisTestClassGroup functionalAxisTestClassGroup = this.getFunctionalAxisTestClassGroup(axisIndex);
            sb.append(JenkinsResultsParserUtil.join(",", functionalAxisTestClassGroup.getTestClassMethodNames()));
            sb.append("\n");
        }
        sb.append("RUN_TEST_CASE_METHOD_GROUP_");
        sb.append(batchIndex);
        sb.append("=");
        sb.append(JenkinsResultsParserUtil.join(" ", axisGroupNames));
        sb.append("\n");
        String workspacePortalVersion = this._getWorkspacePortalVersion();
        if (!JenkinsResultsParserUtil.isNullOrEmpty(workspacePortalVersion)) {
            sb.append("TEST_PORTAL_BUNDLE_VERSION=");
            sb.append(workspacePortalVersion);
            sb.append("\n");
        }
        if (!JenkinsResultsParserUtil.isNullOrEmpty(workspaceName = this._getWorkspaceName())) {
            sb.append("TEST_WORKSPACE_NAME=");
            sb.append(workspaceName);
            sb.append("\n");
        }
        return sb.toString();
    }

    @Override
    public boolean testAnalyticsCloud() {
        if (this._testAnalyticsCloud != null) {
            return this._testAnalyticsCloud;
        }
        Properties poshiProperties = this.getPoshiProperties();
        String analyticsCloudEnabled = poshiProperties.getProperty("analytics.cloud.enabled");
        if (analyticsCloudEnabled != null && analyticsCloudEnabled.equals("true")) {
            this._testAnalyticsCloud = true;
            return this._testAnalyticsCloud;
        }
        this._testAnalyticsCloud = false;
        return this._testAnalyticsCloud;
    }

    protected FunctionalSegmentTestClassGroup(BatchTestClassGroup batchTestClassGroup) {
        super(batchTestClassGroup);
        this._batchTestClassGroup = batchTestClassGroup;
    }

    protected FunctionalSegmentTestClassGroup(BatchTestClassGroup batchTestClassGroup, JSONObject jsonObject) {
        super(batchTestClassGroup, jsonObject);
        this._batchTestClassGroup = batchTestClassGroup;
    }

    protected Map.Entry<String, String> getEnvironmentVariableEntry(String key, String name) {
        if (JenkinsResultsParserUtil.isNullOrEmpty(key) || JenkinsResultsParserUtil.isNullOrEmpty(name)) {
            return null;
        }
        JobProperty jobProperty = this._batchTestClassGroup.getJobProperty(name);
        String value = jobProperty.getValue();
        if (JenkinsResultsParserUtil.isNullOrEmpty(value)) {
            return null;
        }
        return new AbstractMap.SimpleEntry<String, String>(key, value);
    }

    private String _getWorkspaceName() {
        BatchTestClassGroup batchTestClassGroup = this.getBatchTestClassGroup();
        if (!(batchTestClassGroup instanceof FunctionalBatchTestClassGroup)) {
            return null;
        }
        FunctionalBatchTestClassGroup functionalBatchTestClassGroup = (FunctionalBatchTestClassGroup)batchTestClassGroup;
        return functionalBatchTestClassGroup.getWorkspaceName();
    }

    private String _getWorkspacePortalVersion() {
        String batchName = this.getBatchName();
        if (!batchName.startsWith("functional-workspaces-")) {
            return null;
        }
        Job job = this.getJob();
        if (!(job instanceof PortalWorkspaceJob)) {
            return null;
        }
        PortalWorkspaceJob portalWorkspaceJob = (PortalWorkspaceJob)((Object)job);
        return portalWorkspaceJob.getWorkspacePortalVersion();
    }
}

