/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser.test.clazz.group;

import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.PortalGitWorkingDirectory;
import com.liferay.jenkins.results.parser.PortalTestClassJob;
import com.liferay.jenkins.results.parser.job.property.JobProperty;
import com.liferay.jenkins.results.parser.test.clazz.TestClass;
import com.liferay.jenkins.results.parser.test.clazz.TestClassFactory;
import com.liferay.jenkins.results.parser.test.clazz.group.AxisTestClassGroup;
import com.liferay.jenkins.results.parser.test.clazz.group.BaseTestClassGroup;
import com.liferay.jenkins.results.parser.test.clazz.group.BatchTestClassGroup;
import com.liferay.jenkins.results.parser.test.clazz.group.ModulesBatchTestClassGroup;
import com.liferay.jenkins.results.parser.test.clazz.group.TestClassGroupFactory;
import java.io.File;
import java.io.IOException;
import java.nio.file.PathMatcher;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.json.JSONObject;

public class JSUnitModulesBatchTestClassGroup
extends ModulesBatchTestClassGroup {
    public boolean testGitrepoJSUnit() {
        JobProperty jobProperty = this.getJobProperty("test.gitrepo.js.unit");
        String jobPropertyValue = jobProperty.getValue();
        if (!JenkinsResultsParserUtil.isNullOrEmpty(jobPropertyValue) && jobPropertyValue.equals("true")) {
            this.recordJobProperty(jobProperty);
            return true;
        }
        return false;
    }

    protected JSUnitModulesBatchTestClassGroup(JSONObject jsonObject, PortalTestClassJob portalTestClassJob) {
        super(jsonObject, portalTestClassJob);
    }

    protected JSUnitModulesBatchTestClassGroup(String batchName, PortalTestClassJob portalTestClassJob) {
        super(batchName, portalTestClassJob);
    }

    @Override
    protected void setAxisTestClassGroups() {
        super.setAxisTestClassGroups();
        TestClass faroTestClass = null;
        BaseTestClassGroup originalAxisTestClassGroup = null;
        block0: for (AxisTestClassGroup axisTestClassGroup : this.axisTestClassGroups) {
            for (TestClass testClass : axisTestClassGroup.getTestClasses()) {
                String testClassName = testClass.getName();
                if (!testClassName.contains("modules/dxp/apps/osb/osb-faro")) continue;
                faroTestClass = testClass;
                originalAxisTestClassGroup = axisTestClassGroup;
                break block0;
            }
        }
        if (faroTestClass != null) {
            originalAxisTestClassGroup.removeTestClass(faroTestClass);
            AxisTestClassGroup faroAxisTestClassGroup = TestClassGroupFactory.newAxisTestClassGroup(this);
            faroAxisTestClassGroup.addTestClass(faroTestClass);
            this.axisTestClassGroups.add(faroAxisTestClassGroup);
        }
    }

    @Override
    protected void setTestClasses() throws IOException {
        ArrayList<File> moduleDirs = new ArrayList<File>();
        PortalGitWorkingDirectory portalGitWorkingDirectory = this.getPortalGitWorkingDirectory();
        List<PathMatcher> excludesPathMatchers = this.getPathMatchers(this.getExcludesJobProperties());
        moduleDirs.addAll(portalGitWorkingDirectory.getModuleDirsList(excludesPathMatchers, this.getIncludesPathMatchers()));
        for (File moduleDir : moduleDirs) {
            TestClass testClass = TestClassFactory.newTestClass((BatchTestClassGroup)this, moduleDir);
            if (!testClass.hasTestClassMethods()) continue;
            this.testClasses.add(testClass);
        }
        Collections.sort(this.testClasses);
    }
}

