/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser.test.clazz.group;

import com.google.common.collect.Lists;
import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.PortalAcceptancePullRequestJob;
import com.liferay.jenkins.results.parser.PortalGitWorkingDirectory;
import com.liferay.jenkins.results.parser.PortalTestClassJob;
import com.liferay.jenkins.results.parser.job.property.JobProperty;
import com.liferay.jenkins.results.parser.test.batch.JUnitTestBatch;
import com.liferay.jenkins.results.parser.test.batch.JUnitTestSelector;
import com.liferay.jenkins.results.parser.test.clazz.JUnitTestClass;
import com.liferay.jenkins.results.parser.test.clazz.JUnitTestClassBalancedListSplitter;
import com.liferay.jenkins.results.parser.test.clazz.TestClass;
import com.liferay.jenkins.results.parser.test.clazz.TestClassFactory;
import com.liferay.jenkins.results.parser.test.clazz.TestClassMethod;
import com.liferay.jenkins.results.parser.test.clazz.group.AxisTestClassGroup;
import com.liferay.jenkins.results.parser.test.clazz.group.BatchTestClassGroup;
import com.liferay.jenkins.results.parser.test.clazz.group.TestClassGroupFactory;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.json.JSONArray;
import org.json.JSONObject;

public class JUnitBatchTestClassGroup
extends BatchTestClassGroup {
    private static final String[] _IGNORABLE_DIRS = new String[]{"/.git", "/.gradle", "/.m2", "/.m2-tmp", "/build/node", "/build/tmp", "/node_modules"};
    private static final Set<String> _javaDirPathStrings = ConcurrentHashMap.newKeySet();
    private static final AtomicBoolean _javaFilesLoaded = new AtomicBoolean();
    private static final Set<File> _javaTestClassFiles = ConcurrentHashMap.newKeySet();
    private static int _searchedFileCount;
    private final List<File> _autoBalanceTestFiles = new ArrayList<File>();
    private boolean _includeAutoBalanceTests;
    private final boolean _includeUnstagedTestClassFiles;
    private JUnitTestBatch _jUnitTestBatch;

    @Override
    public int getAxisCount() {
        if (this.ignore()) {
            return 0;
        }
        int axisCount = super.getAxisCount();
        if (axisCount == 0 && this._includeAutoBalanceTests) {
            return 1;
        }
        return axisCount;
    }

    public List<JobProperty> getExcludesJobProperties() {
        if (this._jUnitTestBatch != null) {
            List<JobProperty> testBatchJobProperties = this.getTestSelectorExcludesJobProperties();
            this.recordJobProperties(testBatchJobProperties);
            return testBatchJobProperties;
        }
        ArrayList<JobProperty> excludesJobProperties = new ArrayList<JobProperty>();
        excludesJobProperties.addAll(this.getRequiredExcludesJobProperties());
        if (this.testReleaseBundle) {
            excludesJobProperties.addAll(this.getReleaseExcludesJobProperties());
        } else if (this.testRelevantChanges) {
            excludesJobProperties.addAll(this.getRelevantExcludesJobProperties());
        } else {
            excludesJobProperties.addAll(this.getDefaultExcludesJobProperties());
        }
        if (this.includeStableTestSuite && this.isStableTestSuiteBatch()) {
            excludesJobProperties.addAll(this.getStableDefaultExcludesJobProperties());
            excludesJobProperties.addAll(this.getStableRequiredExcludesJobProperties());
        }
        excludesJobProperties.removeAll(Collections.singleton(null));
        this.recordJobProperties(excludesJobProperties);
        return excludesJobProperties;
    }

    public List<JobProperty> getFilterJobProperties() {
        ArrayList<JobProperty> filterJobProperties = new ArrayList<JobProperty>();
        filterJobProperties.add(this.getJobProperty("test.batch.class.names.filter", JobProperty.Type.FILTER_GLOB));
        this.recordJobProperties(filterJobProperties);
        return filterJobProperties;
    }

    public List<JobProperty> getIncludesJobProperties() {
        if (this._jUnitTestBatch != null) {
            List<JobProperty> testBatchJobProperties = this.getTestSelectorIncludesJobProperties();
            this.recordJobProperties(testBatchJobProperties);
            return testBatchJobProperties;
        }
        ArrayList<JobProperty> includesJobProperties = new ArrayList<JobProperty>();
        includesJobProperties.addAll(this.getRequiredIncludesJobProperties());
        if (this.testReleaseBundle) {
            includesJobProperties.addAll(this.getReleaseIncludesJobProperties());
        } else if (this.testRelevantChanges) {
            includesJobProperties.addAll(this.getRelevantIncludesJobProperties());
        } else {
            includesJobProperties.addAll(this.getDefaultIncludesJobProperties());
        }
        if (this.includeStableTestSuite && this.isStableTestSuiteBatch()) {
            includesJobProperties.addAll(this.getStableDefaultIncludesJobProperties());
            includesJobProperties.addAll(this.getStableRequiredIncludesJobProperties());
        }
        includesJobProperties.removeAll(Collections.singleton(null));
        this.recordJobProperties(includesJobProperties);
        return includesJobProperties;
    }

    public File getJavaFileFromFullClassName(String fullClassName) {
        String classFileName = fullClassName.replaceAll(".*\\.([^\\.]+)", "$1") + ".java";
        String classPackageName = fullClassName.substring(0, fullClassName.lastIndexOf("."));
        String classPackagePath = classPackageName.replaceAll("\\.", "/");
        for (String javaDirPath : _javaDirPathStrings) {
            String classFilePath;
            File classFile;
            if (!javaDirPath.contains(classPackagePath) || !(classFile = new File(javaDirPath, classFileName)).exists() || !(classFilePath = classFile.getPath()).contains(classPackagePath + "/" + classFileName)) continue;
            return classFile;
        }
        return null;
    }

    @Override
    public JSONObject getJSONObject() {
        if (this.jsonObject != null) {
            return this.jsonObject;
        }
        this.jsonObject = super.getJSONObject();
        this.jsonObject.put("auto_balance_test_files", this._autoBalanceTestFiles);
        this.jsonObject.put("exclude_globs", this.getGlobs(this.getExcludesJobProperties()));
        this.jsonObject.put("filter_globs", this.getGlobs(this.getFilterJobProperties()));
        this.jsonObject.put("include_auto_balance_tests", this._includeAutoBalanceTests);
        this.jsonObject.put("include_globs", this.getGlobs(this.getIncludesJobProperties()));
        this.jsonObject.put("include_unstaged_test_class_files", this._includeUnstagedTestClassFiles);
        this.jsonObject.put("target_duration", this.getTargetAxisDuration());
        return this.jsonObject;
    }

    public void writeTestCSVReportFile() throws Exception {
        BatchTestClassGroup.CSVReport csvReport = new BatchTestClassGroup.CSVReport(new BatchTestClassGroup.CSVReport.Row("Class Name", "Method Name", "Ignored", "File Path"));
        for (JUnitTestClass jUnitTestClass : TestClassFactory.getJUnitTestClasses()) {
            File testClassFile = jUnitTestClass.getTestClassFile();
            String testClassFileRelativePath = JenkinsResultsParserUtil.getPathRelativeTo(testClassFile, this.portalGitWorkingDirectory.getWorkingDirectory());
            String className = testClassFile.getName();
            className = className.replace(".class", "");
            List<TestClassMethod> testClassMethods = jUnitTestClass.getTestClassMethods();
            for (TestClassMethod testClassMethod : testClassMethods) {
                BatchTestClassGroup.CSVReport.Row csvReportRow = new BatchTestClassGroup.CSVReport.Row();
                csvReportRow.add(className);
                csvReportRow.add(testClassMethod.getName());
                if (testClassMethod.isIgnored()) {
                    csvReportRow.add("TRUE");
                } else {
                    csvReportRow.add("");
                }
                csvReportRow.add(testClassFileRelativePath);
                csvReport.addRow(csvReportRow);
            }
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MM-dd-yyyy");
        File csvReportFile = new File(JenkinsResultsParserUtil.combine("Report_junit_", simpleDateFormat.format(new Date()), ".csv"));
        try {
            JenkinsResultsParserUtil.write(csvReportFile, csvReport.toString());
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
    }

    protected JUnitBatchTestClassGroup(JSONObject jsonObject, PortalTestClassJob portalTestClassJob) {
        super(jsonObject, portalTestClassJob);
        JSONArray autoBalanceTestFilesJSONArray = jsonObject.getJSONArray("auto_balance_test_files");
        if (autoBalanceTestFilesJSONArray != null && !autoBalanceTestFilesJSONArray.isEmpty()) {
            for (int i = 0; i < autoBalanceTestFilesJSONArray.length(); ++i) {
                String autoBalanceTestFilePath = autoBalanceTestFilesJSONArray.getString(i);
                if (JenkinsResultsParserUtil.isNullOrEmpty(autoBalanceTestFilePath)) continue;
                this._autoBalanceTestFiles.add(new File(autoBalanceTestFilePath));
            }
        }
        this._includeAutoBalanceTests = jsonObject.getBoolean("include_auto_balance_tests");
        this._includeUnstagedTestClassFiles = jsonObject.getBoolean("include_unstaged_test_class_files");
    }

    protected JUnitBatchTestClassGroup(String batchName, PortalTestClassJob portalTestClassJob) {
        super(batchName, portalTestClassJob);
        if (this.ignore()) {
            this._includeUnstagedTestClassFiles = false;
            return;
        }
        if (portalTestClassJob instanceof PortalAcceptancePullRequestJob) {
            PortalAcceptancePullRequestJob portalAcceptancePullRequestJob = (PortalAcceptancePullRequestJob)portalTestClassJob;
            this._includeUnstagedTestClassFiles = portalAcceptancePullRequestJob.isCentralMergePullRequest();
        } else {
            this._includeUnstagedTestClassFiles = false;
        }
        this._loadJavaFiles(this._getWorkingDirectory());
        this.setTestClasses();
        this._setAutoBalanceTestFiles();
        this._setIncludeAutoBalanceTests();
        this.setAxisTestClassGroups();
        this.setSegmentTestClassGroups();
    }

    protected JUnitBatchTestClassGroup(String batchName, PortalTestClassJob portalTestClassJob, JUnitTestBatch jUnitTestBatch) {
        super(batchName, portalTestClassJob);
        if (this.ignore()) {
            this._includeUnstagedTestClassFiles = false;
            return;
        }
        if (portalTestClassJob instanceof PortalAcceptancePullRequestJob) {
            PortalAcceptancePullRequestJob portalAcceptancePullRequestJob = (PortalAcceptancePullRequestJob)portalTestClassJob;
            this._includeUnstagedTestClassFiles = portalAcceptancePullRequestJob.isCentralMergePullRequest();
        } else {
            this._includeUnstagedTestClassFiles = false;
        }
        this._jUnitTestBatch = jUnitTestBatch;
        this._loadJavaFiles(this._getWorkingDirectory());
        this.setTestClasses((JUnitTestSelector)jUnitTestBatch.getTestSelector());
        this._setAutoBalanceTestFiles();
        this._setIncludeAutoBalanceTests();
        this.setAxisTestClassGroups();
        this.setSegmentTestClassGroups();
    }

    protected List<JobProperty> getDefaultExcludesJobProperties() {
        ArrayList<JobProperty> excludesJobProperties = new ArrayList<JobProperty>();
        excludesJobProperties.add(this.getJobProperty("test.batch.class.names.excludes", JobProperty.Type.EXCLUDE_GLOB));
        return excludesJobProperties;
    }

    protected List<JobProperty> getDefaultIncludesJobProperties() {
        ArrayList<JobProperty> includesJobProperties = new ArrayList<JobProperty>();
        includesJobProperties.add(this.getJobProperty("test.batch.class.names.includes", JobProperty.Type.INCLUDE_GLOB));
        return includesJobProperties;
    }

    protected List<PathMatcher> getIncludesPathMatchers() {
        if (!this.isRootCauseAnalysis()) {
            return this.getPathMatchers(this.getIncludesJobProperties());
        }
        ArrayList includeGlobs = new ArrayList();
        String portalBatchTestSelector = System.getenv("PORTAL_BATCH_TEST_SELECTOR");
        if (JenkinsResultsParserUtil.isNullOrEmpty(portalBatchTestSelector)) {
            portalBatchTestSelector = this.getBuildStartProperty("PORTAL_BATCH_TEST_SELECTOR");
        }
        if (!JenkinsResultsParserUtil.isNullOrEmpty(portalBatchTestSelector)) {
            Collections.addAll(includeGlobs, JenkinsResultsParserUtil.getGlobsFromProperty(portalBatchTestSelector));
        }
        return JenkinsResultsParserUtil.toPathMatchers(JenkinsResultsParserUtil.combine(JenkinsResultsParserUtil.getCanonicalPath(this.portalGitWorkingDirectory.getWorkingDirectory()), File.separator), includeGlobs.toArray(new String[0]));
    }

    protected List<JobProperty> getReleaseExcludesJobProperties() {
        ArrayList<JobProperty> excludesJobProperties = new ArrayList<JobProperty>();
        excludesJobProperties.addAll(this.getDefaultExcludesJobProperties());
        excludesJobProperties.add(this.getJobProperty("test.batch.class.names.excludes.release", JobProperty.Type.EXCLUDE_GLOB));
        return excludesJobProperties;
    }

    protected List<JobProperty> getReleaseIncludesJobProperties() {
        return this.getDefaultIncludesJobProperties();
    }

    protected List<JobProperty> getRelevantExcludesJobProperties() {
        ArrayList<JobProperty> excludesJobProperties = new ArrayList<JobProperty>();
        excludesJobProperties.addAll(this.getDefaultExcludesJobProperties());
        excludesJobProperties.add(this.getJobProperty("test.batch.class.names.excludes.relevant", JobProperty.Type.EXCLUDE_GLOB));
        return excludesJobProperties;
    }

    protected List<JobProperty> getRelevantIncludesJobProperties() {
        List<File> moduleDirsList = null;
        try {
            moduleDirsList = this.portalGitWorkingDirectory.getModuleDirsList();
        }
        catch (IOException ioException) {
            File workingDirectory = this.portalGitWorkingDirectory.getWorkingDirectory();
            throw new RuntimeException(JenkinsResultsParserUtil.combine("Unable to get module directories in ", workingDirectory.getPath()), ioException);
        }
        ArrayList<JobProperty> includesJobProperties = new ArrayList<JobProperty>();
        List<File> modifiedFilesList = this.portalGitWorkingDirectory.getModifiedFilesList();
        for (File modifiedFile : modifiedFilesList) {
            boolean foundModuleFile = false;
            for (File moduleDir : moduleDirsList) {
                if (!JenkinsResultsParserUtil.isFileInDirectory(moduleDir, modifiedFile)) continue;
                foundModuleFile = true;
                break;
            }
            if (foundModuleFile) continue;
            includesJobProperties.addAll(this.getDefaultIncludesJobProperties());
            break;
        }
        return includesJobProperties;
    }

    protected List<JobProperty> getRequiredExcludesJobProperties() {
        ArrayList<JobProperty> excludesJobProperties = new ArrayList<JobProperty>();
        excludesJobProperties.add(this.getJobProperty("test.batch.class.names.excludes.required", JobProperty.Type.EXCLUDE_GLOB));
        return excludesJobProperties;
    }

    protected List<JobProperty> getRequiredIncludesJobProperties() {
        ArrayList<JobProperty> includesJobProperties = new ArrayList<JobProperty>();
        includesJobProperties.add(this.getJobProperty("test.batch.class.names.includes.required", JobProperty.Type.INCLUDE_GLOB));
        return includesJobProperties;
    }

    protected List<JobProperty> getStableDefaultExcludesJobProperties() {
        ArrayList<JobProperty> excludesJobProperties = new ArrayList<JobProperty>();
        String batchName = this.getBatchName();
        if (!batchName.endsWith("_stable")) {
            batchName = batchName + "_stable";
        }
        excludesJobProperties.add(this.getJobProperty("test.batch.class.names.excludes", "stable", batchName, JobProperty.Type.EXCLUDE_GLOB));
        return excludesJobProperties;
    }

    protected List<JobProperty> getStableDefaultIncludesJobProperties() {
        ArrayList<JobProperty> includesJobProperties = new ArrayList<JobProperty>();
        String batchName = this.getBatchName();
        if (!batchName.endsWith("_stable")) {
            batchName = batchName + "_stable";
        }
        includesJobProperties.add(this.getJobProperty("test.batch.class.names.includes", "stable", batchName, JobProperty.Type.INCLUDE_GLOB));
        return includesJobProperties;
    }

    protected List<JobProperty> getStableRequiredExcludesJobProperties() {
        ArrayList<JobProperty> excludesJobProperties = new ArrayList<JobProperty>();
        String batchName = this.getBatchName();
        if (!batchName.endsWith("_stable")) {
            batchName = batchName + "_stable";
        }
        excludesJobProperties.add(this.getJobProperty("test.batch.class.names.excludes.required", "stable", batchName, JobProperty.Type.EXCLUDE_GLOB));
        return excludesJobProperties;
    }

    protected List<JobProperty> getStableRequiredIncludesJobProperties() {
        ArrayList<JobProperty> includesJobProperties = new ArrayList<JobProperty>();
        String batchName = this.getBatchName();
        if (!batchName.endsWith("_stable")) {
            batchName = batchName + "_stable";
        }
        includesJobProperties.add(this.getJobProperty("test.batch.class.names.includes.required", "stable", batchName, JobProperty.Type.INCLUDE_GLOB));
        return includesJobProperties;
    }

    protected List<JobProperty> getTestSelectorExcludesJobProperties() {
        JUnitTestSelector jUnitTestSelector = (JUnitTestSelector)this._jUnitTestBatch.getTestSelector();
        return jUnitTestSelector.getExcludesJobProperties();
    }

    protected List<JobProperty> getTestSelectorIncludesJobProperties() {
        JUnitTestSelector jUnitTestSelector = (JUnitTestSelector)this._jUnitTestBatch.getTestSelector();
        return jUnitTestSelector.getIncludesJobProperties();
    }

    @Override
    protected boolean ignore() {
        return false;
    }

    @Override
    protected void setAxisTestClassGroups() {
        long targetAxisDuration = this.getTargetAxisDuration();
        if (targetAxisDuration > 0L) {
            List<TestClass> testClasses = this.getTestClasses();
            if (testClasses.isEmpty()) {
                if (!this._includeAutoBalanceTests) {
                    return;
                }
                this.axisTestClassGroups.add(0, TestClassGroupFactory.newAxisTestClassGroup(this));
            } else {
                ArrayList<TestClass> batchTestClasses = new ArrayList<TestClass>(testClasses);
                JUnitTestClassBalancedListSplitter jUnitTestClassBalancedListSplitter = new JUnitTestClassBalancedListSplitter(targetAxisDuration);
                List<List<TestClass>> testClassLists = jUnitTestClassBalancedListSplitter.split((List<TestClass>)batchTestClasses);
                Iterator<List<TestClass>> iterator = testClassLists.iterator();
                while (iterator.hasNext()) {
                    List<TestClass> testClassList = iterator.next();
                    AxisTestClassGroup axisTestClassGroup = TestClassGroupFactory.newAxisTestClassGroup(this);
                    axisTestClassGroup.addTestClasses(testClassList);
                    this.axisTestClassGroups.add(axisTestClassGroup);
                }
            }
        } else {
            int axisCount = this.getAxisCount();
            if (axisCount == 0) {
                return;
            }
            int testClassCount = this.testClasses.size();
            if (testClassCount == 0) {
                if (!this._includeAutoBalanceTests) {
                    return;
                }
                this.axisTestClassGroups.add(0, TestClassGroupFactory.newAxisTestClassGroup(this));
            } else {
                int axisSize = (int)Math.ceil((double)testClassCount / (double)axisCount);
                for (List axisTestClasses : Lists.partition((List)this.testClasses, (int)axisSize)) {
                    AxisTestClassGroup axisTestClassGroup = TestClassGroupFactory.newAxisTestClassGroup(this);
                    for (TestClass axisTestClass : axisTestClasses) {
                        axisTestClassGroup.addTestClass(axisTestClass);
                    }
                    this.axisTestClassGroups.add(axisTestClassGroup);
                }
            }
        }
        if (!this._includeAutoBalanceTests) {
            return;
        }
        for (AxisTestClassGroup axisTestClassGroup : this.axisTestClassGroups) {
            for (File autoBalanceTestFile : this._autoBalanceTestFiles) {
                String filePath = autoBalanceTestFile.getPath();
                TestClass testClass = TestClassFactory.newTestClass((BatchTestClassGroup)this, new File(filePath = filePath.replace(".class", ".java")));
                if (!testClass.hasTestClassMethods()) continue;
                axisTestClassGroup.addTestClass(testClass);
            }
        }
    }

    protected void setTestClasses() {
        List<PathMatcher> includesPathMatchers = this.getIncludesPathMatchers();
        if (includesPathMatchers.isEmpty()) {
            return;
        }
        long start = System.currentTimeMillis();
        List<PathMatcher> filterPathMatchers = this.getPathMatchers(this.getFilterJobProperties());
        List<PathMatcher> excludesPathMatchers = this.getPathMatchers(this.getExcludesJobProperties());
        JUnitBatchTestClassGroup batchTestClassGroup = this;
        for (File javaTestClassFile : _javaTestClassFiles) {
            TestClass testClass;
            if (JenkinsResultsParserUtil.isFileExcluded(excludesPathMatchers, javaTestClassFile) || !JenkinsResultsParserUtil.isFileIncluded(excludesPathMatchers, includesPathMatchers, javaTestClassFile) || !JenkinsResultsParserUtil.isFileIncluded(null, filterPathMatchers, javaTestClassFile) || (testClass = TestClassFactory.newTestClass((BatchTestClassGroup)batchTestClassGroup, javaTestClassFile)) == null || testClass.isIgnored() || !testClass.hasTestClassMethods()) continue;
            this.testClasses.add(testClass);
        }
        long duration = System.currentTimeMillis() - start;
        System.out.println(JenkinsResultsParserUtil.combine("[", this.getBatchName(), "] Found ", String.valueOf(this.testClasses.size()), " test classes in ", JenkinsResultsParserUtil.toDurationString(duration)));
        Collections.sort(this.testClasses);
    }

    protected void setTestClasses(JUnitTestSelector jUnitTestSelector) {
        List<JobProperty> includesJobProperties = jUnitTestSelector.getIncludesJobProperties();
        this.recordJobProperties(includesJobProperties);
        List<PathMatcher> includesPathMatchers = this.getPathMatchers(includesJobProperties);
        if (includesPathMatchers.isEmpty()) {
            return;
        }
        long start = System.currentTimeMillis();
        List<PathMatcher> filterPathMatchers = this.getPathMatchers(this.getFilterJobProperties());
        List<JobProperty> excludesJobProperties = jUnitTestSelector.getExcludesJobProperties();
        List<PathMatcher> excludesPathMatchers = this.getPathMatchers(excludesJobProperties);
        this.recordJobProperties(excludesJobProperties);
        JUnitBatchTestClassGroup batchTestClassGroup = this;
        for (File javaTestClassFile : _javaTestClassFiles) {
            TestClass testClass;
            if (JenkinsResultsParserUtil.isFileExcluded(excludesPathMatchers, javaTestClassFile) || !JenkinsResultsParserUtil.isFileIncluded(excludesPathMatchers, includesPathMatchers, javaTestClassFile) || !JenkinsResultsParserUtil.isFileIncluded(null, filterPathMatchers, javaTestClassFile) || (testClass = TestClassFactory.newTestClass((BatchTestClassGroup)batchTestClassGroup, javaTestClassFile)) == null || testClass.isIgnored() || !testClass.hasTestClassMethods()) continue;
            this.testClasses.add(testClass);
        }
        long duration = System.currentTimeMillis() - start;
        System.out.println(JenkinsResultsParserUtil.combine("[", this.getBatchName(), "] Found ", String.valueOf(this.testClasses.size()), " test classes in ", JenkinsResultsParserUtil.toDurationString(duration)));
        Collections.sort(this.testClasses);
    }

    private File _getWorkingDirectory() {
        PortalGitWorkingDirectory portalGitWorkingDirectory = this.getPortalGitWorkingDirectory();
        File workingDirectory = portalGitWorkingDirectory.getWorkingDirectory();
        JobProperty jobProperty = this.getJobProperty("git.working.directory");
        String jobPropertyValue = jobProperty.getValue();
        if (!JenkinsResultsParserUtil.isNullOrEmpty(jobPropertyValue)) {
            workingDirectory = new File(jobPropertyValue);
        }
        return workingDirectory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _loadJavaFiles(File workingDirectory) {
        AtomicBoolean atomicBoolean = _javaFilesLoaded;
        synchronized (atomicBoolean) {
            if (_javaFilesLoaded.get()) {
                return;
            }
            long start = System.currentTimeMillis();
            try {
                Files.walkFileTree(workingDirectory.toPath(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult preVisitDirectory(Path filePath, BasicFileAttributes basicFileAttributes) {
                        String filePathString = filePath.toString();
                        for (String ignorableDir : _IGNORABLE_DIRS) {
                            if (!filePathString.endsWith(ignorableDir)) continue;
                            return FileVisitResult.SKIP_SUBTREE;
                        }
                        return FileVisitResult.CONTINUE;
                    }

                    @Override
                    public FileVisitResult visitFile(Path path, BasicFileAttributes basicFileAttributes) {
                        _searchedFileCount++;
                        String pathString = path.toString();
                        if (pathString.endsWith(".java")) {
                            Path parentPath = path.getParent();
                            _javaDirPathStrings.add(parentPath.toString());
                        }
                        if (pathString.endsWith("Test.java") || pathString.endsWith("TestCase.java")) {
                            _javaTestClassFiles.add(path.toFile());
                            return FileVisitResult.CONTINUE;
                        }
                        return FileVisitResult.CONTINUE;
                    }
                });
            }
            catch (IOException ioException) {
                throw new RuntimeException("Unable to search for test file names in " + workingDirectory.toPath(), ioException);
            }
            long duration = System.currentTimeMillis() - start;
            System.out.println(JenkinsResultsParserUtil.combine("Found ", String.valueOf(_javaDirPathStrings.size()), " Java directories and ", String.valueOf(_javaTestClassFiles.size()), " Java test class files in ", workingDirectory.toString(), " in ", JenkinsResultsParserUtil.toDurationString(duration)));
            _javaFilesLoaded.set(true);
        }
    }

    private void _setAutoBalanceTestFiles() {
        JobProperty jobProperty = this.getJobProperty("test.class.names.auto.balance");
        String jobPropertyValue = jobProperty.getValue();
        if (JenkinsResultsParserUtil.isNullOrEmpty(jobPropertyValue)) {
            return;
        }
        this.recordJobProperty(jobProperty);
        for (String autoBalanceTestName : jobPropertyValue.split(",")) {
            String fullClassName = autoBalanceTestName.replaceAll(".*\\/?(com\\/.*)\\.(class|java)", "$1");
            fullClassName = fullClassName.replaceAll("/", "\\.");
            File javaTestClassFile = this.getJavaFileFromFullClassName(fullClassName);
            if (!JenkinsResultsParserUtil.isFileIncluded(null, this.getPathMatchers(this.getFilterJobProperties()), javaTestClassFile)) continue;
            this._autoBalanceTestFiles.add(javaTestClassFile);
        }
    }

    private void _setIncludeAutoBalanceTests() {
        if (!this.testClasses.isEmpty()) {
            this._includeAutoBalanceTests = true;
            return;
        }
        List<File> modifiedJavaFilesList = this.portalGitWorkingDirectory.getModifiedFilesList(this._includeUnstagedTestClassFiles, null, JenkinsResultsParserUtil.toPathMatchers(JenkinsResultsParserUtil.combine("**", File.separator, "*.java"), new String[0]));
        if (!this._autoBalanceTestFiles.isEmpty() && !modifiedJavaFilesList.isEmpty()) {
            this._includeAutoBalanceTests = true;
            return;
        }
        this._includeAutoBalanceTests = false;
    }
}

