/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser.test.clazz.group;

import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.PortalTestClassJob;
import com.liferay.jenkins.results.parser.job.property.JobProperty;
import com.liferay.jenkins.results.parser.test.clazz.group.BatchTestClassGroup;
import java.io.File;
import java.io.IOException;
import java.nio.file.PathMatcher;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONObject;

public abstract class ModulesBatchTestClassGroup
extends BatchTestClassGroup {
    protected Set<File> moduleDirsList = new HashSet<File>();

    @Override
    public JSONObject getJSONObject() {
        if (this.jsonObject != null) {
            return this.jsonObject;
        }
        this.jsonObject = super.getJSONObject();
        this.jsonObject.put("exclude_globs", this.getGlobs(this.getExcludesJobProperties()));
        this.jsonObject.put("include_globs", this.getGlobs(this.getIncludesJobProperties()));
        this.jsonObject.put("modified_dirs_list", this.moduleDirsList);
        return this.jsonObject;
    }

    protected ModulesBatchTestClassGroup(JSONObject jsonObject, PortalTestClassJob portalTestClassJob) {
        super(jsonObject, portalTestClassJob);
        JSONArray modifiedDirsJSONArray = jsonObject.optJSONArray("modified_dirs_list");
        if (modifiedDirsJSONArray == null || modifiedDirsJSONArray.isEmpty()) {
            return;
        }
        for (int i = 0; i < modifiedDirsJSONArray.length(); ++i) {
            String modifiedDirPath = modifiedDirsJSONArray.getString(i);
            if (JenkinsResultsParserUtil.isNullOrEmpty(modifiedDirPath)) continue;
            this.moduleDirsList.add(new File(modifiedDirPath));
        }
    }

    protected ModulesBatchTestClassGroup(String batchName, PortalTestClassJob portalTestClassJob) {
        super(batchName, portalTestClassJob);
        if (this.ignore()) {
            return;
        }
        try {
            if (this.testRelevantChanges) {
                this.moduleDirsList.addAll(this.getRequiredModuleDirs(this.portalGitWorkingDirectory.getModifiedModuleDirsList(this.getPathMatchers(this.getExcludesJobProperties()), this.getPathMatchers(this.getIncludesJobProperties()))));
            }
            this.setTestClasses();
            this.setAxisTestClassGroups();
            this.setSegmentTestClassGroups();
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
    }

    protected List<JobProperty> getExcludesJobProperties() {
        ArrayList<JobProperty> excludesJobProperties = new ArrayList<JobProperty>();
        File modulesDir = new File(this.portalGitWorkingDirectory.getWorkingDirectory(), "modules");
        String upstreamBranchName = this.portalGitWorkingDirectory.getUpstreamBranchName();
        if (upstreamBranchName.startsWith("ee-") || upstreamBranchName.endsWith("-private")) {
            excludesJobProperties.add(this.getJobProperty("modules.excludes.private", this.testSuiteName, modulesDir, JobProperty.Type.EXCLUDE_GLOB));
            if (this.includeStableTestSuite && this.isStableTestSuiteBatch()) {
                excludesJobProperties.add(this.getJobProperty("modules.excludes.private", "stable", modulesDir, JobProperty.Type.EXCLUDE_GLOB));
            }
        } else {
            excludesJobProperties.add(this.getJobProperty("modules.excludes.public", this.testSuiteName, modulesDir, JobProperty.Type.EXCLUDE_GLOB));
            if (this.includeStableTestSuite && this.isStableTestSuiteBatch()) {
                excludesJobProperties.add(this.getJobProperty("modules.excludes.public", "stable", modulesDir, JobProperty.Type.EXCLUDE_GLOB));
            }
        }
        excludesJobProperties.add(this.getJobProperty("modules.excludes", this.testSuiteName, modulesDir, JobProperty.Type.EXCLUDE_GLOB));
        excludesJobProperties.add(this.getJobProperty("modules.excludes." + (Object)((Object)this.portalTestClassJob.getBuildProfile()), modulesDir, JobProperty.Type.EXCLUDE_GLOB));
        this.recordJobProperties(excludesJobProperties);
        return excludesJobProperties;
    }

    protected List<JobProperty> getIncludesJobProperties() {
        ArrayList<JobProperty> includesJobProperties = new ArrayList<JobProperty>();
        File modulesDir = new File(this.portalGitWorkingDirectory.getWorkingDirectory(), "modules");
        String upstreamBranchName = this.portalGitWorkingDirectory.getUpstreamBranchName();
        if (upstreamBranchName.startsWith("ee-") || upstreamBranchName.endsWith("-private")) {
            includesJobProperties.add(this.getJobProperty("modules.includes.private", this.testSuiteName, modulesDir, JobProperty.Type.INCLUDE_GLOB));
            if (this.includeStableTestSuite && this.isStableTestSuiteBatch()) {
                includesJobProperties.add(this.getJobProperty("modules.includes.private", "stable", modulesDir, JobProperty.Type.INCLUDE_GLOB));
            }
        } else {
            includesJobProperties.add(this.getJobProperty("modules.includes.public", this.testSuiteName, modulesDir, JobProperty.Type.INCLUDE_GLOB));
            if (this.includeStableTestSuite && this.isStableTestSuiteBatch()) {
                includesJobProperties.add(this.getJobProperty("modules.includes.public", "stable", modulesDir, JobProperty.Type.INCLUDE_GLOB));
            }
        }
        includesJobProperties.add(this.getJobProperty("modules.includes", this.testSuiteName, modulesDir, JobProperty.Type.INCLUDE_GLOB));
        includesJobProperties.add(this.getJobProperty("modules.includes." + (Object)((Object)this.portalTestClassJob.getBuildProfile()), this.testSuiteName, modulesDir, JobProperty.Type.INCLUDE_GLOB));
        this.recordJobProperties(includesJobProperties);
        return includesJobProperties;
    }

    protected List<PathMatcher> getIncludesPathMatchers() {
        if (!this.isRootCauseAnalysis()) {
            return this.getPathMatchers(this.getIncludesJobProperties());
        }
        String portalBatchTestSelector = System.getenv("PORTAL_BATCH_TEST_SELECTOR");
        if (JenkinsResultsParserUtil.isNullOrEmpty(portalBatchTestSelector)) {
            portalBatchTestSelector = this.getBuildStartProperty("PORTAL_BATCH_TEST_SELECTOR");
        }
        ArrayList includeGlobs = new ArrayList();
        if (!JenkinsResultsParserUtil.isNullOrEmpty(portalBatchTestSelector)) {
            Collections.addAll(includeGlobs, JenkinsResultsParserUtil.getGlobsFromProperty(portalBatchTestSelector));
        }
        File portalModulesBaseDir = new File(this.portalGitWorkingDirectory.getWorkingDirectory(), "modules");
        return JenkinsResultsParserUtil.toPathMatchers(JenkinsResultsParserUtil.combine(JenkinsResultsParserUtil.getCanonicalPath(portalModulesBaseDir), File.separator), includeGlobs.toArray(new String[0]));
    }

    protected abstract void setTestClasses() throws IOException;
}

