/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser.test.clazz.group;

import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.PortalTestClassJob;
import com.liferay.jenkins.results.parser.test.clazz.NPMTestClass;
import com.liferay.jenkins.results.parser.test.clazz.TestClass;
import com.liferay.jenkins.results.parser.test.clazz.TestClassFactory;
import com.liferay.jenkins.results.parser.test.clazz.TestClassMethod;
import com.liferay.jenkins.results.parser.test.clazz.group.AxisTestClassGroup;
import com.liferay.jenkins.results.parser.test.clazz.group.BatchTestClassGroup;
import com.liferay.jenkins.results.parser.test.clazz.group.TestClassGroupFactory;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.StringEscapeUtils;
import org.json.JSONObject;

public class NPMTestBatchTestClassGroup
extends BatchTestClassGroup {
    private static final String _TOKEN_CLASS_METHOD_SEPARATOR = "::";

    @Override
    public AxisTestClassGroup getAxisTestClassGroup(int axisId) {
        if (axisId != 0) {
            throw new IllegalArgumentException("axisId is not 0");
        }
        AxisTestClassGroup axisTestClassGroup = (AxisTestClassGroup)this.axisTestClassGroups.get(axisId);
        if (axisTestClassGroup != null) {
            return (AxisTestClassGroup)this.axisTestClassGroups.get(axisId);
        }
        return TestClassGroupFactory.newAxisTestClassGroup(this);
    }

    public void writeTestCSVReportFile() throws Exception {
        BatchTestClassGroup.CSVReport csvReport = new BatchTestClassGroup.CSVReport(new BatchTestClassGroup.CSVReport.Row("Module Name", "Class Name", "Method Name", "Ignored", "File Path"));
        for (NPMTestClass npmTestClass : TestClassFactory.getNPMTestClasses()) {
            File moduleTestClassFile = npmTestClass.getTestClassFile();
            String moduleName = moduleTestClassFile.getName();
            List<TestClassMethod> jsTestClassMethods = npmTestClass.getJSTestClassMethods();
            for (TestClassMethod jsTestClassMethod : jsTestClassMethods) {
                String classMethodName = jsTestClassMethod.getName();
                int colonIndex = classMethodName.indexOf(_TOKEN_CLASS_METHOD_SEPARATOR);
                String filePath = classMethodName.substring(0, colonIndex);
                String className = filePath.substring(filePath.lastIndexOf("/") + 1);
                String methodName = classMethodName.substring(colonIndex + _TOKEN_CLASS_METHOD_SEPARATOR.length());
                BatchTestClassGroup.CSVReport.Row csvReportRow = new BatchTestClassGroup.CSVReport.Row();
                csvReportRow.add(moduleName);
                csvReportRow.add(className);
                csvReportRow.add(StringEscapeUtils.escapeCsv((String)methodName));
                if (jsTestClassMethod.isIgnored()) {
                    csvReportRow.add("TRUE");
                } else {
                    csvReportRow.add("");
                }
                csvReportRow.add(filePath);
                csvReport.addRow(csvReportRow);
            }
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MM-dd-yyyy");
        File csvReportFile = new File(JenkinsResultsParserUtil.combine("Report_js_", simpleDateFormat.format(new Date()), ".csv"));
        try {
            JenkinsResultsParserUtil.write(csvReportFile, csvReport.toString());
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
    }

    protected NPMTestBatchTestClassGroup(JSONObject jsonObject, PortalTestClassJob portalTestClassJob) {
        super(jsonObject, portalTestClassJob);
    }

    protected NPMTestBatchTestClassGroup(String batchName, PortalTestClassJob portalTestClassJob) {
        super(batchName, portalTestClassJob);
        List<File> moduleDirs;
        if (this.ignore()) {
            return;
        }
        try {
            moduleDirs = !(!this.testRelevantChanges || this.includeStableTestSuite && this.isStableTestSuiteBatch()) ? this.portalGitWorkingDirectory.getModifiedNPMTestModuleDirsList() : this.portalGitWorkingDirectory.getNPMTestModuleDirsList();
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
        if (moduleDirs.isEmpty()) {
            return;
        }
        AxisTestClassGroup axisTestClassGroup = TestClassGroupFactory.newAxisTestClassGroup(this);
        for (File moduleDir : moduleDirs) {
            TestClass testClass = TestClassFactory.newTestClass((BatchTestClassGroup)this, moduleDir);
            if (!testClass.hasTestClassMethods()) continue;
            this.testClasses.add(testClass);
            axisTestClassGroup.addTestClass(testClass);
        }
        this.axisTestClassGroups.add(0, axisTestClassGroup);
    }
}

