/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser.test.clazz.group;

import com.liferay.jenkins.results.parser.AntUtil;
import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.NotificationUtil;
import com.liferay.jenkins.results.parser.PortalGitWorkingDirectory;
import com.liferay.jenkins.results.parser.PortalTestClassJob;
import com.liferay.jenkins.results.parser.job.property.JobProperty;
import com.liferay.jenkins.results.parser.test.batch.PlaywrightTestBatch;
import com.liferay.jenkins.results.parser.test.batch.PlaywrightTestSelector;
import com.liferay.jenkins.results.parser.test.clazz.TestClass;
import com.liferay.jenkins.results.parser.test.clazz.TestClassFactory;
import com.liferay.jenkins.results.parser.test.clazz.group.AxisTestClassGroup;
import com.liferay.jenkins.results.parser.test.clazz.group.BatchTestClassGroup;
import com.liferay.jenkins.results.parser.test.clazz.group.PlaywrightSegmentTestClassGroup;
import com.liferay.jenkins.results.parser.test.clazz.group.SegmentTestClassGroup;
import com.liferay.jenkins.results.parser.test.clazz.group.TestClassGroupFactory;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringEscapeUtils;
import org.json.JSONArray;
import org.json.JSONObject;

public class PlaywrightBatchTestClassGroup
extends BatchTestClassGroup {
    private static final Pattern _playwrightFileNamePattern = Pattern.compile("tests/(?<filePath>(?<projectName>[^/]+)/.*.spec.ts)");
    private static JSONObject _playwrightJSONObject;
    private static final AtomicBoolean _playwrightJSONObjectsLoaded;
    private static final List<JSONObject> _specJSONObjects;
    private final Set<String> _projectNames = new HashSet<String>();

    public void addDefaultProjectJobProperty(String batchName) {
        if (this.isRootCauseAnalysis()) {
            Matcher matcher;
            String portalBatchTestSelector = System.getenv("PORTAL_BATCH_TEST_SELECTOR");
            if (JenkinsResultsParserUtil.isNullOrEmpty(portalBatchTestSelector)) {
                portalBatchTestSelector = this.getBuildStartProperty("PORTAL_BATCH_TEST_SELECTOR");
            }
            if ((matcher = _playwrightFileNamePattern.matcher(portalBatchTestSelector)).matches()) {
                this._addProjectNames(matcher.group("projectName"));
            } else {
                this._addProjectNames(portalBatchTestSelector);
            }
            return;
        }
        ArrayList<JobProperty> jobProperties = new ArrayList<JobProperty>();
        JobProperty playwrightProjectsIncludesJobProperty = this._getPlaywrightProjectsIncludesJobProperty();
        if (playwrightProjectsIncludesJobProperty == null) {
            this._addProjectNames(this._getDefaultProjectNames());
        } else {
            this._addProjectNames(playwrightProjectsIncludesJobProperty.getValue());
            jobProperties.add(playwrightProjectsIncludesJobProperty);
        }
        JobProperty playwrightProjectsExcludesJobProperty = this.getJobProperty("playwright.projects.excludes", this.testSuiteName, batchName);
        String playwrightProjectsExcludesJobPropertyValue = playwrightProjectsExcludesJobProperty.getValue();
        if (!JenkinsResultsParserUtil.isNullOrEmpty(playwrightProjectsExcludesJobPropertyValue)) {
            this.removeProjectNames(playwrightProjectsExcludesJobPropertyValue);
            jobProperties.add(playwrightProjectsExcludesJobProperty);
        }
        this.recordJobProperties(jobProperties);
    }

    protected PlaywrightBatchTestClassGroup(JSONObject jsonObject, PortalTestClassJob portalTestClassJob) {
        super(jsonObject, portalTestClassJob);
    }

    protected PlaywrightBatchTestClassGroup(String batchName, PlaywrightTestBatch playwrightTestBatch, PortalTestClassJob portalTestClassJob) {
        super(batchName, portalTestClassJob);
        PlaywrightTestSelector playwrightTestSelector = (PlaywrightTestSelector)playwrightTestBatch.getTestSelector();
        Set<JobProperty> playwrightJobProperties = playwrightTestSelector.getPlaywrightJobProperties();
        playwrightJobProperties.removeAll(Collections.singleton(null));
        for (JobProperty jobProperty : playwrightJobProperties) {
            Collections.addAll(this._projectNames, jobProperty.getValue().split(","));
        }
        JobProperty excludesJobProperty = playwrightTestSelector.getPlaywrightExcludesJobProperty();
        if (excludesJobProperty != null) {
            this.removeProjectNames(excludesJobProperty.getValue());
            playwrightJobProperties.add(excludesJobProperty);
        }
        this.recordJobProperties(new ArrayList<JobProperty>(playwrightJobProperties));
        this.setTestClasses();
    }

    protected PlaywrightBatchTestClassGroup(String batchName, PortalTestClassJob portalTestClassJob) {
        super(batchName, portalTestClassJob);
        if (this.ignore()) {
            return;
        }
        if (this.testRelevantChanges) {
            List<JobProperty> relevantPlaywrightJobProperties = this.getRelevantPlaywrightJobProperties();
            if (!relevantPlaywrightJobProperties.isEmpty()) {
                this.recordJobProperties(relevantPlaywrightJobProperties);
            }
        } else {
            this.addDefaultProjectJobProperty(batchName);
        }
        this.setTestClasses();
    }

    protected int getAxisCount(List<TestClass> testClasses) {
        JobProperty jobProperty;
        String jobPropertyValue;
        long totalDuration = 0L;
        for (TestClass testClass : testClasses) {
            totalDuration += testClass.getAverageDuration();
        }
        if (totalDuration != 0L && JenkinsResultsParserUtil.isInteger(jobPropertyValue = (jobProperty = this.getJobProperty("test.batch.target.axis.duration")).getValue())) {
            this.recordJobProperty(jobProperty);
            long testBatchTargetAxisDuration = Long.parseLong(jobPropertyValue);
            long axisCount = Math.floorDiv(totalDuration, testBatchTargetAxisDuration) + 1L;
            return Math.toIntExact(axisCount);
        }
        return this.getAxisCount();
    }

    protected File getPlaywrightBaseDir() {
        PortalTestClassJob portalTestClassJob = (PortalTestClassJob)this.getJob();
        PortalGitWorkingDirectory portalGitWorkingDirectory = portalTestClassJob.getPortalGitWorkingDirectory();
        return new File(portalGitWorkingDirectory.getWorkingDirectory(), "modules/test/playwright");
    }

    protected List<JobProperty> getRelevantPlaywrightJobProperties() {
        HashSet<JobProperty> playwrightJobProperties = new HashSet<JobProperty>();
        for (File modifiedFile : this.portalGitWorkingDirectory.getModifiedFilesList(false)) {
            List<JobProperty> playwrightTestProjectJobProperties = this.getJobProperties(modifiedFile, "playwright.test.project", JobProperty.Type.MODULE_TEST_DIR, null);
            playwrightTestProjectJobProperties.addAll(this.getJobProperties(modifiedFile, "playwright.projects.includes", JobProperty.Type.MODULE_TEST_DIR, null));
            for (JobProperty playwrightTestProjectJobProperty : playwrightTestProjectJobProperties) {
                if (playwrightTestProjectJobProperty.getValue() == null) continue;
                String projectNames = playwrightTestProjectJobProperty.getValue();
                this._addProjectNames(projectNames);
                playwrightJobProperties.add(playwrightTestProjectJobProperty);
            }
            List<JobProperty> playwrightExcludeProjectJobProperties = this.getJobProperties(modifiedFile, "playwright.projects.excludes", JobProperty.Type.MODULE_TEST_DIR, null);
            for (JobProperty playwrightExcludeProjectJobProperty : playwrightExcludeProjectJobProperties) {
                if (playwrightExcludeProjectJobProperty.getValue() == null) continue;
                String projectNames = playwrightExcludeProjectJobProperty.getValue();
                this.removeProjectNames(projectNames);
                playwrightJobProperties.add(playwrightExcludeProjectJobProperty);
            }
        }
        playwrightJobProperties.removeAll(Collections.singleton(null));
        return new ArrayList<JobProperty>(playwrightJobProperties);
    }

    protected List<JSONObject> getSpecJSONObjects() {
        return _specJSONObjects;
    }

    protected void removeProjectNames(String jobPropertyValue) {
        String[] excludesProjectNames;
        for (String excludeProjectName : excludesProjectNames = jobPropertyValue.split("\\s*,\\s*")) {
            this._projectNames.remove(excludeProjectName);
        }
    }

    protected void setTestClasses() {
        long start = System.currentTimeMillis();
        this._loadPlaywrightJSONObjects();
        for (String projectName : this._projectNames) {
            SegmentTestClassGroup segmentTestClassGroup;
            List<TestClass> testClasses = this._getTestClasses(projectName);
            if (testClasses.isEmpty() || !((segmentTestClassGroup = TestClassGroupFactory.newSegmentTestClassGroup(this)) instanceof PlaywrightSegmentTestClassGroup)) continue;
            PlaywrightSegmentTestClassGroup playwrightSegmentTestClassGroup = (PlaywrightSegmentTestClassGroup)segmentTestClassGroup;
            playwrightSegmentTestClassGroup.setProjectName(projectName);
            int axisCount = this.getAxisCount(testClasses);
            if (axisCount >= 1) {
                for (int axisIndex = 0; axisIndex < axisCount; ++axisIndex) {
                    AxisTestClassGroup axisTestClassGroup = TestClassGroupFactory.newAxisTestClassGroup(this);
                    playwrightSegmentTestClassGroup.addAxisTestClassGroup(axisTestClassGroup);
                    StringBuilder sb = new StringBuilder();
                    sb.append("npx playwright test --project=");
                    sb.append(projectName);
                    sb.append(" --shard=");
                    sb.append(axisIndex + 1);
                    sb.append("/");
                    sb.append(axisCount);
                    sb.append(" --list");
                    String result = this._callNPMCommand(this.getPlaywrightBaseDir(), sb.toString());
                    for (TestClass testClass : testClasses) {
                        if (!result.contains(testClass.getName())) continue;
                        axisTestClassGroup.addTestClass(testClass);
                    }
                    this.addAxisTestClassGroup(axisTestClassGroup);
                }
            }
            for (TestClass testClass : testClasses) {
                this.addTestClass(testClass);
            }
            this.addSegmentTestClassGroup(playwrightSegmentTestClassGroup);
        }
        List<TestClass> testClasses = this.getTestClasses();
        long duration = System.currentTimeMillis() - start;
        System.out.println(JenkinsResultsParserUtil.combine("[", this.getBatchName(), "] ", "Found ", String.valueOf(testClasses.size()), " Playwright test classes in ", JenkinsResultsParserUtil.toDurationString(duration)));
    }

    private void _addProjectNames(String projectNames) {
        projectNames = projectNames.trim();
        Collections.addAll(this._projectNames, projectNames.split("\\s*,\\s*"));
    }

    private String _callNPMCommand(File baseDir, String npmCommand) {
        String nodeHome;
        StringBuilder sb = new StringBuilder();
        if (JenkinsResultsParserUtil.isCINode()) {
            sb.append("export CI=true\n");
        }
        sb.append("export PATH=");
        String npmHome = this._getPortalProperty("npm.home");
        if (!JenkinsResultsParserUtil.isNullOrEmpty(npmHome)) {
            sb.append(npmHome);
            sb.append(":");
        }
        if (!JenkinsResultsParserUtil.isNullOrEmpty(nodeHome = this._getPortalProperty("node.home"))) {
            sb.append(nodeHome);
            sb.append("/bin:");
        }
        sb.append("${PATH}\n");
        sb.append(npmCommand);
        File npmScriptFile = new File(baseDir, "npm_script.sh");
        try {
            JenkinsResultsParserUtil.write(npmScriptFile, sb.toString());
            Process process = JenkinsResultsParserUtil.executeBashCommands(true, baseDir, 600000L, sb.toString());
            String string = JenkinsResultsParserUtil.readInputStream(process.getInputStream());
            return string;
        }
        catch (IOException | TimeoutException exception) {
            throw new RuntimeException(exception);
        }
        finally {
            JenkinsResultsParserUtil.delete(npmScriptFile);
        }
    }

    private String _getDefaultProjectNames() {
        String playwrightProjectName = System.getenv("PLAYWRIGHT_PROJECT_NAME");
        if (!JenkinsResultsParserUtil.isNullOrEmpty(playwrightProjectName)) {
            return playwrightProjectName;
        }
        this._loadPlaywrightJSONObjects();
        StringBuilder sb = new StringBuilder();
        JSONObject configJSONObject = _playwrightJSONObject.getJSONObject("config");
        JSONArray projectsJSONArray = configJSONObject.optJSONArray("projects");
        for (int i = 0; i < projectsJSONArray.length(); ++i) {
            JSONObject projectJSONObject = projectsJSONArray.getJSONObject(i);
            sb.append(projectJSONObject.optString("name"));
            sb.append(",");
        }
        sb.setLength(sb.length() - 1);
        return sb.toString();
    }

    private JobProperty _getPlaywrightProjectsIncludesJobProperty() {
        JobProperty playwrightProjectsIncludesJobProperty = this.getJobProperty("playwright.test.project", this.testSuiteName, this.batchName);
        String playwrightProjectsIncludesJobPropertyValue = playwrightProjectsIncludesJobProperty.getValue();
        if (!JenkinsResultsParserUtil.isNullOrEmpty(playwrightProjectsIncludesJobPropertyValue)) {
            return playwrightProjectsIncludesJobProperty;
        }
        playwrightProjectsIncludesJobProperty = this.getJobProperty("playwright.projects.includes", this.testSuiteName, this.batchName);
        playwrightProjectsIncludesJobPropertyValue = playwrightProjectsIncludesJobProperty.getValue();
        if (!JenkinsResultsParserUtil.isNullOrEmpty(playwrightProjectsIncludesJobPropertyValue)) {
            return playwrightProjectsIncludesJobProperty;
        }
        return null;
    }

    private String _getPortalProperty(String propertyName) {
        File workingDirectory = JenkinsResultsParserUtil.getCanonicalFile(this.portalGitWorkingDirectory.getWorkingDirectory());
        Properties portalProperties = JenkinsResultsParserUtil.getProperties(new File(workingDirectory, "build.properties"), new File(workingDirectory, "app.server.properties"), new File(workingDirectory, "release.properties"), new File(workingDirectory, "test.properties"));
        portalProperties.setProperty("project.dir", workingDirectory.toString());
        return JenkinsResultsParserUtil.getProperty(portalProperties, propertyName);
    }

    private List<JSONObject> _getSpecJSONObjects(JSONObject jsonObject) {
        ArrayList<JSONObject> specJSONObjects = new ArrayList<JSONObject>();
        JSONArray suitesJSONArray = jsonObject.getJSONArray("suites");
        for (int i = 0; i < suitesJSONArray.length(); ++i) {
            JSONArray specsJSONArray;
            JSONObject suiteJSONObject = suitesJSONArray.getJSONObject(i);
            if (suiteJSONObject.has("suites")) {
                specJSONObjects.addAll(this._getSpecJSONObjects(suiteJSONObject));
            }
            if ((specsJSONArray = suiteJSONObject.optJSONArray("specs")) == null) continue;
            String file = suiteJSONObject.getString("file");
            String title = suiteJSONObject.getString("title");
            for (int j = 0; j < specsJSONArray.length(); ++j) {
                JSONObject specJSONObject = specsJSONArray.getJSONObject(j);
                if (!title.equals(file)) {
                    specJSONObject.put("subSuite", (Object)title);
                }
                specJSONObjects.add(specJSONObject);
                specJSONObjects.add(specsJSONArray.getJSONObject(j));
            }
        }
        return specJSONObjects;
    }

    private List<TestClass> _getTestClasses(String projectName) {
        ArrayList<TestClass> testClasses = new ArrayList<TestClass>();
        JSONObject configJSONObject = _playwrightJSONObject.getJSONObject("config");
        File rootDir = new File(configJSONObject.getString("rootDir"));
        HashMap specTitlesMap = new HashMap();
        for (JSONObject jSONObject : this.getSpecJSONObjects()) {
            JSONObject testJSONObject;
            JSONArray testsJSONArray = jSONObject.optJSONArray("tests");
            if (testsJSONArray == null || testsJSONArray.isEmpty() || !Objects.equals(projectName, (testJSONObject = testsJSONArray.getJSONObject(0)).optString("projectName"))) continue;
            File specFile = new File(rootDir, jSONObject.getString("file"));
            HashSet<String> specTitles = (HashSet<String>)specTitlesMap.get(specFile);
            if (specTitles == null) {
                specTitles = new HashSet<String>();
            }
            if (jSONObject.has("subSuite")) {
                specTitles.add(jSONObject.getString("subSuite") + " \u203a " + jSONObject.getString("title"));
            } else {
                specTitles.add(jSONObject.getString("title"));
            }
            specTitlesMap.put(specFile, specTitles);
        }
        if (this.isRootCauseAnalysis()) {
            Matcher matcher;
            String portalBatchTestSelector = System.getenv("PORTAL_BATCH_TEST_SELECTOR");
            if (JenkinsResultsParserUtil.isNullOrEmpty(portalBatchTestSelector)) {
                portalBatchTestSelector = this.getBuildStartProperty("PORTAL_BATCH_TEST_SELECTOR");
            }
            if ((matcher = _playwrightFileNamePattern.matcher(portalBatchTestSelector)).matches()) {
                File specFile = new File(rootDir, matcher.group("filePath"));
                TestClass testClass = TestClassFactory.newTestClass((BatchTestClassGroup)this, specFile);
                for (String specTitle : (Set)specTitlesMap.getOrDefault(specFile, new HashSet())) {
                    testClass.addTestClassMethod(TestClassFactory.newTestClassMethod(false, specTitle, testClass));
                }
                testClasses.add(testClass);
                return testClasses;
            }
        }
        for (Map.Entry entry : specTitlesMap.entrySet()) {
            TestClass testClass = TestClassFactory.newTestClass((BatchTestClassGroup)this, (File)entry.getKey());
            for (String specTitle : (Set)entry.getValue()) {
                testClass.addTestClassMethod(TestClassFactory.newTestClassMethod(false, specTitle, testClass));
            }
            testClasses.add(testClass);
        }
        return testClasses;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _loadPlaywrightJSONObjects() {
        AtomicBoolean atomicBoolean = _playwrightJSONObjectsLoaded;
        synchronized (atomicBoolean) {
            if (_playwrightJSONObjectsLoaded.get()) {
                return;
            }
            File playwrightBaseDir = this.getPlaywrightBaseDir();
            try {
                AntUtil.callTarget(this.portalGitWorkingDirectory.getWorkingDirectory(), "build.xml", "setup-yarn");
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            try {
                this._callNPMCommand(playwrightBaseDir, "npm install");
                String result = this._callNPMCommand(playwrightBaseDir, "npm run playwright test -- --list --reporter=json");
                int index = result.indexOf("\n{");
                result = result.substring(index);
                result = result.replace("Finished executing Bash commands.", "");
                _playwrightJSONObject = new JSONObject(result.trim());
            }
            catch (Exception exception) {
                StringBuilder sb = new StringBuilder();
                sb.append("Unable to parse Playwright JSON object ");
                sb.append("<@U04GTH03Q>, <@U01EV0V1Y6N>\n");
                sb.append(System.getenv("TOP_LEVEL_BUILD_URL"));
                NotificationUtil.sendSlackNotification(sb.toString(), "#ci-notifications", ":playwright:", "Playwright batch creation failure", "Liferay Playwright");
                exception.printStackTrace();
            }
            JSONArray errorsJSONArray = _playwrightJSONObject.optJSONArray("errors");
            if (errorsJSONArray != null && errorsJSONArray.length() > 0) {
                StringBuilder sb = new StringBuilder();
                sb.append("Errors found in Playwright tests.\n");
                for (int i = 0; i < errorsJSONArray.length(); ++i) {
                    String errorSnippet;
                    String errorStack;
                    JSONObject errorLocationJSONObject;
                    JSONObject errorJSONObject = errorsJSONArray.getJSONObject(i);
                    System.out.println(errorJSONObject);
                    String errorMessage = errorJSONObject.optString("message");
                    if (errorMessage != null && !errorMessage.isEmpty()) {
                        sb.append(errorMessage);
                    }
                    if ((errorLocationJSONObject = errorJSONObject.optJSONObject("location")) != null) {
                        sb.append(" [file://");
                        sb.append(errorLocationJSONObject.opt("file"));
                        sb.append(":");
                        sb.append(errorLocationJSONObject.opt("line"));
                        sb.append(":");
                        sb.append(errorLocationJSONObject.opt("column"));
                        sb.append("]");
                    }
                    if ((errorStack = errorJSONObject.optString("stack")) != null && !errorStack.isEmpty()) {
                        sb.append("\n");
                        sb.append(errorStack);
                    }
                    if ((errorSnippet = errorJSONObject.optString("snippet")) != null && !errorSnippet.isEmpty()) {
                        sb.append("\n");
                        sb.append(StringEscapeUtils.unescapeJava((String)errorSnippet));
                    }
                    sb.append("\n");
                }
                System.out.println(sb.toString());
                throw new RuntimeException(sb.toString());
            }
            _specJSONObjects.addAll(this._getSpecJSONObjects(_playwrightJSONObject));
            _playwrightJSONObjectsLoaded.set(true);
        }
    }

    static {
        _playwrightJSONObjectsLoaded = new AtomicBoolean();
        _specJSONObjects = Collections.synchronizedList(new ArrayList());
    }
}

