/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser.test.clazz.group;

import com.liferay.jenkins.results.parser.job.property.JobProperty;
import com.liferay.jenkins.results.parser.test.clazz.group.BatchTestClassGroup;
import com.liferay.jenkins.results.parser.test.clazz.group.PlaywrightBatchTestClassGroup;
import com.liferay.jenkins.results.parser.test.clazz.group.SegmentTestClassGroup;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONObject;

public class PlaywrightSegmentTestClassGroup
extends SegmentTestClassGroup {
    private String _projectName;

    public String getProjectName() {
        return this._projectName;
    }

    @Override
    public String getTestCasePropertiesContent() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.getTestCasePropertiesContent());
        PlaywrightBatchTestClassGroup playwrightBatchTestClassGroup = (PlaywrightBatchTestClassGroup)this.getBatchTestClassGroup();
        if (playwrightBatchTestClassGroup.testRelevantChanges) {
            List<JobProperty> jobProperties = playwrightBatchTestClassGroup.getRelevantPlaywrightJobProperties();
            List<JobProperty> playwrightTestProjectJobProperties = this._getJobProperties("playwright.test.project", jobProperties);
            String playwrightTestProjectProperty = this._concatPropertyValues(playwrightTestProjectJobProperties, " ");
            if (playwrightTestProjectProperty != null) {
                sb.append(playwrightTestProjectProperty);
                sb.append("\n");
            }
        } else {
            JobProperty jobProperty = playwrightBatchTestClassGroup.getJobProperty("playwright.test.project", playwrightBatchTestClassGroup.testSuiteName, playwrightBatchTestClassGroup.batchName);
            if (jobProperty.getValue() != null) {
                sb.append(jobProperty.getBasePropertyName());
                sb.append("=");
                sb.append(jobProperty.getValue());
                sb.append("\n");
            }
        }
        int axisCount = this.getAxisCount();
        if (axisCount >= 1) {
            for (int axisIndex = 0; axisIndex < this.getAxisCount(); ++axisIndex) {
                sb.append("PLAYWRIGHT_ARGS_");
                sb.append(axisIndex);
                sb.append("=--shard=");
                sb.append(axisIndex + 1);
                sb.append("/");
                sb.append(axisCount);
                sb.append("\n");
            }
        }
        sb.append("PLAYWRIGHT_PROJECT_NAME=");
        sb.append(this.getProjectName());
        return sb.toString();
    }

    public void setProjectName(String projectName) {
        this._projectName = projectName;
    }

    protected PlaywrightSegmentTestClassGroup(BatchTestClassGroup parentBatchTestClassGroup) {
        super(parentBatchTestClassGroup);
    }

    protected PlaywrightSegmentTestClassGroup(BatchTestClassGroup parentBatchTestClassGroup, JSONObject jsonObject) {
        super(parentBatchTestClassGroup, jsonObject);
    }

    private String _concatPropertyValues(List<JobProperty> jobProperties, String delimiter) {
        if (jobProperties.isEmpty()) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (JobProperty jobProperty : jobProperties) {
            if (jobProperty.getValue() == null) continue;
            sb.append(jobProperty.getValue());
            sb.append(delimiter);
        }
        if (sb.length() > 0) {
            JobProperty jobProperty = jobProperties.get(0);
            sb.insert(0, "=");
            sb.insert(0, jobProperty.getBasePropertyName());
            sb.setLength(sb.length() - delimiter.length());
        }
        return sb.toString();
    }

    private List<JobProperty> _getJobProperties(String propertyName, List<JobProperty> jobProperties) {
        ArrayList<JobProperty> filteredJobProperties = new ArrayList<JobProperty>();
        for (JobProperty jobProperty : jobProperties) {
            if (!propertyName.equals(jobProperty.getBasePropertyName())) continue;
            filteredJobProperties.add(jobProperty);
        }
        return filteredJobProperties;
    }
}

