/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser.test.clazz.group;

import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.PluginsGitWorkingDirectory;
import com.liferay.jenkins.results.parser.PortalTestClassJob;
import com.liferay.jenkins.results.parser.job.property.JobProperty;
import com.liferay.jenkins.results.parser.test.clazz.TestClassFactory;
import com.liferay.jenkins.results.parser.test.clazz.group.BatchTestClassGroup;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.json.JSONObject;

public class PluginsBatchTestClassGroup
extends BatchTestClassGroup {
    private final PluginsGitWorkingDirectory _pluginsGitWorkingDirectory;

    @Override
    public JSONObject getJSONObject() {
        if (this.jsonObject != null) {
            return this.jsonObject;
        }
        this.jsonObject = super.getJSONObject();
        this.jsonObject.put("exclude_globs", this.getGlobs(this._getExcludesJobProperties()));
        this.jsonObject.put("include_globs", this.getGlobs(this._getIncludesJobProperties()));
        return this.jsonObject;
    }

    protected PluginsBatchTestClassGroup(JSONObject jsonObject, PortalTestClassJob portalTestClassJob) {
        super(jsonObject, portalTestClassJob);
        this._pluginsGitWorkingDirectory = this.portalGitWorkingDirectory.getPluginsGitWorkingDirectory();
    }

    protected PluginsBatchTestClassGroup(String batchName, PortalTestClassJob portalTestClassJob) {
        super(batchName, portalTestClassJob);
        if (this.ignore()) {
            this._pluginsGitWorkingDirectory = null;
            return;
        }
        this._pluginsGitWorkingDirectory = this.portalGitWorkingDirectory.getPluginsGitWorkingDirectory();
        this.setTestClasses();
        this.setAxisTestClassGroups();
        this.setSegmentTestClassGroups();
    }

    protected void setTestClasses() {
        final List<PathMatcher> includesPathMatchers = this.getPathMatchers(this._getIncludesJobProperties());
        if (includesPathMatchers.isEmpty()) {
            return;
        }
        File workingDirectory = this._pluginsGitWorkingDirectory.getWorkingDirectory();
        final List<PathMatcher> excludesPathMatchers = this.getPathMatchers(this._getExcludesJobProperties());
        final ArrayList pluginsDirs = new ArrayList();
        try {
            Files.walkFileTree(workingDirectory.toPath(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult preVisitDirectory(Path filePath, BasicFileAttributes basicFileAttributes) throws IOException {
                    if (JenkinsResultsParserUtil.isFileExcluded((List<PathMatcher>)excludesPathMatchers, filePath)) {
                        return FileVisitResult.SKIP_SUBTREE;
                    }
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFile(Path filePath, BasicFileAttributes basicFileAttributes) throws IOException {
                    if (JenkinsResultsParserUtil.isFileIncluded((List<PathMatcher>)excludesPathMatchers, (List<PathMatcher>)includesPathMatchers, filePath)) {
                        File file = filePath.toFile();
                        pluginsDirs.add(file.getParentFile());
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException ioException) {
            throw new RuntimeException("Unable to search for test file names in " + workingDirectory.getPath(), ioException);
        }
        for (File pluginsDir : pluginsDirs) {
            this.testClasses.add(TestClassFactory.newTestClass((BatchTestClassGroup)this, pluginsDir));
        }
        Collections.sort(this.testClasses);
    }

    private List<JobProperty> _getExcludesJobProperties() {
        ArrayList<JobProperty> excludesJobProperties = new ArrayList<JobProperty>();
        excludesJobProperties.add(this.getJobProperty("test.batch.plugin.names.excludes", this._pluginsGitWorkingDirectory.getWorkingDirectory(), JobProperty.Type.EXCLUDE_GLOB));
        if (this.includeStableTestSuite && this.isStableTestSuiteBatch()) {
            excludesJobProperties.add(this.getJobProperty("test.batch.plugin.names.excludes", "stable", this._pluginsGitWorkingDirectory.getWorkingDirectory(), JobProperty.Type.EXCLUDE_GLOB));
        }
        this.recordJobProperties(excludesJobProperties);
        return excludesJobProperties;
    }

    private List<JobProperty> _getIncludesJobProperties() {
        ArrayList<JobProperty> includesJobProperties = new ArrayList<JobProperty>();
        includesJobProperties.add(this.getJobProperty("test.batch.plugin.names.includes", this._pluginsGitWorkingDirectory.getWorkingDirectory(), JobProperty.Type.INCLUDE_GLOB));
        if (this.includeStableTestSuite && this.isStableTestSuiteBatch()) {
            includesJobProperties.add(this.getJobProperty("test.batch.plugin.names.includes", "stable", this._pluginsGitWorkingDirectory.getWorkingDirectory(), JobProperty.Type.INCLUDE_GLOB));
        }
        this.recordJobProperties(includesJobProperties);
        return includesJobProperties;
    }
}

