/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser.test.clazz.group;

import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.PortalGitWorkingDirectory;
import com.liferay.jenkins.results.parser.PortalTestClassJob;
import com.liferay.jenkins.results.parser.test.clazz.TestClass;
import com.liferay.jenkins.results.parser.test.clazz.TestClassFactory;
import com.liferay.jenkins.results.parser.test.clazz.group.BatchTestClassGroup;
import com.liferay.jenkins.results.parser.test.clazz.group.ModulesBatchTestClassGroup;
import java.io.File;
import java.io.IOException;
import java.nio.file.PathMatcher;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.json.JSONObject;

public class SemVerModulesBatchTestClassGroup
extends ModulesBatchTestClassGroup {
    private static final Pattern _quarterlyReleaseNamePattern = Pattern.compile("(release-\\d{4}.[qQ](.\\d)?)");

    protected SemVerModulesBatchTestClassGroup(JSONObject jsonObject, PortalTestClassJob portalTestClassJob) {
        super(jsonObject, portalTestClassJob);
    }

    protected SemVerModulesBatchTestClassGroup(String batchName, PortalTestClassJob portalTestClassJob) {
        super(batchName, portalTestClassJob);
    }

    @Override
    protected boolean ignore() {
        if (!this.isStableTestSuiteBatch() && this.testRelevantJUnitTestsOnly) {
            return true;
        }
        return this.isStableTestSuiteBatch() && this.testRelevantJUnitTestsOnlyInStable || this.isQuarterlyReleaseBranch();
    }

    protected boolean isQuarterlyReleaseBranch() {
        Matcher quarterlyReleaseNameMatcher = _quarterlyReleaseNamePattern.matcher(this.portalGitWorkingDirectory.getUpstreamBranchName());
        return quarterlyReleaseNameMatcher.find();
    }

    @Override
    protected void setTestClasses() throws IOException {
        HashSet<File> moduleDirs = new HashSet<File>();
        List<PathMatcher> excludesPathMatchers = this.getPathMatchers(this.getExcludesJobProperties());
        List<PathMatcher> includesPathMatchers = this.getIncludesPathMatchers();
        PortalGitWorkingDirectory portalGitWorkingDirectory = this.getPortalGitWorkingDirectory();
        File portalModulesBaseDir = new File(portalGitWorkingDirectory.getWorkingDirectory(), "modules");
        if (!(!this.testRelevantChanges || this.includeStableTestSuite && this.isStableTestSuiteBatch())) {
            moduleDirs.addAll(portalGitWorkingDirectory.getModifiedModuleDirsList(excludesPathMatchers, includesPathMatchers));
        } else if (this.isRootCauseAnalysis()) {
            moduleDirs.addAll(portalGitWorkingDirectory.getModuleDirsList(excludesPathMatchers, includesPathMatchers));
        } else {
            moduleDirs.addAll(portalGitWorkingDirectory.getModuleDirsList(excludesPathMatchers, includesPathMatchers));
            List<File> semVerMarkerFiles = JenkinsResultsParserUtil.findFiles(portalModulesBaseDir, "\\.lfrbuild-semantic-versioning");
            semVerMarkerFiles = JenkinsResultsParserUtil.getIncludedFiles(excludesPathMatchers, includesPathMatchers, semVerMarkerFiles);
            for (File semVerMarkerFile : semVerMarkerFiles) {
                moduleDirs.add(semVerMarkerFile.getParentFile());
            }
        }
        for (File moduleDir : moduleDirs) {
            List<File> bndBndFiles = JenkinsResultsParserUtil.findFiles(moduleDir, "bnd.bnd");
            boolean exportPackageModule = false;
            for (File bndBndFile : bndBndFiles) {
                String bndBndFileContent = JenkinsResultsParserUtil.read(bndBndFile);
                if (bndBndFileContent == null || !bndBndFileContent.contains("Export-Package:")) continue;
                exportPackageModule = true;
            }
            if (!exportPackageModule) continue;
            this.moduleDirsList.add(moduleDir);
            TestClass testClass = TestClassFactory.newTestClass((BatchTestClassGroup)this, moduleDir);
            if (!testClass.hasTestClassMethods()) continue;
            this.testClasses.add(testClass);
        }
        Collections.sort(this.testClasses);
    }
}

